/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.constants;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileFunctions;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.constants.TiffDirectoryConstants;
import org.apache.sanselan.formats.tiff.constants.TiffFieldTypeConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.util.Debug;

public class TagInfo
implements TiffDirectoryConstants,
TiffFieldTypeConstants {
    protected static final int LENGTH_UNKNOWN = -1;
    public final String name;
    public final int tag;
    public final FieldType[] dataTypes;
    public final int length;
    public final TiffDirectoryConstants.ExifDirectoryType directoryType;

    public TagInfo(String name, int tag, FieldType dataType, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
        this(name, tag, new FieldType[]{dataType}, length, exifDirectory);
    }

    public TagInfo(String name, int tag, FieldType dataType, int length) {
        this(name, tag, new FieldType[]{dataType}, length, EXIF_DIRECTORY_UNKNOWN);
    }

    public TagInfo(String name, int tag, FieldType dataType, String lengthDescription) {
        this(name, tag, new FieldType[]{dataType}, -1, EXIF_DIRECTORY_UNKNOWN);
    }

    public TagInfo(String name, int tag, FieldType[] dataTypes, String lengthDescription) {
        this(name, tag, dataTypes, -1, EXIF_DIRECTORY_UNKNOWN);
    }

    public TagInfo(String name, int tag, FieldType dataType) {
        this(name, tag, dataType, -1, EXIF_DIRECTORY_UNKNOWN);
    }

    public TagInfo(String name, int tag, FieldType[] dataTypes, int length, String lengthDescription) {
        this(name, tag, dataTypes, length, EXIF_DIRECTORY_UNKNOWN);
    }

    public TagInfo(String name, int tag, FieldType[] dataTypes, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
        this.name = name;
        this.tag = tag;
        this.dataTypes = dataTypes;
        this.length = length;
        this.directoryType = exifDirectory;
    }

    public Object getValue(TiffField entry) throws ImageReadException {
        Object o = entry.fieldType.getSimpleValue(entry);
        return o;
    }

    public byte[] encodeValue(FieldType fieldType, Object value, int byteOrder) throws ImageWriteException {
        return fieldType.writeData(value, byteOrder);
    }

    public String getDescription() {
        return this.tag + " (0x" + Integer.toHexString(this.tag) + ": " + this.name + "): ";
    }

    public String toString() {
        return "[TagInfo. tag: " + this.tag + " (0x" + Integer.toHexString(this.tag) + ", name: " + this.name + "]";
    }

    public boolean isDate() {
        return false;
    }

    public boolean isOffset() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public static final class Unknown
    extends TagInfo {
        public Unknown(String name, int tag, FieldType[] dataTypes, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
            super(name, tag, dataTypes, length, exifDirectory);
        }

        public boolean isUnknown() {
            return true;
        }

        public byte[] encodeValue(FieldType fieldType, Object value, int byteOrder) throws ImageWriteException {
            byte[] result = super.encodeValue(fieldType, value, byteOrder);
            return result;
        }

        public Object getValue(TiffField entry) throws ImageReadException {
            return super.getValue(entry);
        }
    }

    public static final class Text
    extends TagInfo {
        private static final TextEncoding TEXT_ENCODING_ASCII = new TextEncoding(new byte[]{65, 83, 67, 73, 73, 0, 0, 0}, "US-ASCII");
        private static final TextEncoding TEXT_ENCODING_JIS = new TextEncoding(new byte[]{74, 73, 83, 0, 0, 0, 0, 0}, "JIS");
        private static final TextEncoding TEXT_ENCODING_UNICODE = new TextEncoding(new byte[]{85, 78, 73, 67, 79, 68, 69, 0}, "UTF-8");
        private static final TextEncoding TEXT_ENCODING_UNDEFINED = new TextEncoding(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}, "ISO-8859-1");
        private static final TextEncoding[] TEXT_ENCODINGS = new TextEncoding[]{TEXT_ENCODING_ASCII, TEXT_ENCODING_JIS, TEXT_ENCODING_UNICODE, TEXT_ENCODING_UNDEFINED};

        public Text(String name, int tag, FieldType dataType, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
            super(name, tag, dataType, length, exifDirectory);
        }

        public Text(String name, int tag, FieldType[] dataTypes, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
            super(name, tag, dataTypes, length, exifDirectory);
        }

        public boolean isText() {
            return true;
        }

        public byte[] encodeValue(FieldType fieldType, Object value, int byteOrder) throws ImageWriteException {
            if (!(value instanceof String)) {
                throw new ImageWriteException("Text value not String: " + value + " (" + Debug.getType(value) + ")");
            }
            String s = (String)value;
            try {
                byte[] asciiBytes = s.getBytes(Text.TEXT_ENCODING_ASCII.encodingName);
                String decodedAscii = new String(asciiBytes, Text.TEXT_ENCODING_ASCII.encodingName);
                if (decodedAscii.equals(s)) {
                    byte[] result = new byte[asciiBytes.length + Text.TEXT_ENCODING_ASCII.prefix.length];
                    System.arraycopy(Text.TEXT_ENCODING_ASCII.prefix, 0, result, 0, Text.TEXT_ENCODING_ASCII.prefix.length);
                    System.arraycopy(asciiBytes, 0, result, Text.TEXT_ENCODING_ASCII.prefix.length, asciiBytes.length);
                    return result;
                }
                byte[] unicodeBytes = s.getBytes(Text.TEXT_ENCODING_UNICODE.encodingName);
                byte[] result = new byte[unicodeBytes.length + Text.TEXT_ENCODING_UNICODE.prefix.length];
                System.arraycopy(Text.TEXT_ENCODING_UNICODE.prefix, 0, result, 0, Text.TEXT_ENCODING_UNICODE.prefix.length);
                System.arraycopy(unicodeBytes, 0, result, Text.TEXT_ENCODING_UNICODE.prefix.length, unicodeBytes.length);
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new ImageWriteException(e.getMessage(), e);
            }
        }

        public Object getValue(TiffField entry) throws ImageReadException {
            if (entry.type == Text.FIELD_TYPE_ASCII.type) {
                return FIELD_TYPE_ASCII.getSimpleValue(entry);
            }
            if (entry.type != Text.FIELD_TYPE_UNDEFINED.type && entry.type != Text.FIELD_TYPE_BYTE.type) {
                Debug.debug("entry.type", entry.type);
                Debug.debug("entry.directoryType", entry.directoryType);
                Debug.debug("entry.type", entry.getDescriptionWithoutValue());
                Debug.debug("entry.type", entry.fieldType);
                throw new ImageReadException("Text field not encoded as bytes.");
            }
            byte[] bytes = entry.fieldType.getRawBytes(entry);
            if (bytes.length < 8) {
                try {
                    return new String(bytes, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ImageReadException("Text field missing encoding prefix.");
                }
            }
            for (int i = 0; i < TEXT_ENCODINGS.length; ++i) {
                TextEncoding encoding = TEXT_ENCODINGS[i];
                if (!BinaryFileFunctions.compareBytes(bytes, 0, encoding.prefix, 0, encoding.prefix.length)) continue;
                try {
                    return new String(bytes, encoding.prefix.length, bytes.length - encoding.prefix.length, encoding.encodingName);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ImageReadException(e.getMessage(), e);
                }
            }
            try {
                return new String(bytes, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new ImageReadException("Unknown text encoding prefix.");
            }
        }

        private static final class TextEncoding {
            public final byte[] prefix;
            public final String encodingName;

            public TextEncoding(byte[] prefix, String encodingName) {
                this.prefix = prefix;
                this.encodingName = encodingName;
            }
        }
    }

    public static class Date
    extends TagInfo {
        private static final DateFormat DATE_FORMAT_1 = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        private static final DateFormat DATE_FORMAT_2 = new SimpleDateFormat("yyyy:MM:dd:HH:mm:ss");

        public Date(String name, int tag, FieldType dataType, int length) {
            super(name, tag, dataType, length);
        }

        public Object getValue(TiffField entry) throws ImageReadException {
            Object o = entry.fieldType.getSimpleValue(entry);
            String s = (String)o;
            try {
                java.util.Date date = DATE_FORMAT_1.parse(s);
                return date;
            }
            catch (Exception e) {
                try {
                    java.util.Date date = DATE_FORMAT_2.parse(s);
                    return date;
                }
                catch (Exception e2) {
                    Debug.debug(e2);
                    return o;
                }
            }
        }

        public byte[] encodeValue(FieldType fieldType, Object value, int byteOrder) throws ImageWriteException {
            throw new ImageWriteException("date encode value: " + value + " (" + Debug.getType(value) + ")");
        }

        public String toString() {
            return "[TagInfo. tag: " + this.tag + ", name: " + this.name + " (data)" + "]";
        }

        public boolean isDate() {
            return true;
        }
    }

    public static class Offset
    extends TagInfo {
        public Offset(String name, int tag, FieldType[] dataTypes, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
            super(name, tag, dataTypes, length, exifDirectory);
        }

        public Offset(String name, int tag, FieldType dataType, int length, TiffDirectoryConstants.ExifDirectoryType exifDirectory) {
            super(name, tag, dataType, length, exifDirectory);
        }

        public Offset(String name, int tag, FieldType dataType, int length) {
            super(name, tag, dataType, length);
        }

        public boolean isOffset() {
            return true;
        }
    }
}

