/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.formats.pnm.FileInfo;
import org.apache.sanselan.formats.pnm.WhiteSpaceReader;

public class PPMFileInfo
extends FileInfo {
    private final int max;

    public PPMFileInfo(int width, int height, boolean RAWBITS, int max) {
        super(width, height, RAWBITS);
        this.max = max;
    }

    public int getNumComponents() {
        return 3;
    }

    public int getBitDepth() {
        return 8;
    }

    public ImageFormat getImageType() {
        return ImageFormat.IMAGE_FORMAT_PGM;
    }

    public String getImageTypeDescription() {
        return "PGM: portable graymap file\tformat";
    }

    public String getMIMEType() {
        return "image/x-portable-graymap";
    }

    public int getColorType() {
        return 1;
    }

    public int getRGB(InputStream is) throws IOException {
        int red = is.read();
        int green = is.read();
        int blue = is.read();
        if (red < 0 || green < 0 || blue < 0) {
            throw new IOException("PPM: Unexpected EOF");
        }
        int alpha = 255;
        int rgb = (0xFF & alpha) << 24 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        return rgb;
    }

    public int getRGB(WhiteSpaceReader wsr) throws IOException {
        int red = Integer.parseInt(wsr.readtoWhiteSpace());
        int green = Integer.parseInt(wsr.readtoWhiteSpace());
        int blue = Integer.parseInt(wsr.readtoWhiteSpace());
        int alpha = 255;
        int rgb = (0xFF & alpha) << 24 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        return rgb;
    }

    public void dump() {
    }
}

