/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.samples;

import com.caffeineowl.graphics.samples.BezierFlatteningPanel;
import com.caffeineowl.graphics.samples.BezierPanel;
import com.caffeineowl.graphics.samples.BezierPanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BezierFlatteningExplorer
extends JPanel {
    protected TitledBezierFlatteningPanel robustConvHullPanel;
    protected TitledBezierFlatteningPanel simpleConvHullPanel;
    protected TitledBezierFlatteningPanel eucLineDefectPanel;
    protected TitledBezierFlatteningPanel mhtLineDefectPanel;
    protected TitledBezierFlatteningPanel cbsLineDefectPanel;
    protected JSlider precSlider;
    protected JTextField precTextField;
    protected JRadioButton exploreCubics;
    protected JRadioButton exploreQuads;

    public BezierFlatteningExplorer() {
        Dimension prefSize = new Dimension(300, 300);
        this.robustConvHullPanel = new TitledBezierFlatteningPanel(true, "Robust convex hull flattening");
        this.robustConvHullPanel.setPreferredSize(prefSize);
        this.robustConvHullPanel.setFlatnessAlgoType(BezierFlatteningPanel.FlatnessAlgoType.ROBUST_CONVEX_HULL);
        this.simpleConvHullPanel = new TitledBezierFlatteningPanel(true, "Naive convex hull flattening");
        this.simpleConvHullPanel.setPreferredSize(prefSize);
        this.simpleConvHullPanel.setFlatnessAlgoType(BezierFlatteningPanel.FlatnessAlgoType.SIMPLE_CONVEX_HULL);
        this.eucLineDefectPanel = new TitledBezierFlatteningPanel(true, "Line def. (Euc dist) flattening");
        this.eucLineDefectPanel.setPreferredSize(prefSize);
        this.eucLineDefectPanel.setFlatnessAlgoType(BezierFlatteningPanel.FlatnessAlgoType.LINE_DEFECT);
        this.eucLineDefectPanel.setDistanceType(BezierFlatteningPanel.DistanceType.EUCLID);
        this.mhtLineDefectPanel = new TitledBezierFlatteningPanel(true, "Line def. (Taxi dist) flattening");
        this.mhtLineDefectPanel.setPreferredSize(prefSize);
        this.mhtLineDefectPanel.setFlatnessAlgoType(BezierFlatteningPanel.FlatnessAlgoType.LINE_DEFECT);
        this.mhtLineDefectPanel.setDistanceType(BezierFlatteningPanel.DistanceType.MANHATTAN);
        this.cbsLineDefectPanel = new TitledBezierFlatteningPanel(true, "Line def. (Chess dist) flattening");
        this.cbsLineDefectPanel.setPreferredSize(prefSize);
        this.cbsLineDefectPanel.setFlatnessAlgoType(BezierFlatteningPanel.FlatnessAlgoType.LINE_DEFECT);
        this.cbsLineDefectPanel.setDistanceType(BezierFlatteningPanel.DistanceType.CHEBYSHEV);
        SynchroListener sync = new SynchroListener();
        this.robustConvHullPanel.addCurveChangeListener(sync);
        this.simpleConvHullPanel.addCurveChangeListener(sync);
        this.eucLineDefectPanel.addCurveChangeListener(sync);
        this.mhtLineDefectPanel.addCurveChangeListener(sync);
        this.cbsLineDefectPanel.addCurveChangeListener(sync);
        this.precSlider = new JSlider(0, 0, 100, 50);
        this.precSlider.setMajorTickSpacing(10);
        this.precSlider.setPaintTicks(true);
        this.precTextField = new JTextField("2");
        PrecHandler precHandler = new PrecHandler();
        this.precSlider.addChangeListener(precHandler);
        this.precTextField.addActionListener(precHandler);
        this.toPrecSlider("2");
        ActionListener cubicQuadSwitcher = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BezierFlatteningExplorer.this.pickCurveType(e.getSource());
            }
        };
        this.exploreCubics = new JRadioButton("... cubics");
        this.exploreCubics.addActionListener(cubicQuadSwitcher);
        this.exploreQuads = new JRadioButton("... quads");
        this.exploreQuads.addActionListener(cubicQuadSwitcher);
        ButtonGroup btnGrp = new ButtonGroup();
        btnGrp.add(this.exploreCubics);
        btnGrp.add(this.exploreQuads);
        this.exploreCubics.setSelected(true);
        this.setLayout(new GridLayout(2, 3));
        this.add(this.eucLineDefectPanel);
        this.add(this.mhtLineDefectPanel);
        this.add(this.cbsLineDefectPanel);
        this.add(this.robustConvHullPanel);
        this.add(this.simpleConvHullPanel);
        JPanel radioSupport = new JPanel();
        radioSupport.setBorder(BorderFactory.createTitledBorder("Now exploring"));
        radioSupport.setLayout(new GridLayout(2, 1));
        radioSupport.add(this.exploreCubics);
        radioSupport.add(this.exploreQuads);
        radioSupport.setBackground(Color.white);
        JPanel precSupport = new JPanel();
        precSupport.setLayout(new BorderLayout());
        precSupport.setBorder(BorderFactory.createTitledBorder("Precision"));
        precSupport.add((Component)this.precSlider, "Center");
        precSupport.add((Component)this.precTextField, "North");
        precSupport.setBackground(Color.white);
        JPanel ctrlsSupport = new JPanel();
        ctrlsSupport.setLayout(new BorderLayout());
        ctrlsSupport.add((Component)radioSupport, "North");
        ctrlsSupport.add((Component)precSupport, "South");
        ctrlsSupport.setBackground(Color.white);
        this.precSlider.setBackground(new Color(231, 231, 255));
        this.add(ctrlsSupport);
    }

    protected void pickCurveType(Object source) {
        if (source == this.exploreCubics) {
            this.robustConvHullPanel.setRepresentingCubic(true);
            this.simpleConvHullPanel.setRepresentingCubic(true);
            this.cbsLineDefectPanel.setRepresentingCubic(true);
            this.mhtLineDefectPanel.setRepresentingCubic(true);
            this.eucLineDefectPanel.setRepresentingCubic(true);
        } else {
            this.robustConvHullPanel.setRepresentingCubic(false);
            this.simpleConvHullPanel.setRepresentingCubic(false);
            this.cbsLineDefectPanel.setRepresentingCubic(false);
            this.mhtLineDefectPanel.setRepresentingCubic(false);
            this.eucLineDefectPanel.setRepresentingCubic(false);
        }
    }

    double fromPrecSlider() {
        int sliderVal = this.precSlider.getValue();
        double sliderRange = this.precSlider.getMaximum() - this.precSlider.getMinimum();
        double sliderMid = (double)(this.precSlider.getMaximum() + this.precSlider.getMinimum()) / 2.0;
        double toRet = 10.0 * ((double)sliderVal - sliderMid) / sliderRange;
        toRet = Math.pow(2.0, toRet);
        this.simpleConvHullPanel.setTolerance(toRet);
        this.robustConvHullPanel.setTolerance(toRet);
        this.eucLineDefectPanel.setTolerance(toRet);
        this.mhtLineDefectPanel.setTolerance(toRet);
        this.cbsLineDefectPanel.setTolerance(toRet);
        return toRet;
    }

    void toPrecSlider(String valStr) {
        double val = -1.0;
        try {
            val = Double.parseDouble(valStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (val > 0.0) {
            double sliderVal = Math.log(val) / Math.log(2.0);
            double sMin = this.precSlider.getMinimum();
            double sMax = this.precSlider.getMaximum();
            sliderVal = (sMax - sMin) * sliderVal / 10.0 + (sMax + sMin) / 2.0;
            sliderVal = Math.max(sliderVal, sMin);
            sliderVal = Math.min(sliderVal, sMax);
            this.precSlider.setValue((int)sliderVal);
            this.simpleConvHullPanel.setTolerance(val);
            this.robustConvHullPanel.setTolerance(val);
            this.eucLineDefectPanel.setTolerance(val);
            this.mhtLineDefectPanel.setTolerance(val);
            this.cbsLineDefectPanel.setTolerance(val);
        } else {
            JOptionPane.showMessageDialog(this, "<html>Only strictly positive precisions, please.<br>Got: " + valStr, "Bad precision/tolerance", 0);
            this.precTextField.setText("" + this.fromPrecSlider());
            this.precTextField.selectAll();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frm = new JFrame("Bezier flattening algos explorer");
        frm.setDefaultCloseOperation(3);
        BezierFlatteningExplorer panel = new BezierFlatteningExplorer();
        frm.getContentPane().setLayout(new BorderLayout());
        frm.getContentPane().add((Component)panel, "Center");
        frm.pack();
        frm.setVisible(true);
    }

    class PrecHandler
    implements ActionListener,
    ChangeListener {
        boolean handling = false;

        PrecHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.handling) {
                this.handling = true;
                String precVal = BezierFlatteningExplorer.this.precTextField.getText();
                BezierFlatteningExplorer.this.toPrecSlider(precVal);
                this.handling = false;
            }
        }

        public void stateChanged(ChangeEvent e) {
            if (!this.handling) {
                this.handling = true;
                BezierFlatteningExplorer.this.precTextField.setText("" + BezierFlatteningExplorer.this.fromPrecSlider());
                this.handling = false;
            }
        }
    }

    class SynchroListener
    implements BezierPanelListener {
        boolean duringSynchr = false;

        SynchroListener() {
        }

        public void curveChanged(BezierPanel src) {
            if (!this.duringSynchr) {
                this.duringSynchr = true;
                TitledBezierFlatteningPanel[] toSync = new TitledBezierFlatteningPanel[4];
                int pos = 0;
                if (BezierFlatteningExplorer.this.robustConvHullPanel != src) {
                    toSync[pos++] = BezierFlatteningExplorer.this.robustConvHullPanel;
                }
                if (BezierFlatteningExplorer.this.simpleConvHullPanel != src) {
                    toSync[pos++] = BezierFlatteningExplorer.this.simpleConvHullPanel;
                }
                if (BezierFlatteningExplorer.this.eucLineDefectPanel != src) {
                    toSync[pos++] = BezierFlatteningExplorer.this.eucLineDefectPanel;
                }
                if (BezierFlatteningExplorer.this.mhtLineDefectPanel != src) {
                    toSync[pos++] = BezierFlatteningExplorer.this.mhtLineDefectPanel;
                }
                if (BezierFlatteningExplorer.this.cbsLineDefectPanel != src) {
                    toSync[pos++] = BezierFlatteningExplorer.this.cbsLineDefectPanel;
                }
                CubicCurve2D srcCurve = src.getRepresentedCubic();
                for (pos = 0; pos < toSync.length; ++pos) {
                    toSync[pos].setRepresentedCubic(srcCurve);
                }
                this.duringSynchr = false;
            }
        }
    }

    static class TitledBezierFlatteningPanel
    extends BezierFlatteningPanel {
        static Font titleFont = new Font("serif", 0, 12);
        String title;

        public TitledBezierFlatteningPanel(boolean representingCubic, String title) {
            super(representingCubic);
            this.title = title;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D titleBounds = titleFont.getStringBounds(this.title, g2.getFontRenderContext());
            g2.setFont(titleFont);
            g2.setPaint(this.getDotPaint());
            g2.drawString(this.title, (int)(((double)this.getWidth() - titleBounds.getWidth()) / 2.0), (int)(5.0 + titleBounds.getHeight()));
        }
    }
}

