/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.DistUtils;
import com.caffeineowl.graphics.bezier.CubicFlatnessAlgorithm;
import com.caffeineowl.graphics.bezier.QuadFlatnessAlgorithm;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

public class LineDefectFlatnessAlgo
implements CubicFlatnessAlgorithm,
QuadFlatnessAlgorithm {
    public static final int EUCL_DIST = 0;
    public static final int MNHT_DIST = 1;
    public static final int CBSV_DIST = 2;
    protected int distType;
    protected boolean usingSum;

    public LineDefectFlatnessAlgo() {
        this(0, true);
    }

    public LineDefectFlatnessAlgo(int distType) {
        this(distType, true);
    }

    public LineDefectFlatnessAlgo(boolean useSumation) {
        this(0, useSumation);
    }

    public LineDefectFlatnessAlgo(int distType, boolean useSum) {
        switch (distType) {
            case 1: 
            case 2: {
                this.distType = distType;
                break;
            }
            default: {
                this.distType = 0;
            }
        }
        this.usingSum = useSum;
    }

    public final boolean isDegenerationRobust() {
        return true;
    }

    public final boolean isSquaredFlatenessPreferred() {
        return this.distType == 0;
    }

    public final double getFlatness(CubicCurve2D curve) {
        double p0x = curve.getX1();
        double p0y = curve.getY1();
        double c0x = curve.getCtrlX1();
        double c0y = curve.getCtrlY1();
        double c1x = curve.getCtrlX2();
        double c1y = curve.getCtrlY2();
        double p1x = curve.getX2();
        double p1y = curve.getY2();
        double d0 = 0.0;
        double d1 = 0.0;
        switch (this.distType) {
            case 1: {
                d0 = DistUtils.pointToPointMnhtDist(c0x, c0y, (2.0 * p0x + p1x) / 3.0, (2.0 * p0y + p1y) / 3.0);
                d1 = DistUtils.pointToPointMnhtDist(c1x, c1y, (p0x + 2.0 * p1x) / 3.0, (p0y + 2.0 * p1y) / 3.0);
                break;
            }
            case 2: {
                d0 = DistUtils.pointToPointCbsvDist(c0x, c0y, (2.0 * p0x + p1x) / 3.0, (2.0 * p0y + p1y) / 3.0);
                d1 = DistUtils.pointToPointCbsvDist(c1x, c1y, (p0x + 2.0 * p1x) / 3.0, (p0y + 2.0 * p1y) / 3.0);
                break;
            }
            default: {
                d0 = DistUtils.pointToPointEucDist(c0x, c0y, (2.0 * p0x + p1x) / 3.0, (2.0 * p0y + p1y) / 3.0);
                d1 = DistUtils.pointToPointEucDist(c1x, c1y, (p0x + 2.0 * p1x) / 3.0, (p0y + 2.0 * p1y) / 3.0);
            }
        }
        if (this.usingSum) {
            d0 += d1;
        } else if (d1 > d0) {
            d0 = d1;
        }
        return d0;
    }

    public final double getSquaredFlatness(CubicCurve2D curve) {
        double p0x = curve.getX1();
        double p0y = curve.getY1();
        double c0x = curve.getCtrlX1();
        double c0y = curve.getCtrlY1();
        double c1x = curve.getCtrlX2();
        double c1y = curve.getCtrlY2();
        double p1x = curve.getX2();
        double p1y = curve.getY2();
        double d0 = 0.0;
        double d1 = 0.0;
        switch (this.distType) {
            case 1: {
                d0 = DistUtils.pointToPointMnhtDist(c0x, c0y, (2.0 * p0x + p1x) / 3.0, (2.0 * p0y + p1y) / 3.0);
                d1 = DistUtils.pointToPointMnhtDist(c1x, c1y, (p0x + 2.0 * p1x) / 3.0, (p0y + 2.0 * p1y) / 3.0);
                d0 *= d0;
                d1 *= d1;
                break;
            }
            case 2: {
                d0 = DistUtils.pointToPointCbsvDist(c0x, c0y, (2.0 * p0x + p1x) / 3.0, (2.0 * p0y + p1y) / 3.0);
                d1 = DistUtils.pointToPointCbsvDist(c1x, c1y, (p0x + 2.0 * p1x) / 3.0, (p0y + 2.0 * p1y) / 3.0);
                d0 *= d0;
                d1 *= d1;
                break;
            }
            default: {
                d0 = DistUtils.pointToPointSqEucDist(c0x, c0y, (2.0 * p0x + p1x) / 3.0, (2.0 * p0y + p1y) / 3.0);
                d1 = DistUtils.pointToPointSqEucDist(c1x, c1y, (p0x + 2.0 * p1x) / 3.0, (p0y + 2.0 * p1y) / 3.0);
            }
        }
        if (this.usingSum) {
            d0 += d1;
        } else if (d1 > d0) {
            d0 = d1;
        }
        return d0;
    }

    public final double getFlatness(QuadCurve2D curve) {
        double p0x = curve.getX1();
        double p0y = curve.getY1();
        double cx = curve.getCtrlX();
        double cy = curve.getCtrlY();
        double p1x = curve.getX2();
        double p1y = curve.getCtrlY();
        double toRet = 0.0;
        switch (this.distType) {
            case 1: {
                toRet = DistUtils.pointToPointMnhtDist(cx, cy, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0);
                break;
            }
            case 2: {
                toRet = DistUtils.pointToPointCbsvDist(cx, cy, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0);
                break;
            }
            default: {
                toRet = DistUtils.pointToPointEucDist(cx, cy, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0);
            }
        }
        return toRet;
    }

    public final double getSquaredFlatness(QuadCurve2D curve) {
        double p0x = curve.getX1();
        double p0y = curve.getY1();
        double cx = curve.getCtrlX();
        double cy = curve.getCtrlY();
        double p1x = curve.getX2();
        double p1y = curve.getCtrlY();
        double toRet = 0.0;
        switch (this.distType) {
            case 1: {
                toRet = DistUtils.pointToPointMnhtDist(cx, cy, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0);
                toRet *= toRet;
                break;
            }
            case 2: {
                toRet = DistUtils.pointToPointCbsvDist(cx, cy, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0);
                toRet *= toRet;
                break;
            }
            default: {
                toRet = DistUtils.pointToPointSqEucDist(cx, cy, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0);
            }
        }
        return toRet;
    }
}

