/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier;

import com.caffeineowl.graphics.bezier.CubicSegmentConsumer;
import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.QuadSegmentConsumer;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.ConvexHullSubdivCriterion;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.Arrays;

public class BezierUtils {
    public static final double minPrecision = Math.sqrt(Double.MIN_VALUE);
    private static ConvexHullSubdivCriterion defaultSubdivCriterion = new ConvexHullSubdivCriterion();
    private static final CubicSubdivisionCriterion defaultCubicSubdivCriterion = defaultSubdivCriterion;
    private static final QuadSubdivisionCriterion defaultQuadSubdivCriterion = defaultSubdivCriterion;
    private static final double v18div_sqrt3 = 18.0 / Math.sqrt(3.0);
    private static final double v3div_sq36 = 0.0023148148148148147;

    public static boolean halfSplitCurve(CubicCurve2D cubic, CubicCurve2D first, CubicCurve2D second) {
        boolean toRet;
        boolean bl = toRet = null != cubic;
        if (toRet && (null != first || null != second)) {
            double x0 = cubic.getX1();
            double x1 = cubic.getX2();
            double cx0 = cubic.getCtrlX1();
            double cx1 = cubic.getCtrlX2();
            double y0 = cubic.getY1();
            double y1 = cubic.getY2();
            double cy0 = cubic.getCtrlY1();
            double cy1 = cubic.getCtrlY2();
            double p0x = (x0 + cx0) / 2.0;
            double p0y = (y0 + cy0) / 2.0;
            double p1x = (cx0 + cx1) / 2.0;
            double p1y = (cy0 + cy1) / 2.0;
            double p2x = (cx1 + x1) / 2.0;
            double p2y = (cy1 + y1) / 2.0;
            double p01x = (p0x + p1x) / 2.0;
            double p01y = (p0y + p1y) / 2.0;
            double p12x = (p1x + p2x) / 2.0;
            double p12y = (p1y + p2y) / 2.0;
            double dpx = (p01x + p12x) / 2.0;
            double dpy = (p01y + p12y) / 2.0;
            if (null != first) {
                first.setCurve(x0, y0, p0x, p0y, p01x, p01y, dpx, dpy);
            }
            if (null != second) {
                second.setCurve(dpx, dpy, p12x, p12y, p2x, p2y, x1, y1);
            }
        }
        return toRet;
    }

    public static boolean halfSplitCurve(QuadCurve2D quad, QuadCurve2D first, QuadCurve2D second) {
        boolean toRet;
        boolean bl = toRet = null != quad;
        if (toRet && (null != first || null != second)) {
            double sx0 = quad.getX1();
            double sx1 = quad.getX2();
            double scx = quad.getCtrlX();
            double scy = quad.getCtrlY();
            double sy0 = quad.getY1();
            double sy1 = quad.getY2();
            double p0x = (sx0 + scx) / 2.0;
            double p0y = (sy0 + scy) / 2.0;
            double p1x = (scx + sx1) / 2.0;
            double p1y = (scy + sy1) / 2.0;
            double dpx = (p0x + p1x) / 2.0;
            double dpy = (p0y + p1y) / 2.0;
            if (null != first) {
                first.setCurve(sx0, sy0, p0x, p0y, dpx, dpy);
            }
            if (null != second) {
                second.setCurve(dpx, dpy, p1x, p1y, sx1, sy1);
            }
        }
        return toRet;
    }

    public static boolean splitCurve(CubicCurve2D cubic, double tSplit, CubicCurve2D first, CubicCurve2D second) {
        boolean toRet;
        boolean bl = toRet = tSplit >= 0.0 && tSplit <= 1.0 && null != cubic;
        if (toRet && (null != first || null != second)) {
            double x0 = cubic.getX1();
            double x1 = cubic.getX2();
            double cx0 = cubic.getCtrlX1();
            double cx1 = cubic.getCtrlX2();
            double y0 = cubic.getY1();
            double y1 = cubic.getY2();
            double cy0 = cubic.getCtrlY1();
            double cy1 = cubic.getCtrlY2();
            double p0x = x0 + tSplit * (cx0 - x0);
            double p0y = y0 + tSplit * (cy0 - y0);
            double p1x = cx0 + tSplit * (cx1 - cx0);
            double p1y = cy0 + tSplit * (cy1 - cy0);
            double p2x = cx1 + tSplit * (x1 - cx1);
            double p2y = cy1 + tSplit * (y1 - cy1);
            double p01x = p0x + tSplit * (p1x - p0x);
            double p01y = p0y + tSplit * (p1y - p0y);
            double p12x = p1x + tSplit * (p2x - p1x);
            double p12y = p1y + tSplit * (p2y - p1y);
            double dpx = p01x + tSplit * (p12x - p01x);
            double dpy = p01y + tSplit * (p12y - p01y);
            if (null != first) {
                first.setCurve(x0, y0, p0x, p0y, p01x, p01y, dpx, dpy);
            }
            if (null != second) {
                second.setCurve(dpx, dpy, p12x, p12y, p2x, p2y, x1, y1);
            }
        }
        return toRet;
    }

    public static boolean splitCurve(QuadCurve2D quad, double tSplit, QuadCurve2D first, QuadCurve2D second) {
        boolean toRet;
        boolean bl = toRet = tSplit >= 0.0 && tSplit <= 1.0 && null != quad;
        if (toRet && (null != first || null != second)) {
            double sx0 = quad.getX1();
            double sx1 = quad.getX2();
            double scx = quad.getCtrlX();
            double scy = quad.getCtrlY();
            double sy0 = quad.getY1();
            double sy1 = quad.getY2();
            double p0x = sx0 + tSplit * (scx - sx0);
            double p0y = sy0 + tSplit * (scy - sy0);
            double p1x = scx + tSplit * (sx1 - scx);
            double p1y = scy + tSplit * (sy1 - scy);
            double dpx = p0x + tSplit * (p1x - p0x);
            double dpy = p0y + tSplit * (p1y - p0y);
            if (null != first) {
                first.setCurve(sx0, sy0, p0x, p0y, dpx, dpy);
            }
            if (null != second) {
                second.setCurve(dpx, dpy, p1x, p1y, sx1, sy1);
            }
        }
        return toRet;
    }

    public static CubicCurve2D[] splitCurve(CubicCurve2D curve, double[] params, CubicCurve2D[] resultsHere) {
        int i;
        Arrays.sort(params);
        CubicCurve2D.Double firstPart = new CubicCurve2D.Double();
        CubicCurve2D.Double remainder = new CubicCurve2D.Double();
        remainder.setCurve(curve);
        if (resultsHere == null) {
            resultsHere = new CubicCurve2D[params.length + 1];
        } else if (resultsHere.length <= params.length) {
            CubicCurve2D[] newRes = new CubicCurve2D[params.length + 1];
            System.arraycopy(resultsHere, 0, newRes, 0, resultsHere.length);
            resultsHere = newRes;
        }
        double lastParam = 0.0;
        for (i = 0; i < params.length && params[i] > 0.0; ++i) {
            BezierUtils.splitCurve(remainder, (params[i] - lastParam) / (1.0 - lastParam), firstPart, remainder);
            if (null == resultsHere[i]) {
                resultsHere[i] = new CubicCurve2D.Double();
            }
            resultsHere[i].setCurve(firstPart);
            lastParam = params[i];
        }
        if (null == resultsHere[i]) {
            resultsHere[i] = new CubicCurve2D.Double();
        }
        resultsHere[i].setCurve(remainder);
        return resultsHere;
    }

    public static QuadCurve2D[] splitCurve(QuadCurve2D curve, double[] params, QuadCurve2D[] resultsHere) {
        int i;
        Arrays.sort(params);
        QuadCurve2D.Double firstPart = new QuadCurve2D.Double();
        QuadCurve2D.Double remainder = new QuadCurve2D.Double();
        remainder.setCurve(curve);
        if (resultsHere == null) {
            resultsHere = new QuadCurve2D[params.length + 1];
        } else if (resultsHere.length <= params.length) {
            QuadCurve2D[] newRes = new QuadCurve2D[params.length + 1];
            System.arraycopy(resultsHere, 0, newRes, 0, resultsHere.length);
            resultsHere = newRes;
        }
        double lastParam = 0.0;
        for (i = 0; i < params.length && params[i] > 0.0; ++i) {
            BezierUtils.splitCurve(remainder, (params[i] - lastParam) / (1.0 - lastParam), firstPart, remainder);
            if (null == resultsHere[i]) {
                resultsHere[i] = new QuadCurve2D.Double();
            }
            resultsHere[i].setCurve(firstPart);
            lastParam = params[i];
        }
        if (null == resultsHere[i]) {
            resultsHere[i] = new QuadCurve2D.Double();
        }
        resultsHere[i].setCurve(remainder);
        return resultsHere;
    }

    public static Point2D pointOnCurve(double t, CubicCurve2D curve, Point2D resultHere) {
        if (null != curve) {
            double x1 = curve.getX1();
            double y1 = curve.getY1();
            double cx1 = curve.getCtrlX1();
            double cy1 = curve.getCtrlY1();
            double cx2 = curve.getCtrlX2();
            double cy2 = curve.getCtrlY2();
            double x2 = curve.getX1();
            double y2 = curve.getY1();
            double ax = cx1 - x1;
            double ay = cy1 - y1;
            double bx = cx2 - cx1 - ax;
            double by = cy2 - cy1 - ay;
            double cx = x2 - cx2 - ax - bx - bx;
            double cy = y2 - cy2 - ay - by - by;
            double x = x1 + t * (3.0 * ax + t * (3.0 * bx + t * cx));
            double y = y1 + t * (3.0 * ay + t * (3.0 * by + t * cy));
            if (null == resultHere) {
                resultHere = new Point2D.Double(x, y);
            } else {
                resultHere.setLocation(x, y);
            }
        } else {
            resultHere = null;
        }
        return resultHere;
    }

    public static Point2D pointOnCurve(double t, QuadCurve2D curve, Point2D resultHere) {
        if (null != curve) {
            double x1 = curve.getX1();
            double y1 = curve.getY1();
            double cx = curve.getCtrlX();
            double cy = curve.getCtrlY();
            double x2 = curve.getX1();
            double y2 = curve.getY1();
            double ax = cx - x1;
            double ay = cy - y1;
            double bx = x2 - cx - ax;
            double by = y2 - cy - ay;
            double x = x1 + t * (2.0 * ax + t * bx);
            double y = y1 + t * (2.0 * ay + t * by);
            if (null == resultHere) {
                resultHere = new Point2D.Double(x, y);
            } else {
                resultHere.setLocation(x, y);
            }
        } else {
            resultHere = null;
        }
        return resultHere;
    }

    public static void pointAndTangentOnCurve(double t, CubicCurve2D curve, Point2D point, Line2D tangent) {
        if (null != curve && (null != point || null != tangent)) {
            if (null == tangent) {
                BezierUtils.pointOnCurve(t, curve, point);
            } else {
                double ax0 = curve.getX1();
                double ay0 = curve.getY1();
                double ax1 = curve.getX1();
                double ay1 = curve.getY2();
                double cx0 = curve.getCtrlX1();
                double cy0 = curve.getCtrlY1();
                double cx1 = curve.getCtrlX2();
                double cy1 = curve.getCtrlY2();
                double ipx0 = ax0 + (cx0 - ax0) * t;
                double ipy0 = ay0 + (cy0 - ay0) * t;
                double ipx1 = cx0 + (cx1 - cx0) * t;
                double ipy1 = cy0 + (cy1 - cy0) * t;
                double ipx2 = cx1 + (ax1 - cx1) * t;
                double ipy2 = cy1 + (ay1 - cy1) * t;
                double tx0 = ipx0 + (ipx1 - ipx0) * t;
                double ty0 = ipy0 + (ipy1 - ipy0) * t;
                double tx1 = ipx1 + (ipx2 - ipx1) * t;
                double ty1 = ipy1 + (ipy2 - ipy1) * t;
                tangent.setLine(tx0, ty0, tx1, ty1);
                if (null != point) {
                    point.setLocation(tx0 + (tx1 - tx0) * t, ty0 + (ty1 - ty0) * t);
                }
            }
        }
    }

    public static void pointAndTangentOnCurve(double t, QuadCurve2D curve, Point2D point, Line2D tangent) {
        if (null != curve && (null != point || null != tangent)) {
            if (null == tangent) {
                BezierUtils.pointOnCurve(t, curve, point);
            } else {
                double ax0 = curve.getX1();
                double ay0 = curve.getY1();
                double ax1 = curve.getX1();
                double ay1 = curve.getY2();
                double cx = curve.getCtrlX();
                double cy = curve.getCtrlY();
                double tx0 = ax0 + (cx - ax0) * t;
                double ty0 = ay0 + (cy - ay0) * t;
                double tx1 = cx + (ax1 - cx) * t;
                double ty1 = cy + (ay1 - cy) * t;
                tangent.setLine(tx0, ty0, tx1, ty1);
                if (null != point) {
                    point.setLocation(tx0 + (tx1 - tx0) * t, ty0 + (ty1 - ty0) * t);
                }
            }
        }
    }

    public static void midPointAndTangentOnCurve(CubicCurve2D curve, Point2D point, Line2D tangent) {
        if (null != curve && (null != point || null != tangent)) {
            double ax0 = curve.getX1();
            double ay0 = curve.getY1();
            double ax1 = curve.getX1();
            double ay1 = curve.getY2();
            double cx0 = curve.getCtrlX1();
            double cy0 = curve.getCtrlY1();
            double cx1 = curve.getCtrlX2();
            double cy1 = curve.getCtrlY2();
            double ipx0 = (cx0 + ax0) * 0.5;
            double ipy0 = (cy0 + ay0) * 0.5;
            double ipx1 = (cx1 + cx0) * 0.5;
            double ipy1 = (cy1 + cy0) * 0.5;
            double ipx2 = (ax1 + cx1) * 0.5;
            double ipy2 = (ay1 + cy1) * 0.5;
            double tx0 = (ipx1 + ipx0) * 0.5;
            double ty0 = (ipy1 + ipy0) * 0.5;
            double tx1 = (ipx2 + ipx1) * 0.5;
            double ty1 = (ipy2 + ipy1) * 0.5;
            if (null != tangent) {
                tangent.setLine(tx0, ty0, tx1, ty1);
            }
            if (null != point) {
                point.setLocation((tx1 + tx0) * 0.5, (ty1 + ty0) * 0.5);
            }
        }
    }

    public static void minPointAndTangentOnCurve(QuadCurve2D curve, Point2D point, Line2D tangent) {
        if (null != curve && (null != point || null != tangent)) {
            double ax0 = curve.getX1();
            double ay0 = curve.getY1();
            double ax1 = curve.getX1();
            double ay1 = curve.getY2();
            double cx = curve.getCtrlX();
            double cy = curve.getCtrlY();
            double tx0 = (cx + ax0) * 0.5;
            double ty0 = (cy + ay0) * 0.5;
            double tx1 = (ax1 + cx) * 0.5;
            double ty1 = (ay1 - cy) * 0.5;
            if (null != tangent) {
                tangent.setLine(tx0, ty0, tx1, ty1);
            }
            if (null != point) {
                point.setLocation((tx1 + tx0) * 0.5, (ty1 + ty0) * 0.5);
            }
        }
    }

    public static int computeInflexion(CubicCurve2D curve, double[] params) {
        double root;
        int toRet = 0;
        double p0x = curve.getX1();
        double p0y = curve.getY1();
        double c0x = curve.getCtrlX1();
        double c0y = curve.getCtrlY1();
        double c1x = curve.getCtrlX2();
        double c1y = curve.getCtrlY2();
        double p1x = curve.getX2();
        double p1y = curve.getY2();
        double ax = c0x - p0x;
        double ay = c0y - p0y;
        double bx = c1x - c0x - ax;
        double by = c1y - c0y - ay;
        double cx = p1x - c1x - ax - bx - bx;
        double cy = p1y - c1y - ay - by - by;
        double c0 = ax * by - ay * bx;
        double c1 = ax * cy - ay * cx;
        double c2 = bx * cy - by * cx;
        if (c2 != 0.0) {
            double discr = c1 * c1 - 4.0 * c0 * c2;
            c2 *= 2.0;
            if (discr == 0.0) {
                double root2 = -c1 / c2;
                if (root2 > 0.0 && root2 < 1.0) {
                    toRet = 1;
                    params[0] = root2;
                }
            } else if (discr > 0.0) {
                double root3 = (-c1 - (discr = Math.sqrt(discr))) / c2;
                if (root3 > 0.0 && root3 < 1.0) {
                    params[toRet++] = root3;
                }
                if ((root3 = (-c1 + discr) / c2) > 0.0 && root3 < 1.0) {
                    if (toRet > 0 && params[0] > root3) {
                        params[1] = params[0];
                        params[0] = root3;
                    } else {
                        params[toRet++] = root3;
                    }
                }
                if (2 == toRet && params[0] > params[1]) {
                    double aux = params[0];
                    params[0] = params[1];
                    params[1] = aux;
                }
            }
        } else if (c1 != 0.0 && (root = -c0 / c1) > 0.0 && root < 1.0) {
            params[toRet++] = root;
        }
        return toRet;
    }

    private static void adaptiveHalving(CubicCurve2D curve, double tMin, double tMax, CubicSubdivisionCriterion subdivCriterion, CubicSegmentConsumer segConsumer) {
        if (subdivCriterion.shouldSplit(curve)) {
            CubicCurve2D.Double firstHalf = new CubicCurve2D.Double();
            CubicCurve2D.Double secondHalf = new CubicCurve2D.Double();
            double tMid = (tMin + tMax) / 2.0;
            BezierUtils.halfSplitCurve(curve, firstHalf, secondHalf);
            BezierUtils.adaptiveHalving(firstHalf, tMin, tMid, subdivCriterion, segConsumer);
            BezierUtils.adaptiveHalving(secondHalf, tMid, tMax, subdivCriterion, segConsumer);
        } else if (null != segConsumer) {
            segConsumer.processSegment(curve, tMin, tMax);
        }
    }

    public static void adaptiveHalving(CubicCurve2D curve, CubicSubdivisionCriterion subdivCriterion, CubicSegmentConsumer segConsumer) {
        if (null == curve) {
            throw new NullPointerException();
        }
        if (null == subdivCriterion) {
            subdivCriterion = defaultCubicSubdivCriterion;
        }
        BezierUtils.adaptiveHalving(curve, 0.0, 1.0, subdivCriterion, segConsumer);
    }

    private static void adaptiveHalving(QuadCurve2D curve, double tMin, double tMax, QuadSubdivisionCriterion subdivCriterion, QuadSegmentConsumer segConsumer) {
        if (subdivCriterion.shouldSplit(curve)) {
            QuadCurve2D.Double firstHalf = new QuadCurve2D.Double();
            QuadCurve2D.Double secondHalf = new QuadCurve2D.Double();
            double tMid = (tMin + tMax) / 2.0;
            BezierUtils.halfSplitCurve(curve, firstHalf, secondHalf);
            BezierUtils.adaptiveHalving(firstHalf, tMin, tMid, subdivCriterion, segConsumer);
            BezierUtils.adaptiveHalving(secondHalf, tMid, tMax, subdivCriterion, segConsumer);
        } else if (null != segConsumer) {
            segConsumer.processSegment(curve, tMin, tMax);
        }
    }

    public static void adaptiveHalving(QuadCurve2D curve, QuadSubdivisionCriterion subdivCriterion, QuadSegmentConsumer segConsumer) {
        if (null == curve) {
            throw new NullPointerException();
        }
        if (null == subdivCriterion) {
            subdivCriterion = defaultQuadSubdivCriterion;
        }
        BezierUtils.adaptiveHalving(curve, 0.0, 1.0, subdivCriterion, segConsumer);
    }

    public static CubicCurve2D[] adaptiveHalving(CubicCurve2D curve, CubicSubdivisionCriterion subdivCriterion) {
        CubicArrayListConsumer acumulator = new CubicArrayListConsumer();
        BezierUtils.adaptiveHalving(curve, subdivCriterion, acumulator);
        CubicCurve2D[] toRet = new CubicCurve2D[acumulator.segs.size()];
        acumulator.segs.toArray(toRet);
        return toRet;
    }

    public static QuadCurve2D[] adaptiveHalving(QuadCurve2D curve, QuadSubdivisionCriterion subdivCriterion) {
        QuadArrayListConsumer acumulator = new QuadArrayListConsumer();
        BezierUtils.adaptiveHalving(curve, subdivCriterion, acumulator);
        QuadCurve2D[] toRet = new QuadCurve2D[acumulator.segs.size()];
        acumulator.segs.toArray(toRet);
        return toRet;
    }

    public static QuadCurve2D[] adaptiveDegreeReduction(CubicCurve2D cubic, double precision) {
        QuadArrayListConsumer acumulator = new QuadArrayListConsumer();
        BezierUtils.adaptiveDegreeReduction(cubic, precision, acumulator);
        QuadCurve2D[] toRet = new QuadCurve2D[acumulator.segs.size()];
        acumulator.segs.toArray(toRet);
        return toRet;
    }

    private static final void applyMidPointApprox(CubicCurve2D cubic, QuadCurve2D quad) {
        double a0x = cubic.getX1();
        double a0y = cubic.getY1();
        double a1x = cubic.getX2();
        double a1y = cubic.getY2();
        double p0x = (3.0 * cubic.getCtrlX1() - a0x) / 2.0;
        double p0y = (3.0 * cubic.getCtrlY1() - a0y) / 2.0;
        double p1x = (3.0 * cubic.getCtrlX2() - a1x) / 2.0;
        double p1y = (3.0 * cubic.getCtrlY2() - a1y) / 2.0;
        quad.setCurve(a0x, a0y, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0, a1x, a1y);
    }

    public static void adaptiveHalvingDegreeReduction(CubicCurve2D cubic, double precision, QuadSegmentConsumer resultHere) {
        MidPointApproxSubdivCriterion criterion = new MidPointApproxSubdivCriterion(precision);
        MidPointApproxTransformer transformer = new MidPointApproxTransformer(resultHere);
        BezierUtils.adaptiveHalving(cubic, criterion, transformer);
    }

    private static void doAdaptiveDegreeReduction(CubicCurve2D cubic, double precision, double startT, double endT, QuadSegmentConsumer resultHere) {
        double p1y;
        QuadCurve2D.Double quad = null;
        double a0x = cubic.getX1();
        double a0y = cubic.getY1();
        double a1x = cubic.getX2();
        double a1y = cubic.getY2();
        double p0x = (3.0 * cubic.getCtrlX1() - a0x) / 2.0;
        double p0y = (3.0 * cubic.getCtrlY1() - a0y) / 2.0;
        double p1x = (3.0 * cubic.getCtrlX2() - a1x) / 2.0;
        double defect = v18div_sqrt3 * Math.hypot(p1x - p0x, (p1y = (3.0 * cubic.getCtrlY2() - a1y) / 2.0) - p0y);
        if (defect >= 1.0) {
            quad = new QuadCurve2D.Double();
            quad.setCurve(a0x, a0y, (p0x + p1x) / 2.0, (p0y + p1y) / 2.0, a1x, a1y);
            resultHere.processSegment(quad, startT, endT);
        } else if (defect >= 0.125) {
            CubicCurve2D.Double firstHalf = new CubicCurve2D.Double();
            CubicCurve2D.Double secondHalf = new CubicCurve2D.Double();
            double midT = (startT + endT) / 2.0;
            BezierUtils.halfSplitCurve(cubic, firstHalf, secondHalf);
            quad = new QuadCurve2D.Double();
            BezierUtils.applyMidPointApprox(firstHalf, quad);
            resultHere.processSegment(quad, startT, midT);
            quad = new QuadCurve2D.Double();
            BezierUtils.applyMidPointApprox(secondHalf, quad);
            resultHere.processSegment(quad, midT, endT);
        } else {
            double t = Math.cbrt(defect);
            double[] tes = new double[]{t, 1.0 - t};
            CubicCurve2D[] segs = new CubicCurve2D[]{null, null, null};
            BezierUtils.splitCurve(cubic, tes, segs);
            t = endT - startT;
            tes[0] = startT + tes[0] * t;
            tes[1] = startT + tes[1] * t;
            quad = new QuadCurve2D.Double();
            BezierUtils.applyMidPointApprox(segs[0], quad);
            resultHere.processSegment(quad, startT, tes[0]);
            segs[0] = null;
            quad = null;
            BezierUtils.doAdaptiveDegreeReduction(segs[1], precision, tes[0], tes[1], resultHere);
            segs[1] = null;
            quad = new QuadCurve2D.Double();
            BezierUtils.applyMidPointApprox(segs[2], quad);
            resultHere.processSegment(quad, tes[1], endT);
            segs[0] = null;
            quad = null;
        }
    }

    public static void adaptiveDegreeReduction(CubicCurve2D cubic, double precision, QuadSegmentConsumer resultHere) {
        if (precision < 0.0) {
            precision = -precision;
        }
        if (precision == 0.0) {
            precision = 1.0E-5;
        }
        if (null != cubic && null != resultHere) {
            BezierUtils.doAdaptiveDegreeReduction(cubic, precision, 0.0, 1.0, resultHere);
        }
    }

    public static class CubicArrayListConsumer
    implements CubicSegmentConsumer {
        protected ArrayList<CubicCurve2D> segs = new ArrayList();

        public void processSegment(CubicCurve2D curve, double startT, double endT) {
            this.segs.add(curve);
        }
    }

    public static class QuadArrayListConsumer
    implements QuadSegmentConsumer {
        protected ArrayList<QuadCurve2D> segs = new ArrayList();

        public void processSegment(QuadCurve2D curve, double startT, double endT) {
            this.segs.add(curve);
        }
    }

    static final class MidPointApproxTransformer
    implements CubicSegmentConsumer {
        QuadSegmentConsumer actualConsumer;

        MidPointApproxTransformer(QuadSegmentConsumer readConsumer) {
            this.actualConsumer = readConsumer;
        }

        public void processSegment(CubicCurve2D segment, double startT, double endT) {
            QuadCurve2D.Double midPointApprox = new QuadCurve2D.Double();
            BezierUtils.applyMidPointApprox(segment, midPointApprox);
            this.actualConsumer.processSegment(midPointApprox, startT, endT);
        }
    }

    static final class MidPointApproxSubdivCriterion
    implements CubicSubdivisionCriterion {
        protected double sqTol;

        MidPointApproxSubdivCriterion(double prec) {
            this.sqTol = prec * prec;
            if (this.sqTol < 1.0E-10) {
                this.sqTol = 1.0E-5;
            }
        }

        public boolean shouldSplit(CubicCurve2D c) {
            double dx = c.getCtrlX2() - c.getCtrlX1();
            dx = c.getX2() - c.getX1() - dx - dx - dx;
            double dy = c.getCtrlY2() - c.getCtrlY1();
            dy = c.getY2() - c.getY1() - dy - dy - dy;
            double sqDist = dx * dx + dy * dy;
            return sqDist * 0.0023148148148148147 <= this.sqTol;
        }
    }
}

