/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.ArraySorter;
import de.bwaldvogel.liblinear.DoubleArrayPointer;
import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.IntArrayPointer;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Problem;

class SolverMCSVM_CS {
    private final double[] B;
    private final double[] C;
    private final double eps;
    private final double[] G;
    private final int max_iter;
    private final int w_size;
    private final int l;
    private final int nr_class;
    private final Problem prob;

    public SolverMCSVM_CS(Problem prob, int nr_class, double[] C) {
        this(prob, nr_class, C, 0.1);
    }

    public SolverMCSVM_CS(Problem prob, int nr_class, double[] C, double eps) {
        this(prob, nr_class, C, eps, 100000);
    }

    public SolverMCSVM_CS(Problem prob, int nr_class, double[] weighted_C, double eps, int max_iter) {
        this.w_size = prob.n;
        this.l = prob.l;
        this.nr_class = nr_class;
        this.eps = eps;
        this.max_iter = max_iter;
        this.prob = prob;
        this.C = weighted_C;
        this.B = new double[nr_class];
        this.G = new double[nr_class];
    }

    private int GETI(int i) {
        return (int)this.prob.y[i];
    }

    private boolean be_shrunk(int i, int m, int yi, double alpha_i, double minG) {
        double bound = 0.0;
        if (m == yi) {
            bound = this.C[this.GETI(i)];
        }
        return alpha_i == bound && this.G[m] < minG;
    }

    public void solve(double[] w) {
        int m;
        int iter = 0;
        double[] alpha = new double[this.l * this.nr_class];
        double[] alpha_new = new double[this.nr_class];
        int[] index = new int[this.l];
        double[] QD = new double[this.l];
        int[] d_ind = new int[this.nr_class];
        double[] d_val = new double[this.nr_class];
        int[] alpha_index = new int[this.nr_class * this.l];
        int[] y_index = new int[this.l];
        int active_size = this.l;
        int[] active_size_i = new int[this.l];
        double eps_shrink = Math.max(10.0 * this.eps, 1.0);
        boolean start_from_all = true;
        int i = 0;
        while (i < this.l * this.nr_class) {
            alpha[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.w_size * this.nr_class) {
            w[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.l) {
            m = 0;
            while (m < this.nr_class) {
                alpha_index[i * this.nr_class + m] = m;
                ++m;
            }
            QD[i] = 0.0;
            Feature[] featureArray = this.prob.x[i];
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature xi = featureArray[n2];
                double val = xi.getValue();
                int n3 = i;
                QD[n3] = QD[n3] + val * val;
                ++n2;
            }
            active_size_i[i] = this.nr_class;
            y_index[i] = (int)this.prob.y[i];
            index[i] = i;
            ++i;
        }
        DoubleArrayPointer alpha_i = new DoubleArrayPointer(alpha, 0);
        IntArrayPointer alpha_index_i = new IntArrayPointer(alpha_index, 0);
        while (iter < this.max_iter) {
            double stopping = Double.NEGATIVE_INFINITY;
            i = 0;
            while (i < active_size) {
                int j = i + Linear.random.nextInt(active_size - i);
                Linear.swap(index, i, j);
                ++i;
            }
            int s = 0;
            while (s < active_size) {
                i = index[s];
                double Ai = QD[i];
                alpha_i.setOffset(i * this.nr_class);
                alpha_index_i.setOffset(i * this.nr_class);
                if (Ai > 0.0) {
                    m = 0;
                    while (m < active_size_i[i]) {
                        this.G[m] = 1.0;
                        ++m;
                    }
                    if (y_index[i] < active_size_i[i]) {
                        this.G[y_index[i]] = 0.0;
                    }
                    Feature[] featureArray = this.prob.x[i];
                    int n = featureArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Feature xi = featureArray[n4];
                        int w_offset = (xi.getIndex() - 1) * this.nr_class;
                        m = 0;
                        while (m < active_size_i[i]) {
                            int n5 = m;
                            this.G[n5] = this.G[n5] + w[w_offset + alpha_index_i.get(m)] * xi.getValue();
                            ++m;
                        }
                        ++n4;
                    }
                    double minG = Double.POSITIVE_INFINITY;
                    double maxG = Double.NEGATIVE_INFINITY;
                    m = 0;
                    while (m < active_size_i[i]) {
                        if (alpha_i.get(alpha_index_i.get(m)) < 0.0 && this.G[m] < minG) {
                            minG = this.G[m];
                        }
                        if (this.G[m] > maxG) {
                            maxG = this.G[m];
                        }
                        ++m;
                    }
                    if (y_index[i] < active_size_i[i] && alpha_i.get((int)this.prob.y[i]) < this.C[this.GETI(i)] && this.G[y_index[i]] < minG) {
                        minG = this.G[y_index[i]];
                    }
                    m = 0;
                    while (m < active_size_i[i]) {
                        if (this.be_shrunk(i, m, y_index[i], alpha_i.get(alpha_index_i.get(m)), minG)) {
                            int n6 = i;
                            active_size_i[n6] = active_size_i[n6] - 1;
                            while (active_size_i[i] > m) {
                                if (!this.be_shrunk(i, active_size_i[i], y_index[i], alpha_i.get(alpha_index_i.get(active_size_i[i])), minG)) {
                                    Linear.swap(alpha_index_i, m, active_size_i[i]);
                                    Linear.swap(this.G, m, active_size_i[i]);
                                    if (y_index[i] == active_size_i[i]) {
                                        y_index[i] = m;
                                        break;
                                    }
                                    if (y_index[i] != m) break;
                                    y_index[i] = active_size_i[i];
                                    break;
                                }
                                int n7 = i;
                                active_size_i[n7] = active_size_i[n7] - 1;
                            }
                        }
                        ++m;
                    }
                    if (active_size_i[i] <= 1) {
                        Linear.swap(index, s, --active_size);
                        --s;
                    } else if (!(maxG - minG <= 1.0E-12)) {
                        stopping = Math.max(maxG - minG, stopping);
                        m = 0;
                        while (m < active_size_i[i]) {
                            this.B[m] = this.G[m] - Ai * alpha_i.get(alpha_index_i.get(m));
                            ++m;
                        }
                        this.solve_sub_problem(Ai, y_index[i], this.C[this.GETI(i)], active_size_i[i], alpha_new);
                        int nz_d = 0;
                        m = 0;
                        while (m < active_size_i[i]) {
                            double d = alpha_new[m] - alpha_i.get(alpha_index_i.get(m));
                            alpha_i.set(alpha_index_i.get(m), alpha_new[m]);
                            if (Math.abs(d) >= 1.0E-12) {
                                d_ind[nz_d] = alpha_index_i.get(m);
                                d_val[nz_d] = d;
                                ++nz_d;
                            }
                            ++m;
                        }
                        Feature[] featureArray2 = this.prob.x[i];
                        int n8 = featureArray2.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            Feature xi = featureArray2[n9];
                            int w_offset = (xi.getIndex() - 1) * this.nr_class;
                            m = 0;
                            while (m < nz_d) {
                                int n10 = w_offset + d_ind[m];
                                w[n10] = w[n10] + d_val[m] * xi.getValue();
                                ++m;
                            }
                            ++n9;
                        }
                    }
                }
                ++s;
            }
            if (++iter % 10 == 0) {
                Linear.info(".");
            }
            if (stopping < eps_shrink) {
                if (stopping < this.eps && start_from_all) break;
                active_size = this.l;
                i = 0;
                while (i < this.l) {
                    active_size_i[i] = this.nr_class;
                    ++i;
                }
                Linear.info("*");
                eps_shrink = Math.max(eps_shrink / 2.0, this.eps);
                start_from_all = true;
                continue;
            }
            start_from_all = false;
        }
        Linear.info("%noptimization finished, #iter = %d%n", iter);
        if (iter >= this.max_iter) {
            Linear.info("%nWARNING: reaching max number of iterations%n");
        }
        double v = 0.0;
        int nSV = 0;
        i = 0;
        while (i < this.w_size * this.nr_class) {
            v += w[i] * w[i];
            ++i;
        }
        v *= 0.5;
        i = 0;
        while (i < this.l * this.nr_class) {
            v += alpha[i];
            if (Math.abs(alpha[i]) > 0.0) {
                ++nSV;
            }
            ++i;
        }
        i = 0;
        while (i < this.l) {
            v -= alpha[i * this.nr_class + (int)this.prob.y[i]];
            ++i;
        }
        Linear.info("Objective value = %f%n", v);
        Linear.info("nSV = %d%n", nSV);
    }

    private void solve_sub_problem(double A_i, int yi, double C_yi, int active_i, double[] alpha_new) {
        assert (active_i <= this.B.length);
        double[] D = Linear.copyOf(this.B, active_i);
        if (yi < active_i) {
            int n = yi;
            D[n] = D[n] + A_i * C_yi;
        }
        ArraySorter.reversedMergesort(D);
        double beta = D[0] - A_i * C_yi;
        int r = 1;
        while (r < active_i && beta < (double)r * D[r]) {
            beta += D[r];
            ++r;
        }
        beta /= (double)r;
        r = 0;
        while (r < active_i) {
            alpha_new[r] = r == yi ? Math.min(C_yi, (beta - this.B[r]) / A_i) : Math.min(0.0, (beta - this.B[r]) / A_i);
            ++r;
        }
    }
}

