/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.DenseL2R_L2_SvcFunction;
import de.bwaldvogel.liblinear.DenseL2R_L2_SvrFunction;
import de.bwaldvogel.liblinear.DenseL2R_LrFunction;
import de.bwaldvogel.liblinear.DenseProblem;
import de.bwaldvogel.liblinear.DenseSolverMCSVM_CS;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.IntArrayPointer;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.SolverType;
import de.bwaldvogel.liblinear.Tron;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;

public class DenseLinear {
    static final Charset FILE_CHARSET = Charset.forName("ISO-8859-1");
    static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static Object OUTPUT_MUTEX = new Object();
    private static PrintStream DEBUG_OUTPUT = System.out;
    private static final long DEFAULT_RANDOM_SEED = 0L;
    static Random random = new Random(0L);

    public static void crossValidation(DenseProblem prob, Parameter param, int nr_fold, double[] target) {
        int[] fold_start = new int[nr_fold + 1];
        int l = prob.l;
        int[] perm = new int[l];
        int i = 0;
        while (i < l) {
            perm[i] = i;
            ++i;
        }
        i = 0;
        while (i < l) {
            int j = i + random.nextInt(l - i);
            DenseLinear.swap(perm, i, j);
            ++i;
        }
        i = 0;
        while (i <= nr_fold) {
            fold_start[i] = i * l / nr_fold;
            ++i;
        }
        i = 0;
        while (i < nr_fold) {
            int begin = fold_start[i];
            int end = fold_start[i + 1];
            DenseProblem subprob = new DenseProblem();
            subprob.bias = prob.bias;
            subprob.n = prob.n;
            subprob.l = l - (end - begin);
            subprob.x = new double[subprob.l][];
            subprob.y = new double[subprob.l];
            int k = 0;
            int j = 0;
            while (j < begin) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
                ++j;
            }
            j = end;
            while (j < l) {
                subprob.x[k] = prob.x[perm[j]];
                subprob.y[k] = prob.y[perm[j]];
                ++k;
                ++j;
            }
            Model submodel = DenseLinear.train(subprob, param);
            j = begin;
            while (j < end) {
                target[perm[j]] = DenseLinear.predict(submodel, prob.x[perm[j]]);
                ++j;
            }
            ++i;
        }
    }

    private static GroupClassesReturn groupClasses(DenseProblem prob, int[] perm) {
        int l = prob.l;
        int max_nr_class = 16;
        int nr_class = 0;
        int[] label = new int[max_nr_class];
        int[] count = new int[max_nr_class];
        int[] data_label = new int[l];
        int i = 0;
        while (i < l) {
            int this_label = (int)prob.y[i];
            int j = 0;
            while (j < nr_class) {
                if (this_label == label[j]) {
                    int n = j;
                    count[n] = count[n] + 1;
                    break;
                }
                ++j;
            }
            data_label[i] = j;
            if (j == nr_class) {
                if (nr_class == max_nr_class) {
                    label = DenseLinear.copyOf(label, max_nr_class *= 2);
                    count = DenseLinear.copyOf(count, max_nr_class);
                }
                label[nr_class] = this_label;
                count[nr_class] = 1;
                ++nr_class;
            }
            ++i;
        }
        int[] start = new int[nr_class];
        start[0] = 0;
        i = 1;
        while (i < nr_class) {
            start[i] = start[i - 1] + count[i - 1];
            ++i;
        }
        i = 0;
        while (i < l) {
            perm[start[data_label[i]]] = i;
            int n = data_label[i];
            start[n] = start[n] + 1;
            ++i;
        }
        start[0] = 0;
        i = 1;
        while (i < nr_class) {
            start[i] = start[i - 1] + count[i - 1];
            ++i;
        }
        return new GroupClassesReturn(nr_class, label, start, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void info(String message) {
        Object object = OUTPUT_MUTEX;
        synchronized (object) {
            if (DEBUG_OUTPUT == null) {
                return;
            }
            DEBUG_OUTPUT.printf(message, new Object[0]);
            DEBUG_OUTPUT.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void info(String format, Object ... args) {
        Object object = OUTPUT_MUTEX;
        synchronized (object) {
            if (DEBUG_OUTPUT == null) {
                return;
            }
            DEBUG_OUTPUT.printf(format, args);
            DEBUG_OUTPUT.flush();
        }
    }

    static double atof(String s) {
        if (s == null || s.length() < 1) {
            throw new IllegalArgumentException("Can't convert empty string to integer");
        }
        double d = Double.parseDouble(s);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("NaN or Infinity in input: " + s);
        }
        return d;
    }

    static int atoi(String s) throws NumberFormatException {
        if (s == null || s.length() < 1) {
            throw new IllegalArgumentException("Can't convert empty string to integer");
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static Model loadModel(Reader inputReader) throws IOException {
        Model model = new Model();
        model.label = null;
        Pattern whitespace = Pattern.compile("\\s+");
        BufferedReader reader = null;
        reader = inputReader instanceof BufferedReader ? (BufferedReader)inputReader : new BufferedReader(inputReader);
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split = whitespace.split(line);
            if (split[0].equals("solver_type")) {
                SolverType solver = SolverType.valueOf(split[1]);
                if (solver == null) {
                    throw new RuntimeException("unknown solver type");
                }
                model.solverType = solver;
                continue;
            }
            if (split[0].equals("nr_class")) {
                model.nr_class = DenseLinear.atoi(split[1]);
                Integer.parseInt(split[1]);
                continue;
            }
            if (split[0].equals("nr_feature")) {
                model.nr_feature = DenseLinear.atoi(split[1]);
                continue;
            }
            if (split[0].equals("bias")) {
                model.bias = DenseLinear.atof(split[1]);
                continue;
            }
            if (split[0].equals("w")) break;
            if (split[0].equals("label")) {
                model.label = new int[model.nr_class];
                int i = 0;
                while (i < model.nr_class) {
                    model.label[i] = DenseLinear.atoi(split[i + 1]);
                    ++i;
                }
                continue;
            }
            throw new RuntimeException("unknown text in model file: [" + line + "]");
        }
        int w_size = model.nr_feature;
        if (model.bias >= 0.0) {
            ++w_size;
        }
        int nr_w = model.nr_class;
        if (model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS) {
            nr_w = 1;
        }
        model.w = new double[w_size * nr_w];
        int[] buffer = new int[128];
        int i = 0;
        while (i < w_size) {
            int j = 0;
            while (j < nr_w) {
                int b = 0;
                while (true) {
                    int ch;
                    if ((ch = reader.read()) == -1) {
                        throw new EOFException("unexpected EOF");
                    }
                    if (ch == 32) break;
                    buffer[b++] = ch;
                }
                model.w[i * nr_w + j] = DenseLinear.atof(new String(buffer, 0, b));
                ++j;
            }
            ++i;
        }
        return model;
    }

    public static Model loadModel(File modelFile) throws IOException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(modelFile), FILE_CHARSET));
        try {
            Model model = DenseLinear.loadModel(inputReader);
            return model;
        }
        finally {
            inputReader.close();
        }
    }

    static void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static double predict(Model model, double[] x) {
        double[] dec_values = new double[model.nr_class];
        return DenseLinear.predictValues(model, x, dec_values);
    }

    public static double predictProbability(Model model, double[] x, double[] prob_estimates) throws IllegalArgumentException {
        if (!model.isProbabilityModel()) {
            StringBuilder sb = new StringBuilder("probability output is only supported for logistic regression");
            sb.append(". This is currently only supported by the following solvers: ");
            int i = 0;
            SolverType[] solverTypeArray = SolverType.values();
            int n = solverTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SolverType solverType = solverTypeArray[n2];
                if (solverType.isLogisticRegressionSolver()) {
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(solverType.name());
                }
                ++n2;
            }
            throw new IllegalArgumentException(sb.toString());
        }
        int nr_class = model.nr_class;
        int nr_w = nr_class == 2 ? 1 : nr_class;
        double label = DenseLinear.predictValues(model, x, prob_estimates);
        int i = 0;
        while (i < nr_w) {
            prob_estimates[i] = 1.0 / (1.0 + Math.exp(-prob_estimates[i]));
            ++i;
        }
        if (nr_class == 2) {
            prob_estimates[1] = 1.0 - prob_estimates[0];
        } else {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < nr_class) {
                sum += prob_estimates[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < nr_class) {
                prob_estimates[i2] = prob_estimates[i2] / sum;
                ++i2;
            }
        }
        return label;
    }

    public static double predictValues(Model model, double[] x, double[] dec_values) {
        int i;
        int n = model.bias >= 0.0 ? model.nr_feature + 1 : model.nr_feature;
        double[] w = model.w;
        int nr_w = model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS ? 1 : model.nr_class;
        int i2 = 0;
        while (i2 < nr_w) {
            dec_values[i2] = 0.0;
            ++i2;
        }
        int idx = 0;
        while (idx < n) {
            i = 0;
            while (i < nr_w) {
                int n2 = i;
                dec_values[n2] = dec_values[n2] + w[idx * nr_w + i] * x[idx];
                ++i;
            }
            ++idx;
        }
        if (model.nr_class == 2) {
            if (model.solverType.isSupportVectorRegression()) {
                return dec_values[0];
            }
            return dec_values[0] > 0.0 ? model.label[0] : model.label[1];
        }
        int dec_max_idx = 0;
        i = 1;
        while (i < model.nr_class) {
            if (dec_values[i] > dec_values[dec_max_idx]) {
                dec_max_idx = i;
            }
            ++i;
        }
        return model.label[dec_max_idx];
    }

    static void printf(Formatter formatter, String format, Object ... args) throws IOException {
        formatter.format(format, args);
        IOException ioException = formatter.ioException();
        if (ioException != null) {
            throw ioException;
        }
    }

    public static void saveModel(Writer modelOutput, Model model) throws IOException {
        int nr_feature;
        int w_size = nr_feature = model.nr_feature;
        if (model.bias >= 0.0) {
            ++w_size;
        }
        int nr_w = model.nr_class;
        if (model.nr_class == 2 && model.solverType != SolverType.MCSVM_CS) {
            nr_w = 1;
        }
        Formatter formatter = new Formatter(modelOutput, DEFAULT_LOCALE);
        try {
            int i;
            DenseLinear.printf(formatter, "solver_type %s\n", model.solverType.name());
            DenseLinear.printf(formatter, "nr_class %d\n", model.nr_class);
            if (model.label != null) {
                DenseLinear.printf(formatter, "label", new Object[0]);
                i = 0;
                while (i < model.nr_class) {
                    DenseLinear.printf(formatter, " %d", model.label[i]);
                    ++i;
                }
                DenseLinear.printf(formatter, "\n", new Object[0]);
            }
            DenseLinear.printf(formatter, "nr_feature %d\n", nr_feature);
            DenseLinear.printf(formatter, "bias %.16g\n", model.bias);
            DenseLinear.printf(formatter, "w\n", new Object[0]);
            i = 0;
            while (i < w_size) {
                int j = 0;
                while (j < nr_w) {
                    double value = model.w[i * nr_w + j];
                    if (value == 0.0) {
                        DenseLinear.printf(formatter, "%d ", 0);
                    } else {
                        DenseLinear.printf(formatter, "%.16g ", value);
                    }
                    ++j;
                }
                DenseLinear.printf(formatter, "\n", new Object[0]);
                ++i;
            }
            formatter.flush();
            IOException ioException = formatter.ioException();
            if (ioException != null) {
                throw ioException;
            }
        }
        finally {
            formatter.close();
        }
    }

    public static void saveModel(File modelFile, Model model) throws IOException {
        BufferedWriter modelOutput = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(modelFile), FILE_CHARSET));
        DenseLinear.saveModel(modelOutput, model);
    }

    private static int GETI(byte[] y, int i) {
        return y[i] + 1;
    }

    private static void solve_l2r_l1l2_svc(DenseProblem prob, double[] w, double eps, double Cp, double Cn, SolverType solver_type) {
        int j;
        int l = prob.l;
        int w_size = prob.n;
        int iter = 0;
        double[] QD = new double[l];
        int max_iter = 1000;
        int[] index = new int[l];
        double[] alpha = new double[l];
        byte[] y = new byte[l];
        int active_size = l;
        double PGmax_old = Double.POSITIVE_INFINITY;
        double PGmin_old = Double.NEGATIVE_INFINITY;
        double[] diag = new double[]{0.5 / Cn, 0.0, 0.5 / Cp};
        double[] upper_bound = new double[]{Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY};
        if (solver_type == SolverType.L2R_L1LOSS_SVC_DUAL) {
            diag[0] = 0.0;
            diag[2] = 0.0;
            upper_bound[0] = Cn;
            upper_bound[2] = Cp;
        }
        int i = 0;
        while (i < l) {
            y[i] = prob.y[i] > 0.0 ? 1 : -1;
            ++i;
        }
        i = 0;
        while (i < l) {
            alpha[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < w_size) {
            w[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < l) {
            QD[i] = diag[DenseLinear.GETI(y, i)];
            j = 0;
            while (j < w_size) {
                double val = prob.x[i][j];
                int n = i;
                QD[n] = QD[n] + val * val;
                int n2 = j++;
                w[n2] = w[n2] + (double)y[i] * alpha[i] * val;
            }
            index[i] = i;
            ++i;
        }
        while (iter < 1000) {
            double PGmax_new = Double.NEGATIVE_INFINITY;
            double PGmin_new = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < active_size) {
                j = i + random.nextInt(active_size - i);
                DenseLinear.swap(index, i, j);
                ++i;
            }
            int s = 0;
            while (s < active_size) {
                block23: {
                    double PG;
                    double C;
                    byte yi;
                    double G;
                    block24: {
                        block25: {
                            block26: {
                                block21: {
                                    block22: {
                                        i = index[s];
                                        G = 0.0;
                                        yi = y[i];
                                        int j2 = 0;
                                        while (j2 < w_size) {
                                            G += w[j2] * prob.x[i][j2];
                                            ++j2;
                                        }
                                        G = G * (double)yi - 1.0;
                                        C = upper_bound[DenseLinear.GETI(y, i)];
                                        G += alpha[i] * diag[DenseLinear.GETI(y, i)];
                                        PG = 0.0;
                                        if (alpha[i] != 0.0) break block21;
                                        if (!(G > PGmax_old)) break block22;
                                        DenseLinear.swap(index, s, --active_size);
                                        --s;
                                        break block23;
                                    }
                                    if (G < 0.0) {
                                        PG = G;
                                    }
                                    break block24;
                                }
                                if (alpha[i] != C) break block25;
                                if (!(G < PGmin_old)) break block26;
                                DenseLinear.swap(index, s, --active_size);
                                --s;
                                break block23;
                            }
                            if (G > 0.0) {
                                PG = G;
                            }
                            break block24;
                        }
                        PG = G;
                    }
                    PGmax_new = Math.max(PGmax_new, PG);
                    PGmin_new = Math.min(PGmin_new, PG);
                    if (Math.abs(PG) > 1.0E-12) {
                        double alpha_old = alpha[i];
                        alpha[i] = Math.min(Math.max(alpha[i] - G / QD[i], 0.0), C);
                        double d = (alpha[i] - alpha_old) * (double)yi;
                        int j3 = 0;
                        while (j3 < w_size) {
                            int n = j3;
                            w[n] = w[n] + d * prob.x[i][j3];
                            ++j3;
                        }
                    }
                }
                ++s;
            }
            if (++iter % 10 == 0) {
                DenseLinear.info(".");
            }
            if (PGmax_new - PGmin_new <= eps) {
                if (active_size == l) break;
                active_size = l;
                DenseLinear.info("*");
                PGmax_old = Double.POSITIVE_INFINITY;
                PGmin_old = Double.NEGATIVE_INFINITY;
                continue;
            }
            PGmax_old = PGmax_new;
            PGmin_old = PGmin_new;
            if (PGmax_old <= 0.0) {
                PGmax_old = Double.POSITIVE_INFINITY;
            }
            if (!(PGmin_old >= 0.0)) continue;
            PGmin_old = Double.NEGATIVE_INFINITY;
        }
        DenseLinear.info("%noptimization finished, #iter = %d%n", iter);
        if (iter >= 1000) {
            DenseLinear.info("%nWARNING: reaching max number of iterations%nUsing -s 2 may be faster (also see FAQ)%n%n");
        }
        double v = 0.0;
        int nSV = 0;
        i = 0;
        while (i < w_size) {
            v += w[i] * w[i];
            ++i;
        }
        i = 0;
        while (i < l) {
            v += alpha[i] * (alpha[i] * diag[DenseLinear.GETI(y, i)] - 2.0);
            if (alpha[i] > 0.0) {
                ++nSV;
            }
            ++i;
        }
        DenseLinear.info("Objective value = %g%n", v / 2.0);
        DenseLinear.info("nSV = %d%n", nSV);
    }

    private static int GETI_SVR(int i) {
        return 0;
    }

    private static void solve_l2r_l1l2_svr(DenseProblem prob, double[] w, Parameter param) {
        double val;
        int l = prob.l;
        double C = param.C;
        double p = param.p;
        int w_size = prob.n;
        double eps = param.eps;
        int iter = 0;
        int max_iter = 1000;
        int active_size = l;
        int[] index = new int[l];
        double Gmax_old = Double.POSITIVE_INFINITY;
        double Gnorm1_init = 0.0;
        double[] beta = new double[l];
        double[] QD = new double[l];
        double[] y = prob.y;
        double[] lambda = new double[]{0.5 / C};
        double[] upper_bound = new double[]{Double.POSITIVE_INFINITY};
        if (param.solverType == SolverType.L2R_L1LOSS_SVR_DUAL) {
            lambda[0] = 0.0;
            upper_bound[0] = C;
        }
        int i = 0;
        while (i < l) {
            beta[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < w_size) {
            w[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < l) {
            QD[i] = 0.0;
            int j = 0;
            while (j < w_size) {
                val = prob.x[i][j];
                int n = i;
                QD[n] = QD[n] + val * val;
                int n2 = j++;
                w[n2] = w[n2] + beta[i] * val;
            }
            index[i] = i;
            ++i;
        }
        while (iter < 1000) {
            double Gmax_new = 0.0;
            double Gnorm1_new = 0.0;
            i = 0;
            while (i < active_size) {
                int j = i + random.nextInt(active_size - i);
                DenseLinear.swap(index, i, j);
                ++i;
            }
            int s = 0;
            while (s < active_size) {
                block23: {
                    double violation;
                    double Gn;
                    double Gp;
                    double H;
                    block21: {
                        block26: {
                            block27: {
                                block24: {
                                    block25: {
                                        block19: {
                                            block22: {
                                                block20: {
                                                    i = index[s];
                                                    double G = -y[i] + lambda[DenseLinear.GETI_SVR(i)] * beta[i];
                                                    H = QD[i] + lambda[DenseLinear.GETI_SVR(i)];
                                                    int ind = 0;
                                                    while (ind < w_size) {
                                                        val = prob.x[i][ind];
                                                        G += val * w[ind];
                                                        ++ind;
                                                    }
                                                    Gp = G + p;
                                                    Gn = G - p;
                                                    violation = 0.0;
                                                    if (beta[i] != 0.0) break block19;
                                                    if (!(Gp < 0.0)) break block20;
                                                    violation = -Gp;
                                                    break block21;
                                                }
                                                if (!(Gn > 0.0)) break block22;
                                                violation = Gn;
                                                break block21;
                                            }
                                            if (!(Gp > Gmax_old) || !(Gn < -Gmax_old)) break block21;
                                            DenseLinear.swap(index, s, --active_size);
                                            --s;
                                            break block23;
                                        }
                                        if (!(beta[i] >= upper_bound[DenseLinear.GETI_SVR(i)])) break block24;
                                        if (!(Gp > 0.0)) break block25;
                                        violation = Gp;
                                        break block21;
                                    }
                                    if (!(Gp < -Gmax_old)) break block21;
                                    DenseLinear.swap(index, s, --active_size);
                                    --s;
                                    break block23;
                                }
                                if (!(beta[i] <= -upper_bound[DenseLinear.GETI_SVR(i)])) break block26;
                                if (!(Gn < 0.0)) break block27;
                                violation = -Gn;
                                break block21;
                            }
                            if (!(Gn > Gmax_old)) break block21;
                            DenseLinear.swap(index, s, --active_size);
                            --s;
                            break block23;
                        }
                        violation = beta[i] > 0.0 ? Math.abs(Gp) : Math.abs(Gn);
                    }
                    Gmax_new = Math.max(Gmax_new, violation);
                    Gnorm1_new += violation;
                    double d = Gp < H * beta[i] ? -Gp / H : (Gn > H * beta[i] ? -Gn / H : -beta[i]);
                    if (!(Math.abs(d) < 1.0E-12)) {
                        double beta_old = beta[i];
                        beta[i] = Math.min(Math.max(beta[i] + d, -upper_bound[DenseLinear.GETI_SVR(i)]), upper_bound[DenseLinear.GETI_SVR(i)]);
                        d = beta[i] - beta_old;
                        if (d != 0.0) {
                            int j = 0;
                            while (j < w_size) {
                                int n = j;
                                w[n] = w[n] + d * prob.x[i][j];
                                ++j;
                            }
                        }
                    }
                }
                ++s;
            }
            if (iter == 0) {
                Gnorm1_init = Gnorm1_new;
            }
            if (++iter % 10 == 0) {
                DenseLinear.info(".");
            }
            if (Gnorm1_new <= eps * Gnorm1_init) {
                if (active_size == l) break;
                active_size = l;
                DenseLinear.info("*");
                Gmax_old = Double.POSITIVE_INFINITY;
                continue;
            }
            Gmax_old = Gmax_new;
        }
        DenseLinear.info("%noptimization finished, #iter = %d%n", iter);
        if (iter >= 1000) {
            DenseLinear.info("%nWARNING: reaching max number of iterations%nUsing -s 11 may be faster%n%n");
        }
        double v = 0.0;
        int nSV = 0;
        i = 0;
        while (i < w_size) {
            v += w[i] * w[i];
            ++i;
        }
        v *= 0.5;
        i = 0;
        while (i < l) {
            v += p * Math.abs(beta[i]) - y[i] * beta[i] + 0.5 * lambda[DenseLinear.GETI_SVR(i)] * beta[i] * beta[i];
            if (beta[i] != 0.0) {
                ++nSV;
            }
            ++i;
        }
        DenseLinear.info("Objective value = %g%n", v);
        DenseLinear.info("nSV = %d%n", nSV);
    }

    private static void solve_l2r_lr_dual(DenseProblem prob, double[] w, double eps, double Cp, double Cn) {
        int j;
        int l = prob.l;
        int w_size = prob.n;
        int iter = 0;
        double[] xTx = new double[l];
        int max_iter = 1000;
        int[] index = new int[l];
        double[] alpha = new double[2 * l];
        byte[] y = new byte[l];
        int max_inner_iter = 100;
        double innereps = 0.01;
        double innereps_min = Math.min(1.0E-8, eps);
        double[] upper_bound = new double[]{Cn, 0.0, Cp};
        int i = 0;
        while (i < l) {
            y[i] = prob.y[i] > 0.0 ? 1 : -1;
            ++i;
        }
        i = 0;
        while (i < l) {
            alpha[2 * i] = Math.min(0.001 * upper_bound[DenseLinear.GETI(y, i)], 1.0E-8);
            alpha[2 * i + 1] = upper_bound[DenseLinear.GETI(y, i)] - alpha[2 * i];
            ++i;
        }
        i = 0;
        while (i < w_size) {
            w[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < l) {
            xTx[i] = 0.0;
            j = 0;
            while (j < w_size) {
                double val = prob.x[i][j];
                int n = i;
                xTx[n] = xTx[n] + val * val;
                int n2 = j++;
                w[n2] = w[n2] + (double)y[i] * alpha[2 * i] * val;
            }
            index[i] = i;
            ++i;
        }
        while (iter < 1000) {
            i = 0;
            while (i < l) {
                j = i + random.nextInt(l - i);
                DenseLinear.swap(index, i, j);
                ++i;
            }
            int newton_iter = 0;
            double Gmax = 0.0;
            int s = 0;
            while (s < l) {
                double alpha_old;
                double z;
                i = index[s];
                byte yi = y[i];
                double C = upper_bound[DenseLinear.GETI(y, i)];
                double ywTx = 0.0;
                double xisq = xTx[i];
                int j2 = 0;
                while (j2 < w_size) {
                    ywTx += w[j2] * prob.x[i][j2];
                    ++j2;
                }
                double a = xisq;
                double b = ywTx *= (double)y[i];
                int ind1 = 2 * i;
                int ind2 = 2 * i + 1;
                int sign = 1;
                if (0.5 * a * (alpha[ind2] - alpha[ind1]) + b < 0.0) {
                    ind1 = 2 * i + 1;
                    ind2 = 2 * i;
                    sign = -1;
                }
                if (C - (z = (alpha_old = alpha[ind1])) < 0.5 * C) {
                    z *= 0.1;
                }
                double gp = a * (z - alpha_old) + (double)sign * b + Math.log(z / (C - z));
                Gmax = Math.max(Gmax, Math.abs(gp));
                double eta = 0.1;
                int inner_iter = 0;
                while (inner_iter <= 100) {
                    if (Math.abs(gp) < innereps) break;
                    double gpp = a + C / (C - z) / z;
                    double tmpz = z - gp / gpp;
                    z = tmpz <= 0.0 ? (z *= 0.1) : tmpz;
                    gp = a * (z - alpha_old) + (double)sign * b + Math.log(z / (C - z));
                    ++newton_iter;
                    ++inner_iter;
                }
                if (inner_iter > 0) {
                    alpha[ind1] = z;
                    alpha[ind2] = C - z;
                    int j3 = 0;
                    while (j3 < w_size) {
                        int n = j3;
                        w[n] = w[n] + (double)sign * (z - alpha_old) * (double)yi * prob.x[i][j3];
                        ++j3;
                    }
                }
                ++s;
            }
            if (++iter % 10 == 0) {
                DenseLinear.info(".");
            }
            if (Gmax < eps) break;
            if (newton_iter > l / 10) continue;
            innereps = Math.max(innereps_min, 0.1 * innereps);
        }
        DenseLinear.info("%noptimization finished, #iter = %d%n", iter);
        if (iter >= 1000) {
            DenseLinear.info("%nWARNING: reaching max number of iterations%nUsing -s 0 may be faster (also see FAQ)%n%n");
        }
        double v = 0.0;
        i = 0;
        while (i < w_size) {
            v += w[i] * w[i];
            ++i;
        }
        v *= 0.5;
        i = 0;
        while (i < l) {
            v += alpha[2 * i] * Math.log(alpha[2 * i]) + alpha[2 * i + 1] * Math.log(alpha[2 * i + 1]) - upper_bound[DenseLinear.GETI(y, i)] * Math.log(upper_bound[DenseLinear.GETI(y, i)]);
            ++i;
        }
        DenseLinear.info("Objective value = %g%n", v);
    }

    private static void solve_l1r_l2_svc(DenseProblem prob_col, double[] w, double eps, double Cp, double Cn) {
        double val;
        int l = prob_col.l;
        int w_size = prob_col.n;
        int iter = 0;
        int max_iter = 1000;
        int active_size = w_size;
        int max_num_linesearch = 20;
        double sigma = 0.01;
        double Gmax_old = Double.POSITIVE_INFINITY;
        double Gnorm1_init = 0.0;
        double loss_old = 0.0;
        int[] index = new int[w_size];
        byte[] y = new byte[l];
        double[] b = new double[l];
        double[] xj_sq = new double[w_size];
        double[] C = new double[]{Cn, 0.0, Cp};
        int j = 0;
        while (j < w_size) {
            w[j] = 0.0;
            ++j;
        }
        j = 0;
        while (j < l) {
            b[j] = 1.0;
            y[j] = prob_col.y[j] > 0.0 ? 1 : -1;
            ++j;
        }
        j = 0;
        while (j < w_size) {
            index[j] = j;
            xj_sq[j] = 0.0;
            int ind = 0;
            while (ind < w_size) {
                prob_col.x[j][ind] = prob_col.x[j][ind] * (double)y[ind];
                val = prob_col.x[j][ind];
                int n = ind;
                b[n] = b[n] - w[j] * val;
                int n2 = j;
                xj_sq[n2] = xj_sq[n2] + C[DenseLinear.GETI(y, ind)] * val * val;
                ++ind;
            }
            ++j;
        }
        while (iter < 1000) {
            double Gmax_new = 0.0;
            double Gnorm1_new = 0.0;
            j = 0;
            while (j < active_size) {
                int i = j + random.nextInt(active_size - j);
                DenseLinear.swap(index, i, j);
                ++j;
            }
            int s = 0;
            while (s < active_size) {
                block38: {
                    double violation;
                    double Gn;
                    double Gp;
                    double G;
                    double H;
                    double G_loss;
                    block36: {
                        block34: {
                            block37: {
                                block35: {
                                    j = index[s];
                                    G_loss = 0.0;
                                    H = 0.0;
                                    int ind = 0;
                                    while (ind < w_size) {
                                        if (b[ind] > 0.0) {
                                            val = prob_col.x[j][ind];
                                            double tmp = C[DenseLinear.GETI(y, ind)] * val;
                                            G_loss -= tmp * b[ind];
                                            H += tmp * val;
                                        }
                                        ++ind;
                                    }
                                    G = G_loss *= 2.0;
                                    H *= 2.0;
                                    H = Math.max(H, 1.0E-12);
                                    Gp = G + 1.0;
                                    Gn = G - 1.0;
                                    violation = 0.0;
                                    if (w[j] != 0.0) break block34;
                                    if (!(Gp < 0.0)) break block35;
                                    violation = -Gp;
                                    break block36;
                                }
                                if (!(Gn > 0.0)) break block37;
                                violation = Gn;
                                break block36;
                            }
                            if (!(Gp > Gmax_old / (double)l) || !(Gn < -Gmax_old / (double)l)) break block36;
                            DenseLinear.swap(index, s, --active_size);
                            --s;
                            break block38;
                        }
                        violation = w[j] > 0.0 ? Math.abs(Gp) : Math.abs(Gn);
                    }
                    Gmax_new = Math.max(Gmax_new, violation);
                    Gnorm1_new += violation;
                    double d = Gp < H * w[j] ? -Gp / H : (Gn > H * w[j] ? -Gn / H : -w[j]);
                    if (!(Math.abs(d) < 1.0E-12)) {
                        double delta = Math.abs(w[j] + d) - Math.abs(w[j]) + G * d;
                        double d_old = 0.0;
                        int num_linesearch = 0;
                        while (num_linesearch < 20) {
                            double b_new;
                            double loss_new;
                            int ind;
                            double d_diff = d_old - d;
                            double cond = Math.abs(w[j] + d) - Math.abs(w[j]) - 0.01 * delta;
                            double appxcond = xj_sq[j] * d * d + G_loss * d + cond;
                            if (appxcond <= 0.0) {
                                ind = 0;
                                while (ind < prob_col.x[j].length) {
                                    int n = ind;
                                    b[n] = b[n] + d_diff * prob_col.x[j][ind];
                                    ++ind;
                                }
                                break;
                            }
                            if (num_linesearch == 0) {
                                loss_old = 0.0;
                                loss_new = 0.0;
                                ind = 0;
                                while (ind < prob_col.x[j].length) {
                                    if (b[ind] > 0.0) {
                                        loss_old += C[DenseLinear.GETI(y, ind)] * b[ind] * b[ind];
                                    }
                                    b[ind] = b_new = b[ind] + d_diff * prob_col.x[j][ind];
                                    if (b_new > 0.0) {
                                        loss_new += C[DenseLinear.GETI(y, ind)] * b_new * b_new;
                                    }
                                    ++ind;
                                }
                            } else {
                                loss_new = 0.0;
                                ind = 0;
                                while (ind < prob_col.x[j].length) {
                                    b[ind] = b_new = b[ind] + d_diff * prob_col.x[j][ind];
                                    if (b_new > 0.0) {
                                        loss_new += C[DenseLinear.GETI(y, ind)] * b_new * b_new;
                                    }
                                    ++ind;
                                }
                            }
                            cond = cond + loss_new - loss_old;
                            if (cond <= 0.0) break;
                            d_old = d;
                            d *= 0.5;
                            delta *= 0.5;
                            ++num_linesearch;
                        }
                        int n = j;
                        w[n] = w[n] + d;
                        if (num_linesearch >= 20) {
                            DenseLinear.info("#");
                            int i = 0;
                            while (i < l) {
                                b[i] = 1.0;
                                ++i;
                            }
                            i = 0;
                            while (i < w_size) {
                                if (w[i] != 0.0) {
                                    int ind = 0;
                                    while (ind < prob_col.x[j].length) {
                                        int n3 = ind;
                                        b[n3] = b[n3] - w[i] * prob_col.x[j][ind];
                                        ++ind;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                ++s;
            }
            if (iter == 0) {
                Gnorm1_init = Gnorm1_new;
            }
            if (++iter % 10 == 0) {
                DenseLinear.info(".");
            }
            if (Gmax_new <= eps * Gnorm1_init) {
                if (active_size == w_size) break;
                active_size = w_size;
                DenseLinear.info("*");
                Gmax_old = Double.POSITIVE_INFINITY;
                continue;
            }
            Gmax_old = Gmax_new;
        }
        DenseLinear.info("%noptimization finished, #iter = %d%n", iter);
        if (iter >= 1000) {
            DenseLinear.info("%nWARNING: reaching max number of iterations%n");
        }
        double v = 0.0;
        int nnz = 0;
        j = 0;
        while (j < w_size) {
            int ind = 0;
            while (ind < prob_col.x[j].length) {
                prob_col.x[j][ind] = prob_col.x[j][ind] * prob_col.y[ind];
                ++ind;
            }
            if (w[j] != 0.0) {
                v += Math.abs(w[j]);
                ++nnz;
            }
            ++j;
        }
        j = 0;
        while (j < l) {
            if (b[j] > 0.0) {
                v += C[DenseLinear.GETI(y, j)] * b[j] * b[j];
            }
            ++j;
        }
        DenseLinear.info("Objective value = %g%n", v);
        DenseLinear.info("#nonzeros/#features = %d/%d%n", nnz, w_size);
    }

    private static void solve_l1r_lr(DenseProblem prob_col, double[] w, double eps, double Cp, double Cn) {
        int l = prob_col.l;
        int w_size = prob_col.n;
        int newton_iter = 0;
        int iter = 0;
        int max_newton_iter = 100;
        int max_iter = 1000;
        int max_num_linesearch = 20;
        double nu = 1.0E-12;
        double inner_eps = 1.0;
        double sigma = 0.01;
        double Gnorm1_init = 0.0;
        double Gmax_old = Double.POSITIVE_INFINITY;
        double QP_Gmax_old = Double.POSITIVE_INFINITY;
        int[] index = new int[w_size];
        byte[] y = new byte[l];
        double[] Hdiag = new double[w_size];
        double[] Grad = new double[w_size];
        double[] wpd = new double[w_size];
        double[] xjneg_sum = new double[w_size];
        double[] xTd = new double[l];
        double[] exp_wTx = new double[l];
        double[] exp_wTx_new = new double[l];
        double[] tau = new double[l];
        double[] D = new double[l];
        double[] C = new double[]{Cn, 0.0, Cp};
        int j = 0;
        while (j < w_size) {
            w[j] = 0.0;
            ++j;
        }
        j = 0;
        while (j < l) {
            y[j] = prob_col.y[j] > 0.0 ? 1 : -1;
            exp_wTx[j] = 0.0;
            ++j;
        }
        double w_norm = 0.0;
        j = 0;
        while (j < w_size) {
            w_norm += Math.abs(w[j]);
            wpd[j] = w[j];
            index[j] = j;
            xjneg_sum[j] = 0.0;
            int ind = 0;
            while (ind < prob_col.x[j].length) {
                double val = prob_col.x[j][ind];
                int n = ind;
                exp_wTx[n] = exp_wTx[n] + w[j] * val;
                if (y[ind] == -1) {
                    int n2 = j;
                    xjneg_sum[n2] = xjneg_sum[n2] + C[DenseLinear.GETI(y, ind)] * val;
                }
                ++ind;
            }
            ++j;
        }
        j = 0;
        while (j < l) {
            exp_wTx[j] = Math.exp(exp_wTx[j]);
            double tau_tmp = 1.0 / (1.0 + exp_wTx[j]);
            tau[j] = C[DenseLinear.GETI(y, j)] * tau_tmp;
            D[j] = C[DenseLinear.GETI(y, j)] * exp_wTx[j] * tau_tmp * tau_tmp;
            ++j;
        }
        while (newton_iter < 100) {
            double Gmax_new = 0.0;
            double Gnorm1_new = 0.0;
            int active_size = w_size;
            int s = 0;
            while (s < active_size) {
                block46: {
                    double violation;
                    block44: {
                        double Gn;
                        double Gp;
                        block42: {
                            block45: {
                                block43: {
                                    j = index[s];
                                    Hdiag[j] = 1.0E-12;
                                    Grad[j] = 0.0;
                                    double tmp = 0.0;
                                    int ind = 0;
                                    while (ind < prob_col.x[j].length) {
                                        int n = j;
                                        Hdiag[n] = Hdiag[n] + prob_col.x[j][ind] * prob_col.x[j][ind] * D[ind];
                                        tmp += prob_col.x[j][ind] * tau[ind];
                                        ++ind;
                                    }
                                    Grad[j] = -tmp + xjneg_sum[j];
                                    Gp = Grad[j] + 1.0;
                                    Gn = Grad[j] - 1.0;
                                    violation = 0.0;
                                    if (w[j] != 0.0) break block42;
                                    if (!(Gp < 0.0)) break block43;
                                    violation = -Gp;
                                    break block44;
                                }
                                if (!(Gn > 0.0)) break block45;
                                violation = Gn;
                                break block44;
                            }
                            if (!(Gp > Gmax_old / (double)l) || !(Gn < -Gmax_old / (double)l)) break block44;
                            DenseLinear.swap(index, s, --active_size);
                            --s;
                            break block46;
                        }
                        violation = w[j] > 0.0 ? Math.abs(Gp) : Math.abs(Gn);
                    }
                    Gmax_new = Math.max(Gmax_new, violation);
                    Gnorm1_new += violation;
                }
                ++s;
            }
            if (newton_iter == 0) {
                Gnorm1_init = Gnorm1_new;
            }
            if (Gnorm1_new <= eps * Gnorm1_init) break;
            iter = 0;
            QP_Gmax_old = Double.POSITIVE_INFINITY;
            int QP_active_size = active_size;
            int i = 0;
            while (i < l) {
                xTd[i] = 0.0;
                ++i;
            }
            while (iter < 1000) {
                double QP_Gmax_new = 0.0;
                double QP_Gnorm1_new = 0.0;
                j = 0;
                while (j < QP_active_size) {
                    i = random.nextInt(QP_active_size - j);
                    DenseLinear.swap(index, i, j);
                    ++j;
                }
                s = 0;
                while (s < QP_active_size) {
                    block51: {
                        double violation;
                        double Gn;
                        double Gp;
                        double H;
                        block49: {
                            block47: {
                                block50: {
                                    block48: {
                                        j = index[s];
                                        H = Hdiag[j];
                                        double G = Grad[j] + (wpd[j] - w[j]) * 1.0E-12;
                                        int ind = 0;
                                        while (ind < prob_col.x[j].length) {
                                            G += prob_col.x[j][ind] * D[ind] * xTd[ind];
                                            ++ind;
                                        }
                                        Gp = G + 1.0;
                                        Gn = G - 1.0;
                                        violation = 0.0;
                                        if (wpd[j] != 0.0) break block47;
                                        if (!(Gp < 0.0)) break block48;
                                        violation = -Gp;
                                        break block49;
                                    }
                                    if (!(Gn > 0.0)) break block50;
                                    violation = Gn;
                                    break block49;
                                }
                                if (!(Gp > QP_Gmax_old / (double)l) || !(Gn < -QP_Gmax_old / (double)l)) break block49;
                                DenseLinear.swap(index, s, --QP_active_size);
                                --s;
                                break block51;
                            }
                            violation = wpd[j] > 0.0 ? Math.abs(Gp) : Math.abs(Gn);
                        }
                        QP_Gmax_new = Math.max(QP_Gmax_new, violation);
                        QP_Gnorm1_new += violation;
                        double z = Gp < H * wpd[j] ? -Gp / H : (Gn > H * wpd[j] ? -Gn / H : -wpd[j]);
                        if (!(Math.abs(z) < 1.0E-12)) {
                            z = Math.min(Math.max(z, -10.0), 10.0);
                            int n = j;
                            wpd[n] = wpd[n] + z;
                            int ind = 0;
                            while (ind < prob_col.x[j].length) {
                                int n3 = ind;
                                xTd[n3] = xTd[n3] + prob_col.x[j][ind] * z;
                                ++ind;
                            }
                        }
                    }
                    ++s;
                }
                ++iter;
                if (QP_Gnorm1_new <= inner_eps * Gnorm1_init) {
                    if (QP_active_size == active_size) break;
                    QP_active_size = active_size;
                    QP_Gmax_old = Double.POSITIVE_INFINITY;
                    continue;
                }
                QP_Gmax_old = QP_Gmax_new;
            }
            if (iter >= 1000) {
                DenseLinear.info("WARNING: reaching max number of inner iterations%n");
            }
            double delta = 0.0;
            double w_norm_new = 0.0;
            j = 0;
            while (j < w_size) {
                delta += Grad[j] * (wpd[j] - w[j]);
                if (wpd[j] != 0.0) {
                    w_norm_new += Math.abs(wpd[j]);
                }
                ++j;
            }
            delta += w_norm_new - w_norm;
            double negsum_xTd = 0.0;
            i = 0;
            while (i < l) {
                if (y[i] == -1) {
                    negsum_xTd += C[DenseLinear.GETI(y, i)] * xTd[i];
                }
                ++i;
            }
            int num_linesearch = 0;
            while (num_linesearch < 20) {
                double cond = w_norm_new - w_norm + negsum_xTd - 0.01 * delta;
                int i2 = 0;
                while (i2 < l) {
                    double exp_xTd = Math.exp(xTd[i2]);
                    exp_wTx_new[i2] = exp_wTx[i2] * exp_xTd;
                    cond += C[DenseLinear.GETI(y, i2)] * Math.log((1.0 + exp_wTx_new[i2]) / (exp_xTd + exp_wTx_new[i2]));
                    ++i2;
                }
                if (cond <= 0.0) {
                    w_norm = w_norm_new;
                    j = 0;
                    while (j < w_size) {
                        w[j] = wpd[j];
                        ++j;
                    }
                    i2 = 0;
                    while (i2 < l) {
                        exp_wTx[i2] = exp_wTx_new[i2];
                        double tau_tmp = 1.0 / (1.0 + exp_wTx[i2]);
                        tau[i2] = C[DenseLinear.GETI(y, i2)] * tau_tmp;
                        D[i2] = C[DenseLinear.GETI(y, i2)] * exp_wTx[i2] * tau_tmp * tau_tmp;
                        ++i2;
                    }
                    break;
                }
                w_norm_new = 0.0;
                j = 0;
                while (j < w_size) {
                    wpd[j] = (w[j] + wpd[j]) * 0.5;
                    if (wpd[j] != 0.0) {
                        w_norm_new += Math.abs(wpd[j]);
                    }
                    ++j;
                }
                delta *= 0.5;
                negsum_xTd *= 0.5;
                i2 = 0;
                while (i2 < l) {
                    int n = i2++;
                    xTd[n] = xTd[n] * 0.5;
                }
                ++num_linesearch;
            }
            if (num_linesearch >= 20) {
                int i3 = 0;
                while (i3 < l) {
                    exp_wTx[i3] = 0.0;
                    ++i3;
                }
                i3 = 0;
                while (i3 < w_size) {
                    if (w[i3] != 0.0) {
                        int ind = 0;
                        while (ind < prob_col.x[j].length) {
                            int n = ind;
                            exp_wTx[n] = exp_wTx[n] + w[i3] * prob_col.x[i3][ind];
                            ++ind;
                        }
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < l) {
                    exp_wTx[i3] = Math.exp(exp_wTx[i3]);
                    ++i3;
                }
            }
            if (iter == 1) {
                inner_eps *= 0.25;
            }
            Gmax_old = Gmax_new;
            DenseLinear.info("iter %3d  #CD cycles %d%n", ++newton_iter, iter);
        }
        DenseLinear.info("=========================%n");
        DenseLinear.info("optimization finished, #iter = %d%n", newton_iter);
        if (newton_iter >= 100) {
            DenseLinear.info("WARNING: reaching max number of iterations%n");
        }
        double v = 0.0;
        int nnz = 0;
        j = 0;
        while (j < w_size) {
            if (w[j] != 0.0) {
                v += Math.abs(w[j]);
                ++nnz;
            }
            ++j;
        }
        j = 0;
        while (j < l) {
            v = y[j] == 1 ? (v += C[DenseLinear.GETI(y, j)] * Math.log(1.0 + 1.0 / exp_wTx[j])) : (v += C[DenseLinear.GETI(y, j)] * Math.log(1.0 + exp_wTx[j]));
            ++j;
        }
        DenseLinear.info("Objective value = %g%n", v);
        DenseLinear.info("#nonzeros/#features = %d/%d%n", nnz, w_size);
    }

    static DenseProblem transpose(DenseProblem prob) {
        int l = prob.l;
        int n = prob.n;
        DenseProblem prob_col = new DenseProblem();
        prob_col.l = l;
        prob_col.n = n;
        prob_col.y = new double[l];
        prob_col.x = new double[n][];
        int i = 0;
        while (i < l) {
            prob_col.y[i] = prob.y[i];
            ++i;
        }
        i = 0;
        while (i < n) {
            prob_col.x[i] = new double[l];
            ++i;
        }
        i = 0;
        while (i < l) {
            int j = 0;
            while (j < n) {
                prob_col.x[j][i] = prob.x[i][j];
                ++j;
            }
            ++i;
        }
        return prob_col;
    }

    static void swap(double[] array, int idxA, int idxB) {
        double temp = array[idxA];
        array[idxA] = array[idxB];
        array[idxB] = temp;
    }

    static void swap(int[] array, int idxA, int idxB) {
        int temp = array[idxA];
        array[idxA] = array[idxB];
        array[idxB] = temp;
    }

    static void swap(IntArrayPointer array, int idxA, int idxB) {
        int temp = array.get(idxA);
        array.set(idxA, array.get(idxB));
        array.set(idxB, temp);
    }

    public static Model train(DenseProblem prob, Parameter param) {
        if (prob == null) {
            throw new IllegalArgumentException("problem must not be null");
        }
        if (param == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        if (prob.n == 0) {
            throw new IllegalArgumentException("problem has zero features");
        }
        if (prob.l == 0) {
            throw new IllegalArgumentException("problem has zero instances");
        }
        int l = prob.l;
        int n = prob.n;
        int w_size = prob.n;
        Model model = new Model();
        model.nr_feature = prob.bias >= 0.0 ? n - 1 : n;
        model.solverType = param.solverType;
        model.bias = prob.bias;
        if (param.solverType == SolverType.L2R_L2LOSS_SVR || param.solverType == SolverType.L2R_L1LOSS_SVR_DUAL || param.solverType == SolverType.L2R_L2LOSS_SVR_DUAL) {
            model.w = new double[w_size];
            model.nr_class = 2;
            model.label = null;
            DenseLinear.checkProblemSize(n, model.nr_class);
            DenseLinear.train_one(prob, param, model.w, 0.0, 0.0);
        } else {
            int[] perm = new int[l];
            GroupClassesReturn rv = DenseLinear.groupClasses(prob, perm);
            int nr_class = rv.nr_class;
            int[] label = rv.label;
            int[] start = rv.start;
            int[] count = rv.count;
            DenseLinear.checkProblemSize(n, nr_class);
            model.nr_class = nr_class;
            model.label = new int[nr_class];
            int i = 0;
            while (i < nr_class) {
                model.label[i] = label[i];
                ++i;
            }
            double[] weighted_C = new double[nr_class];
            int i2 = 0;
            while (i2 < nr_class) {
                weighted_C[i2] = param.C;
                ++i2;
            }
            i2 = 0;
            while (i2 < param.getNumWeights()) {
                int j = 0;
                while (j < nr_class) {
                    if (param.weightLabel[i2] == label[j]) break;
                    ++j;
                }
                if (j == nr_class) {
                    throw new IllegalArgumentException("class label " + param.weightLabel[i2] + " specified in weight is not found");
                }
                int n2 = j;
                weighted_C[n2] = weighted_C[n2] * param.weight[i2];
                ++i2;
            }
            double[][] x = new double[l][];
            int i3 = 0;
            while (i3 < l) {
                x[i3] = prob.x[perm[i3]];
                ++i3;
            }
            DenseProblem sub_prob = new DenseProblem();
            sub_prob.l = l;
            sub_prob.n = n;
            sub_prob.x = new double[sub_prob.l][];
            sub_prob.y = new double[sub_prob.l];
            int k = 0;
            while (k < sub_prob.l) {
                sub_prob.x[k] = x[k];
                ++k;
            }
            if (param.solverType == SolverType.MCSVM_CS) {
                model.w = new double[n * nr_class];
                int i4 = 0;
                while (i4 < nr_class) {
                    int j = start[i4];
                    while (j < start[i4] + count[i4]) {
                        sub_prob.y[j] = i4;
                        ++j;
                    }
                    ++i4;
                }
                DenseSolverMCSVM_CS solver = new DenseSolverMCSVM_CS(sub_prob, nr_class, weighted_C, param.eps);
                solver.solve(model.w);
            } else if (nr_class == 2) {
                model.w = new double[w_size];
                int e0 = start[0] + count[0];
                int k2 = 0;
                while (k2 < e0) {
                    sub_prob.y[k2] = 1.0;
                    ++k2;
                }
                while (k2 < sub_prob.l) {
                    sub_prob.y[k2] = -1.0;
                    ++k2;
                }
                DenseLinear.train_one(sub_prob, param, model.w, weighted_C[0], weighted_C[1]);
            } else {
                model.w = new double[w_size * nr_class];
                double[] w = new double[w_size];
                int i5 = 0;
                while (i5 < nr_class) {
                    int si = start[i5];
                    int ei = si + count[i5];
                    int k3 = 0;
                    while (k3 < si) {
                        sub_prob.y[k3] = -1.0;
                        ++k3;
                    }
                    while (k3 < ei) {
                        sub_prob.y[k3] = 1.0;
                        ++k3;
                    }
                    while (k3 < sub_prob.l) {
                        sub_prob.y[k3] = -1.0;
                        ++k3;
                    }
                    DenseLinear.train_one(sub_prob, param, w, weighted_C[i5], param.C);
                    int j = 0;
                    while (j < n) {
                        model.w[j * nr_class + i5] = w[j];
                        ++j;
                    }
                    ++i5;
                }
            }
        }
        return model;
    }

    private static void checkProblemSize(int n, int nr_class) {
        if (n >= Integer.MAX_VALUE / nr_class || n * nr_class < 0) {
            throw new IllegalArgumentException("'number of classes' * 'number of instances' is too large: " + nr_class + "*" + n);
        }
    }

    private static void train_one(DenseProblem prob, Parameter param, double[] w, double Cp, double Cn) {
        double eps = param.eps;
        int pos = 0;
        int i = 0;
        while (i < prob.l) {
            if (prob.y[i] > 0.0) {
                ++pos;
            }
            ++i;
        }
        int neg = prob.l - pos;
        double primal_solver_tol = eps * (double)Math.max(Math.min(pos, neg), 1) / (double)prob.l;
        Function fun_obj = null;
        switch (param.solverType) {
            case L2R_LR: {
                double[] C = new double[prob.l];
                int i2 = 0;
                while (i2 < prob.l) {
                    C[i2] = prob.y[i2] > 0.0 ? Cp : Cn;
                    ++i2;
                }
                fun_obj = new DenseL2R_LrFunction(prob, C);
                Tron tron_obj = new Tron(fun_obj, primal_solver_tol);
                tron_obj.tron(w);
                break;
            }
            case L2R_L2LOSS_SVC: {
                double[] C = new double[prob.l];
                int i3 = 0;
                while (i3 < prob.l) {
                    C[i3] = prob.y[i3] > 0.0 ? Cp : Cn;
                    ++i3;
                }
                fun_obj = new DenseL2R_L2_SvcFunction(prob, C);
                Tron tron_obj = new Tron(fun_obj, primal_solver_tol);
                tron_obj.tron(w);
                break;
            }
            case L2R_L2LOSS_SVC_DUAL: {
                DenseLinear.solve_l2r_l1l2_svc(prob, w, eps, Cp, Cn, SolverType.L2R_L2LOSS_SVC_DUAL);
                break;
            }
            case L2R_L1LOSS_SVC_DUAL: {
                DenseLinear.solve_l2r_l1l2_svc(prob, w, eps, Cp, Cn, SolverType.L2R_L1LOSS_SVC_DUAL);
                break;
            }
            case L1R_L2LOSS_SVC: {
                DenseProblem prob_col = DenseLinear.transpose(prob);
                DenseLinear.solve_l1r_l2_svc(prob_col, w, primal_solver_tol, Cp, Cn);
                break;
            }
            case L1R_LR: {
                DenseProblem prob_col = DenseLinear.transpose(prob);
                DenseLinear.solve_l1r_lr(prob_col, w, primal_solver_tol, Cp, Cn);
                break;
            }
            case L2R_LR_DUAL: {
                DenseLinear.solve_l2r_lr_dual(prob, w, eps, Cp, Cn);
                break;
            }
            case L2R_L2LOSS_SVR: {
                double[] C = new double[prob.l];
                int i4 = 0;
                while (i4 < prob.l) {
                    C[i4] = param.C;
                    ++i4;
                }
                fun_obj = new DenseL2R_L2_SvrFunction(prob, C, param.p);
                Tron tron_obj = new Tron(fun_obj, param.eps);
                tron_obj.tron(w);
                break;
            }
            case L2R_L2LOSS_SVR_DUAL: 
            case L2R_L1LOSS_SVR_DUAL: {
                DenseLinear.solve_l2r_l1l2_svr(prob, w, param);
                break;
            }
            default: {
                throw new IllegalStateException("unknown solver type: " + (Object)((Object)param.solverType));
            }
        }
    }

    public static void disableDebugOutput() {
        DenseLinear.setDebugOutput(null);
    }

    public static void enableDebugOutput() {
        DenseLinear.setDebugOutput(System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDebugOutput(PrintStream debugOutput) {
        Object object = OUTPUT_MUTEX;
        synchronized (object) {
            DEBUG_OUTPUT = debugOutput;
        }
    }

    public static void resetRandom() {
        random = new Random(0L);
    }

    private static class GroupClassesReturn {
        final int[] count;
        final int[] label;
        final int nr_class;
        final int[] start;

        GroupClassesReturn(int nr_class, int[] label, int[] start, int[] count) {
            this.nr_class = nr_class;
            this.label = label;
            this.start = start;
            this.count = count;
        }
    }
}

