/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.DenseL2R_L2_SvcFunction;
import de.bwaldvogel.liblinear.DenseProblem;

public class DenseL2R_L2_SvrFunction
extends DenseL2R_L2_SvcFunction {
    private double p;

    public DenseL2R_L2_SvrFunction(DenseProblem prob, double[] C, double p) {
        super(prob, C);
        this.p = p;
    }

    @Override
    public double fun(double[] w) {
        double f = 0.0;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.Xv(w, this.z);
        int i = 0;
        while (i < w_size) {
            f += w[i] * w[i];
            ++i;
        }
        f /= 2.0;
        i = 0;
        while (i < l) {
            double d = this.z[i] - y[i];
            if (d < -this.p) {
                f += this.C[i] * (d + this.p) * (d + this.p);
            } else if (d > this.p) {
                f += this.C[i] * (d - this.p) * (d - this.p);
            }
            ++i;
        }
        return f;
    }

    @Override
    public void grad(double[] w, double[] g) {
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.sizeI = 0;
        int i = 0;
        while (i < l) {
            double d = this.z[i] - y[i];
            if (d < -this.p) {
                this.z[this.sizeI] = this.C[i] * (d + this.p);
                this.I[this.sizeI] = i;
                ++this.sizeI;
            } else if (d > this.p) {
                this.z[this.sizeI] = this.C[i] * (d - this.p);
                this.I[this.sizeI] = i;
                ++this.sizeI;
            }
            ++i;
        }
        this.subXTv(this.z, g);
        i = 0;
        while (i < w_size) {
            g[i] = w[i] + 2.0 * g[i];
            ++i;
        }
    }
}

