/*
 * Decompiled with CFR 0.152.
 */
package org.lemurproject.ireval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class RetrievalEvaluator {
    private String _queryName;
    private ArrayList<Document> _retrieved;
    private ArrayList<Document> _judgedMissed;
    private ArrayList<Document> _relevant;
    private ArrayList<Document> _relevantRetrieved;
    private ArrayList<Document> _judgedIrrelevantRetrieved;
    private ArrayList<Document> _irrelevantRetrieved;
    private ArrayList<Document> _relevantMissed;
    private HashMap<String, Judgment> _judgments;
    private int _numIrrelevant;
    private static int[] fixedPoints = new int[]{5, 10, 15, 20, 30, 100, 200, 500, 1000};
    private double[] _pFP = null;
    private double[] _ip = null;

    public RetrievalEvaluator(String queryName, List<Document> retrieved, Collection<Judgment> judgments) {
        this._queryName = queryName;
        this._retrieved = new ArrayList<Document>(retrieved);
        this._buildJudgments(judgments);
        this._judgeRetrievedDocuments();
        this._findMissedDocuments();
        this._findRelevantDocuments();
    }

    private void _buildJudgments(Collection<Judgment> judgments) {
        this._judgments = new HashMap();
        this._numIrrelevant = 0;
        for (Judgment judgment : judgments) {
            this._judgments.put(judgment.documentNumber, judgment);
            if (judgment.judgment > 0) continue;
            ++this._numIrrelevant;
        }
    }

    private void _judgeRetrievedDocuments() {
        this._irrelevantRetrieved = new ArrayList();
        this._relevantRetrieved = new ArrayList();
        this._judgedIrrelevantRetrieved = new ArrayList();
        for (Document document : this._retrieved) {
            boolean relevant = false;
            boolean judgedIrrelevant = false;
            Judgment judgment = this._judgments.get(document.documentNumber);
            relevant = judgment != null && judgment.judgment > 0;
            boolean bl = judgedIrrelevant = judgment != null && judgment.judgment <= 0;
            if (relevant) {
                this._relevantRetrieved.add(document);
                continue;
            }
            this._irrelevantRetrieved.add(document);
            if (!judgedIrrelevant) continue;
            this._judgedIrrelevantRetrieved.add(document);
        }
    }

    private void _findMissedDocuments() {
        HashMap<String, Judgment> missedDocuments = new HashMap<String, Judgment>(this._judgments);
        for (Document document : this._relevantRetrieved) {
            missedDocuments.remove(document.documentNumber);
        }
        for (Document document : this._judgedIrrelevantRetrieved) {
            missedDocuments.remove(document.documentNumber);
        }
        this._judgedMissed = new ArrayList();
        this._relevantMissed = new ArrayList();
        for (Judgment judgment : missedDocuments.values()) {
            Document document = new Document(judgment.documentNumber);
            this._judgedMissed.add(document);
            if (judgment.judgment <= 0) continue;
            this._relevantMissed.add(document);
        }
    }

    private void _findRelevantDocuments() {
        this._relevant = new ArrayList();
        this._relevant.addAll(this._relevantRetrieved);
        this._relevant.addAll(this._relevantMissed);
    }

    public String queryName() {
        return this._queryName;
    }

    public static int[] getFixedPoints() {
        return fixedPoints;
    }

    public double[] precisionAtFixedPoints() {
        if (this._pFP == null) {
            this._pFP = new double[fixedPoints.length];
            int i = 0;
            for (int point : fixedPoints) {
                this._pFP[i++] = this.precision(point);
            }
        }
        return this._pFP;
    }

    public double[] interpolatedPrecision() {
        if (this._ip == null) {
            int size = this._relevant.size();
            this._ip = new double[11];
            int[] cuts = new int[11];
            cuts[0] = 0;
            for (int i = 1; i < 11; ++i) {
                cuts[i] = (size * i + 9) / 10;
                this._ip[i] = 0.0;
            }
            int current_cut = 10;
            int relRet = this._relevantRetrieved.size();
            while (cuts[current_cut] > relRet) {
                --current_cut;
            }
            double prec = 0.0;
            for (int i = relRet - 1; i >= 0; --i) {
                int rank = this._relevantRetrieved.get((int)i).rank;
                double newprec = this.precision(rank);
                prec = Math.max(prec, newprec);
                while (current_cut >= 0 && cuts[current_cut] == i + 1) {
                    this._ip[current_cut--] = prec;
                }
            }
            this._ip[0] = prec;
        }
        return this._ip;
    }

    public double precision(int documentsRetrieved) {
        if (documentsRetrieved == 0) {
            return 0.0;
        }
        return (double)this.relevantRetrieved(documentsRetrieved) / (double)documentsRetrieved;
    }

    public double recall(int documentsRetrieved) {
        if (this._relevant.size() == 0) {
            return 0.0;
        }
        return (double)this.relevantRetrieved(documentsRetrieved) / (double)this._relevant.size();
    }

    public double rPrecision() {
        int relevantCount = this._relevant.size();
        int retrievedCount = this._retrieved.size();
        return this.precision(relevantCount);
    }

    public double reciprocalRank() {
        if (this._relevantRetrieved.size() == 0) {
            return 0.0;
        }
        return 1.0 / (double)this._relevantRetrieved.get((int)0).rank;
    }

    public double averagePrecision() {
        double sumPrecision = 0.0;
        int relevantCount = 0;
        for (Document document : this._relevantRetrieved) {
            sumPrecision += (double)(++relevantCount) / (double)document.rank;
        }
        if (this._relevant.size() > 0) {
            return sumPrecision / (double)this._relevant.size();
        }
        return 0.0;
    }

    public double binaryPreference() {
        int totalRelevant = this._relevant.size();
        if (totalRelevant == 0) {
            return 0.0;
        }
        int i = 0;
        int j = 0;
        int irrelevantCount = Math.min(totalRelevant, this._numIrrelevant);
        List<Document> irrelevant = this._judgedIrrelevantRetrieved.subList(0, Math.min(totalRelevant, this._judgedIrrelevantRetrieved.size()));
        double sum = 0.0;
        if (irrelevant.size() == 0) {
            sum = this._relevantRetrieved.size();
        }
        while (i < this._relevantRetrieved.size() && j < irrelevant.size()) {
            Document rel = this._relevantRetrieved.get(i);
            Document irr = irrelevant.get(j);
            if (rel.rank < irr.rank) {
                assert (j <= totalRelevant);
                sum += 1.0 - (double)j / (double)irrelevantCount;
                ++i;
                continue;
            }
            ++j;
        }
        return sum / (double)totalRelevant;
    }

    public double normalizedDiscountedCumulativeGain() {
        return this.normalizedDiscountedCumulativeGain(Math.max(this._retrieved.size(), this._judgments.size()));
    }

    public double normalizedDiscountedCumulativeGain(int documentsRetrieved) {
        double normalizer = this.normalizationTermNDCG(documentsRetrieved);
        if (normalizer == 0.0) {
            return 0.0;
        }
        double dcg = 0.0;
        List<Document> truncated = this._retrieved;
        if (this._retrieved.size() > documentsRetrieved) {
            truncated = this._retrieved.subList(0, documentsRetrieved);
        }
        for (Document document : truncated) {
            Judgment judgment = this._judgments.get(document.documentNumber);
            if (judgment == null || judgment.judgment <= 0) continue;
            dcg += (Math.pow(2.0, judgment.judgment) - 1.0) / Math.log(1 + document.rank);
        }
        return dcg / normalizer;
    }

    protected double normalizationTermNDCG(int documentsRetrieved) {
        TreeMap<Integer, Integer> relevanceCounts = new TreeMap<Integer, Integer>();
        for (Judgment judgment : this._judgments.values()) {
            if (judgment.judgment == 0) continue;
            if (!relevanceCounts.containsKey(-judgment.judgment)) {
                relevanceCounts.put(-judgment.judgment, 0);
            }
            relevanceCounts.put(-judgment.judgment, (Integer)relevanceCounts.get(-judgment.judgment) + 1);
        }
        double normalizer = 0.0;
        int documentsProcessed = 0;
        for (Integer negativeRelevanceValue : relevanceCounts.keySet()) {
            int relevanceCount = (Integer)relevanceCounts.get(negativeRelevanceValue);
            int relevanceValue = -negativeRelevanceValue.intValue();
            relevanceCount = Math.min(relevanceCount, documentsRetrieved - documentsProcessed);
            for (int i = 1; i <= relevanceCount; ++i) {
                normalizer += (Math.pow(2.0, relevanceValue) - 1.0) / Math.log(1 + i + documentsProcessed);
            }
            if ((documentsProcessed += relevanceCount) < documentsRetrieved) continue;
            break;
        }
        return normalizer;
    }

    public int relevantRetrieved(int documentsRetrieved) {
        int low = 0;
        int high = this._relevantRetrieved.size() - 1;
        if (this._relevantRetrieved.size() == 0) {
            return 0;
        }
        Document lastRelevant = this._relevantRetrieved.get(high);
        if (lastRelevant.rank <= documentsRetrieved) {
            return this._relevantRetrieved.size();
        }
        Document firstRelevant = this._relevantRetrieved.get(low);
        if (firstRelevant.rank > documentsRetrieved) {
            return 0;
        }
        while (high - low >= 2) {
            int middle = low + (high - low) / 2;
            Document middleDocument = this._relevantRetrieved.get(middle);
            if (middleDocument.rank == documentsRetrieved) {
                return middle + 1;
            }
            if (middleDocument.rank > documentsRetrieved) {
                high = middle;
                continue;
            }
            low = middle;
        }
        assert (this._relevantRetrieved.get((int)low).rank <= documentsRetrieved && this._relevantRetrieved.get((int)high).rank > documentsRetrieved);
        return low + 1;
    }

    public ArrayList<Document> retrievedDocuments() {
        return this._retrieved;
    }

    public ArrayList<Document> judgedIrrelevantRetrievedDocuments() {
        return this._judgedIrrelevantRetrieved;
    }

    public ArrayList<Document> irrelevantRetrievedDocuments() {
        return this._irrelevantRetrieved;
    }

    public ArrayList<Document> relevantRetrievedDocuments() {
        return this._relevantRetrieved;
    }

    public ArrayList<Document> relevantDocuments() {
        return this._relevant;
    }

    public ArrayList<Document> relevantMissedDocuments() {
        return this._relevantMissed;
    }

    public static class Judgment {
        public String documentNumber;
        public int judgment;

        public Judgment(String documentNumber, int judgment) {
            this.documentNumber = documentNumber;
            this.judgment = judgment;
        }
    }

    public static class Document {
        public int rank;
        public String documentNumber;
        public double score;

        public Document(String documentNumber, int rank, double score) {
            this.documentNumber = documentNumber;
            this.rank = rank;
            this.score = score;
        }

        public Document(String documentNumber) {
            this.documentNumber = documentNumber;
            this.rank = Integer.MAX_VALUE;
            this.score = Double.NEGATIVE_INFINITY;
        }
    }
}

