/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.ByteArrayUtil;
import ch.qos.logback.core.encoder.NonClosableInputStream;
import ch.qos.logback.core.encoder.ObjectStreamEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventObjectInputStream<E>
extends InputStream {
    NonClosableInputStream ncis;
    List<E> buffer = new ArrayList();
    int index = 0;

    EventObjectInputStream(InputStream is) throws IOException {
        this.ncis = new NonClosableInputStream(is);
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Only the readEvent method is supported.");
    }

    @Override
    public int available() throws IOException {
        return this.ncis.available();
    }

    public E readEvent() throws IOException {
        E event = this.getFromBuffer();
        if (event != null) {
            return event;
        }
        this.internalReset();
        int count = this.readHeader();
        if (count == -1) {
            return null;
        }
        this.readPayload(count);
        this.readFooter(count);
        return this.getFromBuffer();
    }

    private void internalReset() {
        this.index = 0;
        this.buffer.clear();
    }

    E getFromBuffer() {
        if (this.index >= this.buffer.size()) {
            return null;
        }
        return this.buffer.get(this.index++);
    }

    int readHeader() throws IOException {
        byte[] headerBA = new byte[4 * CoreConstants.BYTES_PER_INT];
        int bytesRead = this.ncis.read(headerBA);
        if (bytesRead == -1) {
            return -1;
        }
        int offset = 0;
        int startPebble = ByteArrayUtil.readInt(headerBA, offset);
        if (startPebble != ObjectStreamEncoder.START_PEBBLE) {
            throw new IllegalStateException("Does not look like data created by ObjectStreamEncoder");
        }
        int count = ByteArrayUtil.readInt(headerBA, offset += CoreConstants.BYTES_PER_INT);
        int endPointer = ByteArrayUtil.readInt(headerBA, offset += CoreConstants.BYTES_PER_INT);
        int checksum = ByteArrayUtil.readInt(headerBA, offset += CoreConstants.BYTES_PER_INT);
        if (checksum != (ObjectStreamEncoder.START_PEBBLE ^ count)) {
            throw new IllegalStateException("Invalid checksum");
        }
        return count;
    }

    E readEvents(ObjectInputStream ois) throws IOException {
        Object e = null;
        try {
            e = ois.readObject();
            this.buffer.add(e);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return (E)e;
    }

    void readFooter(int count) throws IOException {
        byte[] headerBA = new byte[2 * CoreConstants.BYTES_PER_INT];
        this.ncis.read(headerBA);
        int offset = 0;
        int stopPebble = ByteArrayUtil.readInt(headerBA, offset);
        if (stopPebble != ObjectStreamEncoder.STOP_PEBBLE) {
            throw new IllegalStateException("Looks like a corrupt stream");
        }
        int checksum = ByteArrayUtil.readInt(headerBA, offset += CoreConstants.BYTES_PER_INT);
        if (checksum != (ObjectStreamEncoder.STOP_PEBBLE ^ count)) {
            throw new IllegalStateException("Invalid checksum");
        }
    }

    void readPayload(int count) throws IOException {
        ArrayList<E> eventList = new ArrayList<E>(count);
        ObjectInputStream ois = new ObjectInputStream(this.ncis);
        for (int i = 0; i < count; ++i) {
            E e = this.readEvents(ois);
            eventList.add(e);
        }
        ois.close();
    }

    @Override
    public void close() throws IOException {
        this.ncis.realClose();
    }
}

