/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.video.tracking.klt.Feature;
import org.openimaj.video.tracking.klt.IOUtils;

public class FeatureList
implements Iterable<Feature> {
    public Feature[] features;

    public FeatureList(int nFeatures) {
        this.features = new Feature[nFeatures];
        for (int i = 0; i < nFeatures; ++i) {
            this.features[i] = new Feature();
        }
    }

    public int countRemainingFeatures() {
        int count = 0;
        for (Feature f : this.features) {
            if (f.val < 0) continue;
            ++count;
        }
        return count;
    }

    public FeatureList clone() {
        FeatureList ret = new FeatureList(this.features.length);
        for (int i = 0; i < this.features.length; ++i) {
            ret.features[i] = this.features[i].clone();
        }
        return ret;
    }

    public MBFImage drawFeatures(FImage img) {
        FImage redimg = img.clone();
        FImage grnimg = img.clone();
        FImage bluimg = img.clone();
        for (int i = 0; i < this.features.length; ++i) {
            if (this.features[i].val < 0) continue;
            int x = (int)((double)this.features[i].x + 0.5);
            int y = (int)((double)this.features[i].y + 0.5);
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (xx < 0 || yy < 0 || xx >= img.width || yy >= img.height) continue;
                    redimg.pixels[yy][xx] = 1.0f;
                    grnimg.pixels[yy][xx] = 0.0f;
                    bluimg.pixels[yy][xx] = 0.0f;
                }
            }
        }
        return new MBFImage(new FImage[]{redimg, grnimg, bluimg});
    }

    public MBFImage drawFeatures(MBFImage img) {
        MBFImage out = img;
        for (int i = 0; i < this.features.length; ++i) {
            if (this.features[i].val < 0) continue;
            int x = (int)((double)this.features[i].x + 0.5);
            int y = (int)((double)this.features[i].y + 0.5);
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (xx < 0 || yy < 0 || xx >= img.getWidth() || yy >= img.getHeight()) continue;
                    ((FImage)out.bands.get(0)).setPixel(xx, yy, Float.valueOf(1.0f));
                }
            }
        }
        return out;
    }

    public void writeFeatureList(File fname, String fmt) throws IOException {
        if (fmt != null) {
            if (fname != null) {
                PrintWriter bw = new PrintWriter(new FileOutputStream(fname));
                bw.write(this.toString(fmt, true));
                bw.close();
            } else {
                System.out.print(this.toString(fmt, false));
            }
        } else {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(fname));
            dos.write(IOUtils.binheader_fl.getBytes("US-ASCII"));
            dos.writeInt(this.features.length);
            for (Feature f : this.features) {
                f.writeFeatureBin(dos);
            }
            dos.close();
        }
    }

    public String toString(String fmt, boolean comments) {
        String[] setup = IOUtils.setupTxtFormat(fmt);
        String format = setup[0];
        String type = setup[1];
        String s = IOUtils.getHeader(format, IOUtils.StructureType.FEATURE_LIST, 0, this.features.length, comments);
        for (int i = 0; i < this.features.length; ++i) {
            s = s + String.format("%7d | ", i);
            s = s + this.features[i].toString(format, type);
            s = s + String.format("\n", new Object[0]);
        }
        return s;
    }

    public String toString() {
        return this.toString("%3d", false);
    }

    @Override
    public Iterator<Feature> iterator() {
        Iterator<Feature> iterator = new Iterator<Feature>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                for (int newindex = this.index; newindex < FeatureList.this.features.length; ++newindex) {
                    if (FeatureList.this.features[newindex].val < 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Feature next() {
                int newindex;
                for (newindex = this.index; newindex < FeatureList.this.features.length && FeatureList.this.features[newindex].val < 0; ++newindex) {
                }
                Feature f = FeatureList.this.features[newindex];
                ++this.index;
                return f;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        };
        return iterator;
    }

    public Rectangle getBounds() {
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (Feature f : this.features) {
            if (f.val < 0) continue;
            minX = Math.min(minX, f.x);
            maxX = Math.max(maxX, f.x);
            minY = Math.min(minY, f.y);
            maxY = Math.max(maxY, f.y);
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

