/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Add;
import org.openrdf.query.algebra.Clear;
import org.openrdf.query.algebra.Copy;
import org.openrdf.query.algebra.Create;
import org.openrdf.query.algebra.DeleteData;
import org.openrdf.query.algebra.InsertData;
import org.openrdf.query.algebra.Load;
import org.openrdf.query.algebra.Modify;
import org.openrdf.query.algebra.Move;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SailUpdateExecutor {
    private final Logger logger = LoggerFactory.getLogger(SailUpdateExecutor.class);
    private final SailConnection con;
    private final ValueFactory vf;
    private final boolean readSnapshot;

    @Deprecated
    public SailUpdateExecutor(Sail sail, SailConnection con) {
        this(con, sail.getValueFactory(), false);
    }

    public SailUpdateExecutor(SailConnection con, ValueFactory vf, boolean readSnapshot) {
        this.con = con;
        this.vf = vf;
        this.readSnapshot = readSnapshot;
    }

    public void executeUpdate(UpdateExpr updateExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming update expression:\n{}", (Object)updateExpr);
        if (updateExpr instanceof Modify) {
            this.executeModify((Modify)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof InsertData) {
            this.executeInsertData((InsertData)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof DeleteData) {
            this.executeDeleteData((DeleteData)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Clear) {
            this.executeClear((Clear)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Create) {
            this.executeCreate((Create)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Copy) {
            this.executeCopy((Copy)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Add) {
            this.executeAdd((Add)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Move) {
            this.executeMove((Move)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Load) {
            throw new SailException("load operations can not be handled directly by the SAIL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCreate(Create create, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Value graphValue = create.getGraph().getValue();
        if (graphValue instanceof Resource) {
            Resource namedGraph = (Resource)graphValue;
            CloseableIteration<? extends Resource, SailException> contextIDs = this.con.getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    Resource contextID = (Resource)contextIDs.next();
                    if (!namedGraph.equals(contextID)) continue;
                    throw new SailException("Named graph " + namedGraph + " already exists. ");
                }
            }
            finally {
                contextIDs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCopy(Copy copy, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = copy.getSourceGraph();
        ValueConstant destinationGraph = copy.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.con.clear(destination);
        CloseableIteration<? extends Statement, SailException> statements = this.con.getStatements(null, null, null, includeInferred, source);
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), destination);
            }
        }
        finally {
            statements.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAdd(Add add, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = add.getSourceGraph();
        ValueConstant destinationGraph = add.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        CloseableIteration<? extends Statement, SailException> statements = this.con.getStatements(null, null, null, includeInferred, source);
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), destination);
            }
        }
        finally {
            statements.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMove(Move move, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = move.getSourceGraph();
        ValueConstant destinationGraph = move.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.con.clear(destination);
        CloseableIteration<? extends Statement, SailException> statements = this.con.getStatements(null, null, null, includeInferred, source);
        try {
            while (statements.hasNext()) {
                Statement st = (Statement)statements.next();
                this.con.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), destination);
                this.con.removeStatements(st.getSubject(), st.getPredicate(), st.getObject(), source);
            }
        }
        finally {
            statements.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeClear(Clear clearExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        block10: {
            try {
                ValueConstant graph = clearExpr.getGraph();
                if (graph != null) {
                    Resource context = (Resource)graph.getValue();
                    this.con.clear(context);
                    break block10;
                }
                StatementPattern.Scope scope = clearExpr.getScope();
                if (StatementPattern.Scope.NAMED_CONTEXTS.equals((Object)scope)) {
                    CloseableIteration<? extends Resource, SailException> contextIDs = this.con.getContextIDs();
                    try {
                        while (contextIDs.hasNext()) {
                            this.con.clear((Resource)contextIDs.next());
                        }
                        break block10;
                    }
                    finally {
                        contextIDs.close();
                    }
                }
                if (StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)scope)) {
                    this.con.clear(new Resource[]{null});
                } else {
                    this.con.clear(new Resource[0]);
                }
            }
            catch (SailException e) {
                if (clearExpr.isSilent()) break block10;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInsertData(InsertData insertDataExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        TupleExpr insertExpr = insertDataExpr.getInsertExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> toBeInserted = this.con.evaluate(insertExpr, dataset, bindings, includeInferred);
        try {
            try {
                while (toBeInserted.hasNext()) {
                    BindingSet bs = (BindingSet)toBeInserted.next();
                    Resource subject = (Resource)bs.getValue("subject");
                    URI predicate = (URI)bs.getValue("predicate");
                    Value object = bs.getValue("object");
                    Resource context = (Resource)bs.getValue("context");
                    if (context == null) {
                        this.con.addStatement(subject, predicate, object, new Resource[0]);
                        continue;
                    }
                    this.con.addStatement(subject, predicate, object, context);
                }
            }
            finally {
                toBeInserted.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDeleteData(DeleteData deleteDataExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        TupleExpr deleteExpr = deleteDataExpr.getDeleteExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> toBeDeleted = this.con.evaluate(deleteExpr, dataset, bindings, includeInferred);
        try {
            try {
                while (toBeDeleted.hasNext()) {
                    BindingSet bs = (BindingSet)toBeDeleted.next();
                    Resource subject = (Resource)bs.getValue("subject");
                    URI predicate = (URI)bs.getValue("predicate");
                    Value object = bs.getValue("object");
                    Resource context = (Resource)bs.getValue("context");
                    if (context == null) {
                        this.con.removeStatements(subject, predicate, object, new Resource[0]);
                        continue;
                    }
                    this.con.removeStatements(subject, predicate, object, context);
                }
            }
            finally {
                toBeDeleted.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeModify(Modify modify, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            TupleExpr whereClause = modify.getWhereExpr();
            CloseableIteration<? extends BindingSet, QueryEvaluationException> sourceBindings = this.evaluateWhereClause(whereClause, dataset, bindings, includeInferred);
            try {
                if (this.readSnapshot) {
                    while (sourceBindings.hasNext()) {
                        BindingSet sourceBinding = (BindingSet)sourceBindings.next();
                        this.deleteBoundTriples(sourceBinding, modify.getDeleteExpr());
                        this.insertBoundTriples(sourceBinding, modify.getInsertExpr());
                    }
                } else {
                    ArrayList cachedSourceBindings = new ArrayList();
                    while (sourceBindings.hasNext()) {
                        cachedSourceBindings.add(sourceBindings.next());
                    }
                    for (BindingSet sourceBinding : cachedSourceBindings) {
                        this.deleteBoundTriples(sourceBinding, modify.getDeleteExpr());
                        this.insertBoundTriples(sourceBinding, modify.getInsertExpr());
                    }
                }
            }
            finally {
                sourceBindings.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateWhereClause(final TupleExpr whereClause, Dataset dataset, final BindingSet bindings, boolean includeInferred) throws SailException, QueryEvaluationException {
        CloseableIteration<? extends BindingSet, QueryEvaluationException> sourceBindings = this.con.evaluate(whereClause, dataset, bindings, includeInferred);
        return new ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException>(sourceBindings){

            @Override
            protected BindingSet convert(BindingSet sourceBinding) throws QueryEvaluationException {
                if (whereClause instanceof SingletonSet && sourceBinding instanceof EmptyBindingSet && bindings != null) {
                    return bindings;
                }
                HashSet<String> uniqueBindings = new HashSet<String>(bindings.getBindingNames());
                uniqueBindings.removeAll(sourceBinding.getBindingNames());
                if (uniqueBindings.size() > 0) {
                    MapBindingSet mergedSet = new MapBindingSet();
                    for (String bindingName : sourceBinding.getBindingNames()) {
                        mergedSet.addBinding(sourceBinding.getBinding(bindingName));
                    }
                    for (String bindingName : uniqueBindings) {
                        mergedSet.addBinding(bindings.getBinding(bindingName));
                    }
                    return mergedSet;
                }
                return sourceBinding;
            }
        };
    }

    private void deleteBoundTriples(BindingSet whereBinding, TupleExpr deleteClause) throws SailException {
        if (deleteClause != null) {
            List<StatementPattern> deletePatterns = StatementPatternCollector.process(deleteClause);
            for (StatementPattern deletePattern : deletePatterns) {
                Resource subject = (Resource)this.getValueForVar(deletePattern.getSubjectVar(), whereBinding);
                URI predicate = (URI)this.getValueForVar(deletePattern.getPredicateVar(), whereBinding);
                Value object = this.getValueForVar(deletePattern.getObjectVar(), whereBinding);
                Resource context = null;
                if (deletePattern.getContextVar() != null) {
                    context = (Resource)this.getValueForVar(deletePattern.getContextVar(), whereBinding);
                }
                if (context == null) {
                    this.con.removeStatements(subject, predicate, object, new Resource[0]);
                    continue;
                }
                this.con.removeStatements(subject, predicate, object, context);
            }
        }
    }

    private void insertBoundTriples(BindingSet whereBinding, TupleExpr insertClause) throws SailException {
        if (insertClause != null) {
            List<StatementPattern> insertPatterns = StatementPatternCollector.process(insertClause);
            MapBindingSet bnodeMapping = new MapBindingSet();
            for (StatementPattern insertPattern : insertPatterns) {
                Statement toBeInserted = this.createStatementFromPattern(insertPattern, whereBinding, bnodeMapping);
                if (toBeInserted == null) continue;
                if (toBeInserted.getContext() == null) {
                    this.con.addStatement(toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), new Resource[0]);
                    continue;
                }
                this.con.addStatement(toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), toBeInserted.getContext());
            }
        }
    }

    private Statement createStatementFromPattern(StatementPattern pattern, BindingSet sourceBinding, MapBindingSet bnodeMapping) throws SailException {
        Resource subject = null;
        URI predicate = null;
        Value object = null;
        Resource context = null;
        if (pattern.getSubjectVar().hasValue()) {
            subject = (Resource)pattern.getSubjectVar().getValue();
        } else {
            subject = (Resource)sourceBinding.getValue(pattern.getSubjectVar().getName());
            if (subject == null && pattern.getSubjectVar().isAnonymous()) {
                Binding mappedSubject = bnodeMapping.getBinding(pattern.getSubjectVar().getName());
                if (mappedSubject != null) {
                    subject = (Resource)mappedSubject.getValue();
                } else {
                    subject = this.vf.createBNode();
                    bnodeMapping.addBinding(pattern.getSubjectVar().getName(), subject);
                }
            }
        }
        predicate = pattern.getPredicateVar().hasValue() ? (URI)pattern.getPredicateVar().getValue() : (URI)sourceBinding.getValue(pattern.getPredicateVar().getName());
        if (pattern.getObjectVar().hasValue()) {
            object = pattern.getObjectVar().getValue();
        } else {
            object = sourceBinding.getValue(pattern.getObjectVar().getName());
            if (object == null && pattern.getObjectVar().isAnonymous()) {
                Binding mappedObject = bnodeMapping.getBinding(pattern.getObjectVar().getName());
                if (mappedObject != null) {
                    object = (Resource)mappedObject.getValue();
                } else {
                    object = this.vf.createBNode();
                    bnodeMapping.addBinding(pattern.getObjectVar().getName(), object);
                }
            }
        }
        if (pattern.getContextVar() != null) {
            context = pattern.getContextVar().hasValue() ? (Resource)pattern.getContextVar().getValue() : (Resource)sourceBinding.getValue(pattern.getContextVar().getName());
        }
        Statement st = null;
        if (subject != null && predicate != null && object != null) {
            st = context != null ? this.vf.createStatement(subject, predicate, object, context) : this.vf.createStatement(subject, predicate, object);
        }
        return st;
    }

    private Value getValueForVar(Var var, BindingSet bindings) throws SailException {
        Value value = null;
        value = var.hasValue() ? var.getValue() : bindings.getValue(var.getName());
        return value;
    }
}

