/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.binary;

import info.aduna.io.IOUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.binary.BinaryRDFConstants;
import org.openrdf.rio.helpers.RDFParserBase;

public class BinaryRDFParser
extends RDFParserBase {
    private Value[] declaredValues = new Value[16];
    private DataInputStream in;

    public RDFFormat getRDFFormat() {
        return RDFFormat.BINARY;
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        throw new UnsupportedOperationException();
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        int formatVersion;
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be null");
        }
        this.in = new DataInputStream(in);
        byte[] magicNumber = IOUtil.readBytes(in, BinaryRDFConstants.MAGIC_NUMBER.length);
        if (!Arrays.equals(magicNumber, BinaryRDFConstants.MAGIC_NUMBER)) {
            this.reportFatalError("File does not contain a binary RDF document");
        }
        if ((formatVersion = this.in.readInt()) != 1) {
            this.reportFatalError("Incompatible format version: " + formatVersion);
        }
        this.rdfHandler.startRDF();
        block7: while (true) {
            byte recordType = this.in.readByte();
            switch (recordType) {
                case 127: {
                    break block7;
                }
                case 1: {
                    this.readStatement();
                    continue block7;
                }
                case 3: {
                    this.readValueDecl();
                    continue block7;
                }
                case 0: {
                    this.readNamespaceDecl();
                    continue block7;
                }
                case 2: {
                    this.readComment();
                    continue block7;
                }
                default: {
                    this.reportFatalError("Invalid record type: " + recordType);
                    continue block7;
                }
            }
            break;
        }
        this.rdfHandler.endRDF();
    }

    private void readNamespaceDecl() throws IOException, RDFHandlerException {
        String prefix = this.readString();
        String namespace = this.readString();
        this.rdfHandler.handleNamespace(prefix, namespace);
    }

    private void readComment() throws IOException, RDFHandlerException {
        String comment = this.readString();
        this.rdfHandler.handleComment(comment);
    }

    private void readValueDecl() throws IOException, RDFParseException {
        int id = this.in.readInt();
        Value v = this.readValue();
        if (id >= this.declaredValues.length) {
            Value[] newArray = new Value[2 * this.declaredValues.length];
            System.arraycopy(this.declaredValues, 0, newArray, 0, this.declaredValues.length);
            this.declaredValues = newArray;
        }
        this.declaredValues[id] = v;
    }

    private void readStatement() throws RDFParseException, IOException, RDFHandlerException {
        Value v = this.readValue();
        Resource subj = null;
        if (v instanceof Resource) {
            subj = (Resource)v;
        } else {
            this.reportFatalError("Invalid subject type: " + v);
        }
        v = this.readValue();
        URI pred = null;
        if (v instanceof URI) {
            pred = (URI)v;
        } else {
            this.reportFatalError("Invalid predicate type: " + v);
        }
        Value obj = this.readValue();
        if (obj == null) {
            this.reportFatalError("Invalid object type: null");
        }
        v = this.readValue();
        Resource context = null;
        if (v == null || v instanceof Resource) {
            context = (Resource)v;
        } else {
            this.reportFatalError("Invalid context type: " + v);
        }
        Statement st = this.createStatement(subj, pred, obj, context);
        this.rdfHandler.handleStatement(st);
    }

    private Value readValue() throws RDFParseException, IOException {
        byte valueType = this.in.readByte();
        switch (valueType) {
            case 0: {
                return null;
            }
            case 6: {
                return this.readValueRef();
            }
            case 1: {
                return this.readURI();
            }
            case 2: {
                return this.readBNode();
            }
            case 3: {
                return this.readPlainLiteral();
            }
            case 4: {
                return this.readLangLiteral();
            }
            case 5: {
                return this.readDatatypeLiteral();
            }
        }
        this.reportFatalError("Unknown value type: " + valueType);
        return null;
    }

    private Value readValueRef() throws IOException, RDFParseException {
        int id = this.in.readInt();
        return this.declaredValues[id];
    }

    private URI readURI() throws IOException, RDFParseException {
        String uri = this.readString();
        return this.createURI(uri);
    }

    private BNode readBNode() throws IOException, RDFParseException {
        String bnodeID = this.readString();
        return this.createBNode(bnodeID);
    }

    private Literal readPlainLiteral() throws IOException, RDFParseException {
        String label = this.readString();
        return this.createLiteral(label, null, null);
    }

    private Literal readLangLiteral() throws IOException, RDFParseException {
        String label = this.readString();
        String language = this.readString();
        return this.createLiteral(label, language, null);
    }

    private Literal readDatatypeLiteral() throws IOException, RDFParseException {
        String label = this.readString();
        String datatype = this.readString();
        URI dtUri = this.createURI(datatype);
        return this.createLiteral(label, null, dtUri);
    }

    private String readString() throws IOException {
        int stringLength = this.in.readInt();
        char[] cArray = new char[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            cArray[i] = this.in.readChar();
        }
        return new String(cArray);
    }
}

