/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.SPARQLIntersection;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPattern {
    private Var contextVar;
    private StatementPattern.Scope spScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private List<TupleExpr> requiredTEs = new ArrayList<TupleExpr>();
    private List<TupleExpr> optionalTEs = new ArrayList<TupleExpr>();
    private List<ValueExpr> constraints = new ArrayList<ValueExpr>();

    public GraphPattern() {
    }

    public GraphPattern(GraphPattern parent) {
        this.contextVar = parent.contextVar;
        this.spScope = parent.spScope;
    }

    public void setContextVar(Var contextVar) {
        this.contextVar = contextVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setStatementPatternScope(StatementPattern.Scope spScope) {
        this.spScope = spScope;
    }

    public StatementPattern.Scope getStatementPatternScope() {
        return this.spScope;
    }

    public void addRequiredTE(TupleExpr te) {
        this.requiredTEs.add(te);
    }

    public void addRequiredSP(Var subjVar, Var predVar, Var objVar) {
        this.addRequiredTE(new StatementPattern(this.spScope, subjVar, predVar, objVar, this.contextVar));
    }

    public List<TupleExpr> getRequiredTEs() {
        return Collections.unmodifiableList(this.requiredTEs);
    }

    public void addOptionalTE(TupleExpr te) {
        this.optionalTEs.add(te);
    }

    public List<TupleExpr> getOptionalTEs() {
        return Collections.unmodifiableList(this.optionalTEs);
    }

    public void addConstraint(ValueExpr constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(Collection<ValueExpr> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<ValueExpr> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public List<ValueExpr> removeAllConstraints() {
        List<ValueExpr> constraints = this.constraints;
        this.constraints = new ArrayList<ValueExpr>();
        return constraints;
    }

    public void clear() {
        this.requiredTEs.clear();
        this.optionalTEs.clear();
        this.constraints.clear();
    }

    public TupleExpr buildTupleExpr() {
        TupleExpr result;
        if (this.requiredTEs.isEmpty()) {
            result = new SingletonSet();
        } else {
            result = this.requiredTEs.get(0);
            for (int i = 1; i < this.requiredTEs.size(); ++i) {
                TupleExpr te = this.requiredTEs.get(i);
                result = this.containsProjection(te) ? new SPARQLIntersection(result, te) : new Join(result, te);
            }
        }
        for (TupleExpr optTE : this.optionalTEs) {
            result = new LeftJoin(result, optTE);
        }
        for (ValueExpr constraint : this.constraints) {
            result = new Filter(result, constraint);
        }
        return result;
    }

    private boolean containsProjection(TupleExpr t) {
        class VisitException
        extends Exception {
            VisitException() {
            }
        }
        final boolean[] result = new boolean[1];
        try {
            t.visit(new QueryModelVisitorBase<VisitException>(){

                @Override
                public void meet(Projection node) throws VisitException {
                    result[0] = true;
                    throw new VisitException();
                }
            });
        }
        catch (VisitException visitException) {
            // empty catch block
        }
        return result[0];
    }
}

