/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.local;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.text.term.vector.weighter.local.AbstractLocalTermWeighter;

@PublicationReference(author={"Susan T. Dumais"}, title="Improving the retrieval of information from external sources", year=1991, type=PublicationType.Journal, publication="Behavior Research Methods, Instruments, and Computers", pages={229, 236}, url="http://www.google.com/url?sa=t&source=web&ct=res&cd=1&url=http%3A%2F%2Fwww.psychonomic.org%2Fsearch%2Fview.cgi%3Fid%3D5145&ei=o7joSdGEHY-itgPLre3tAQ&usg=AFQjCNEvm6PZEL6_Hk3XThI6DQ-gGx9EnQ&sig2=-gjFzNroJQirwGtwjaJvgQ")
public class LogLocalTermWeighter
extends AbstractLocalTermWeighter {
    public LogLocalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public LogLocalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
    }

    @Override
    public Vector computeLocalWeights(Vector counts) {
        Vector result = this.getVectorFactory().copyVector(counts);
        for (VectorEntry entry : result) {
            double value = entry.getValue();
            if (value > 0.0) {
                entry.setValue(Math.log(1.0 + value));
                continue;
            }
            if (value == 0.0) continue;
            entry.setValue(0.0);
        }
        return result;
    }
}

