/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.global;

import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorUtil;
import gov.sandia.cognition.text.term.vector.weighter.global.AbstractEntropyBasedGlobalTermWeighter;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class DominanceGlobalTermWeighter
extends AbstractEntropyBasedGlobalTermWeighter {
    protected Vector dominance;

    public DominanceGlobalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public DominanceGlobalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
        this.setDominance(null);
    }

    @Override
    public DominanceGlobalTermWeighter clone() {
        DominanceGlobalTermWeighter clone = (DominanceGlobalTermWeighter)super.clone();
        clone.dominance = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.dominance);
        return clone;
    }

    @Override
    public void add(Vector counts) {
        super.add(counts);
        this.setDominance(null);
    }

    @Override
    public boolean remove(Vector counts) {
        boolean result = super.remove(counts);
        if (result) {
            this.setDominance(null);
        }
        return result;
    }

    @Override
    public Vector getGlobalWeights() {
        return this.getDominance();
    }

    @Override
    public int getDimensionality() {
        return VectorUtil.safeGetDimensionality((Vector)this.getTermGlobalFrequencies());
    }

    public Vector getDominance() {
        if (this.dominance == null && this.termGlobalFrequencies != null) {
            int dimensionality = this.getDimensionality();
            Vector newDominance = this.getVectorFactory().createVector(dimensionality);
            for (VectorEntry entry : this.termGlobalFrequencies) {
                int index = entry.getIndex();
                double termEntropySum = this.termEntropiesSum.getElement(index);
                double termOccurrences = entry.getValue();
                double value = 0.0;
                if (termOccurrences != 0.0) {
                    value = Math.exp(-(termEntropySum / termOccurrences - Math.log(termOccurrences))) / (double)this.documentCount;
                }
                newDominance.setElement(index, value);
            }
            this.setDominance(newDominance);
        }
        return this.dominance;
    }

    protected void setDominance(Vector dominance) {
        this.dominance = dominance;
    }
}

