/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.global;

import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.text.term.vector.weighter.global.AbstractFrequencyBasedGlobalTermWeighter;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public abstract class AbstractEntropyBasedGlobalTermWeighter
extends AbstractFrequencyBasedGlobalTermWeighter {
    protected Vector termEntropiesSum;

    public AbstractEntropyBasedGlobalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public AbstractEntropyBasedGlobalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
        this.setTermEntropiesSum(null);
    }

    @Override
    public AbstractEntropyBasedGlobalTermWeighter clone() {
        AbstractEntropyBasedGlobalTermWeighter clone = (AbstractEntropyBasedGlobalTermWeighter)super.clone();
        clone.termEntropiesSum = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.termEntropiesSum);
        return clone;
    }

    @Override
    public void add(Vector counts) {
        super.add(counts);
        for (VectorEntry entry : counts) {
            int index = entry.getIndex();
            double count = entry.getValue();
            if (!(count > 0.0)) continue;
            double termEntropySum = count * Math.log(count) + this.termEntropiesSum.getElement(index);
            this.termEntropiesSum.setElement(index, termEntropySum);
        }
    }

    @Override
    public boolean remove(Vector counts) {
        boolean result = super.remove(counts);
        if (result) {
            for (VectorEntry entry : counts) {
                int index = entry.getIndex();
                double count = entry.getValue();
                if (!(count > 0.0)) continue;
                double termEntropySum = count * Math.log(count) - this.termEntropiesSum.getElement(index);
                this.termEntropiesSum.setElement(index, termEntropySum);
            }
        }
        return result;
    }

    @Override
    protected void initializeVectors(int dimensionality) {
        super.initializeVectors(dimensionality);
        this.termEntropiesSum = this.getVectorFactory().createVector(dimensionality);
    }

    @Override
    protected void growVectors(int newDimensionality) {
        super.growVectors(newDimensionality);
        this.termEntropiesSum = this.termEntropiesSum.stack(this.getVectorFactory().createVector(newDimensionality - this.termEntropiesSum.getDimensionality()));
    }

    public Vector getTermEntropiesSum() {
        return this.termEntropiesSum;
    }

    protected void setTermEntropiesSum(Vector termEntropiesSum) {
        this.termEntropiesSum = termEntropiesSum;
    }
}

