/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.filter;

import gov.sandia.cognition.text.term.DefaultTermOccurrence;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermOccurrence;
import gov.sandia.cognition.text.term.filter.AbstractSingleTermFilter;
import java.util.LinkedHashMap;
import java.util.Map;

public class SynonymFilter
extends AbstractSingleTermFilter {
    protected Map<Term, Term> synonyms;

    public SynonymFilter() {
        this(new LinkedHashMap<Term, Term>());
    }

    public SynonymFilter(Map<Term, Term> synonyms) {
        this.setSynonyms(synonyms);
    }

    @Override
    public TermOccurrence filterTerm(TermOccurrence occurrence) {
        Term synonym = this.getSynonyms().get(occurrence.getTerm());
        if (synonym == null) {
            return occurrence;
        }
        return new DefaultTermOccurrence(synonym, occurrence.getStart(), occurrence.getLength());
    }

    public Map<Term, Term> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Map<Term, Term> synonyms) {
        this.synonyms = synonyms;
    }
}

