/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term;

import gov.sandia.cognition.text.term.AbstractTermIndex;
import gov.sandia.cognition.text.term.DefaultIndexedTerm;
import gov.sandia.cognition.text.term.IndexedTerm;
import gov.sandia.cognition.text.term.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTermIndex
extends AbstractTermIndex {
    protected Map<Term, DefaultIndexedTerm> termMap;
    protected List<DefaultIndexedTerm> termList;

    public DefaultTermIndex() {
        this.setTermMap(new HashMap<Term, DefaultIndexedTerm>());
        this.setTermList(new ArrayList<DefaultIndexedTerm>());
    }

    public DefaultTermIndex clone() {
        DefaultTermIndex clone = (DefaultTermIndex)super.clone();
        clone.termMap = new HashMap<Term, DefaultIndexedTerm>(this.termMap);
        clone.termList = new ArrayList<DefaultIndexedTerm>(this.termList);
        return clone;
    }

    @Override
    public IndexedTerm add(Term term) {
        if (term == null) {
            return null;
        }
        DefaultIndexedTerm indexedTerm = this.getIndexedTerm(term);
        if (indexedTerm == null) {
            int index = this.termList.size();
            indexedTerm = new DefaultIndexedTerm(index, term);
            this.termMap.put(term, indexedTerm);
            this.termList.add(indexedTerm);
        }
        return indexedTerm;
    }

    @Override
    public int getTermCount() {
        return this.termList.size();
    }

    public List<DefaultIndexedTerm> getTerms() {
        return Collections.unmodifiableList(this.getTermList());
    }

    @Override
    public DefaultIndexedTerm getIndexedTerm(Term term) {
        return this.termMap.get(term);
    }

    @Override
    public DefaultIndexedTerm getIndexedTerm(int index) {
        if (index < 0 || index >= this.getTermCount()) {
            return null;
        }
        return this.termList.get(index);
    }

    protected Map<Term, DefaultIndexedTerm> getTermMap() {
        return this.termMap;
    }

    protected void setTermMap(Map<Term, DefaultIndexedTerm> termMap) {
        this.termMap = termMap;
    }

    protected List<DefaultIndexedTerm> getTermList() {
        return this.termList;
    }

    protected void setTermList(List<DefaultIndexedTerm> termList) {
        this.termList = termList;
    }
}

