/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term;

import gov.sandia.cognition.text.term.IndexedTerm;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermIndex;
import gov.sandia.cognition.text.term.Termable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public abstract class AbstractTermIndex
extends AbstractCloneableSerializable
implements TermIndex {
    @Override
    public IndexedTerm getIndexedTerm(Termable termable) {
        return this.getIndexedTerm(termable.asTerm());
    }

    @Override
    public boolean hasIndexedTerm(IndexedTerm indexedTerm) {
        return indexedTerm != null && this.hasIndex(indexedTerm.getIndex()) && ObjectUtil.equalsSafe((Object)indexedTerm.getTerm(), (Object)this.getTerm(indexedTerm.getIndex()));
    }

    @Override
    public boolean hasTerm(Termable termable) {
        return this.hasTerm(termable.asTerm());
    }

    @Override
    public boolean hasTerm(Term term) {
        return this.getIndexedTerm(term) != null;
    }

    @Override
    public boolean hasIndex(int index) {
        return index >= 0 && index < this.getTermCount();
    }

    @Override
    public int getIndex(Termable termable) {
        return this.getIndex(termable.asTerm());
    }

    @Override
    public int getIndex(Term term) {
        IndexedTerm result = this.getIndexedTerm(term);
        if (result == null) {
            return -1;
        }
        return result.getIndex();
    }

    @Override
    public Term getTerm(int index) {
        IndexedTerm indexedTerm = this.getIndexedTerm(index);
        if (indexedTerm == null) {
            return null;
        }
        return indexedTerm.asTerm();
    }

    @Override
    public IndexedTerm add(Termable termable) {
        return this.add(termable.asTerm());
    }

    @Override
    public void addAll(Iterable<? extends Termable> terms) {
        for (Termable termable : terms) {
            this.add(termable);
        }
    }
}

