/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.document.extractor;

import gov.sandia.cognition.io.FileUtil;
import gov.sandia.cognition.text.document.DefaultDocument;
import gov.sandia.cognition.text.document.Document;
import gov.sandia.cognition.text.document.extractor.AbstractSingleDocumentExtractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TextDocumentExtractor
extends AbstractSingleDocumentExtractor {
    public static final String CONTENT_TYPE = "text/plain";
    public static final List<String> DEFAULT_TEXT_FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("txt", "text"));

    @Override
    public boolean canExtract(URI uri) throws IOException {
        String fileName = uri.getPath();
        String fileExtension = FileUtil.getExtension((String)fileName);
        if (fileExtension != null) {
            String fileExtensionLowerCase = fileExtension.toLowerCase();
            return DEFAULT_TEXT_FILE_EXTENSIONS.contains(fileExtensionLowerCase);
        }
        return false;
    }

    @Override
    public boolean canExtract(URLConnection connection) throws IOException {
        String contentType = connection.getContentType();
        return CONTENT_TYPE.equals(contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document extractDocument(URLConnection connection) throws IOException {
        StringBuffer body = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String s = null;
            while ((s = reader.readLine()) != null) {
                body.append(s);
                body.append("\n");
            }
        }
        finally {
            reader.close();
        }
        DefaultDocument result = new DefaultDocument();
        result.readMetaData(connection);
        result.setBody(body.toString());
        return result;
    }
}

