/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.convert;

import gov.sandia.cognition.text.DefaultTextual;
import gov.sandia.cognition.text.Textual;
import gov.sandia.cognition.text.convert.AbstractSingleTextualConverter;
import gov.sandia.cognition.text.document.Document;
import gov.sandia.cognition.text.document.Field;
import java.util.LinkedList;
import java.util.List;

public class DocumentFieldConcatenator
extends AbstractSingleTextualConverter<Document, Textual> {
    public static final String DEFAULT_FIELD_SEPARATOR = "\n";
    protected List<String> fieldNames;
    protected String fieldSeparator;

    public DocumentFieldConcatenator() {
        this(new LinkedList<String>(), DEFAULT_FIELD_SEPARATOR);
    }

    public DocumentFieldConcatenator(List<String> fieldNames, String fieldSeparator) {
        this.setFieldNames(fieldNames);
        this.setFieldSeparator(fieldSeparator);
    }

    public Textual evaluate(Document document) {
        if (document == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (String fieldName : this.getFieldNames()) {
            Field field;
            if (i > 0) {
                result.append(this.getFieldSeparator());
            }
            if ((field = document.getField(fieldName)) != null) {
                result.append(field.getText());
            }
            ++i;
        }
        return new DefaultTextual(result.toString());
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }
}

