/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.LinuxResourceCalculatorPlugin;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class ResourceCalculatorPlugin
extends Configured {
    public abstract long getVirtualMemorySize();

    public abstract long getPhysicalMemorySize();

    public abstract long getAvailableVirtualMemorySize();

    public abstract long getAvailablePhysicalMemorySize();

    public abstract int getNumProcessors();

    public abstract long getCpuFrequency();

    public abstract long getCumulativeCpuTime();

    public abstract float getCpuUsage();

    public abstract ProcResourceValues getProcResourceValues();

    public static ResourceCalculatorPlugin getResourceCalculatorPlugin(Class<? extends ResourceCalculatorPlugin> clazz, Configuration conf) {
        if (clazz != null) {
            return (ResourceCalculatorPlugin)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        }
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux")) {
                return new LinuxResourceCalculatorPlugin();
            }
        }
        catch (SecurityException se) {
            return null;
        }
        return null;
    }

    public static class ProcResourceValues {
        private final long cumulativeCpuTime;
        private final long physicalMemorySize;
        private final long virtualMemorySize;

        public ProcResourceValues(long cumulativeCpuTime, long physicalMemorySize, long virtualMemorySize) {
            this.cumulativeCpuTime = cumulativeCpuTime;
            this.physicalMemorySize = physicalMemorySize;
            this.virtualMemorySize = virtualMemorySize;
        }

        public long getPhysicalMemorySize() {
            return this.physicalMemorySize;
        }

        public long getVirtualMemorySize() {
            return this.virtualMemorySize;
        }

        public long getCumulativeCpuTime() {
            return this.cumulativeCpuTime;
        }
    }
}

