/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;

public class TaskAttemptContextImpl
extends JobContextImpl
implements TaskAttemptContext {
    private final TaskAttemptID taskId;
    private String status = "";
    private StatusReporter reporter;

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId) {
        this(conf, taskId, new DummyReporter());
    }

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId, StatusReporter reporter) {
        super(conf, taskId.getJobID());
        this.taskId = taskId;
        this.reporter = reporter;
    }

    @Override
    public TaskAttemptID getTaskAttemptID() {
        return this.taskId;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Counter getCounter(Enum<?> counterName) {
        return this.reporter.getCounter(counterName);
    }

    @Override
    public Counter getCounter(String groupName, String counterName) {
        return this.reporter.getCounter(groupName, counterName);
    }

    public void progress() {
        this.reporter.progress();
    }

    protected void setStatusString(String status) {
        this.status = status;
    }

    @Override
    public void setStatus(String status) {
        this.setStatusString(status);
        this.reporter.setStatus(status);
    }

    public static class DummyReporter
    extends StatusReporter {
        @Override
        public void setStatus(String s) {
        }

        @Override
        public void progress() {
        }

        @Override
        public Counter getCounter(Enum<?> name) {
            return new Counters().findCounter(name);
        }

        @Override
        public Counter getCounter(String group, String name) {
            return new Counters().findCounter(group, name);
        }
    }
}

