/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;

public class TaskAttemptID
extends org.apache.hadoop.mapred.ID {
    protected static final String ATTEMPT = "attempt";
    private TaskID taskId;

    public TaskAttemptID(TaskID taskId, int id) {
        super(id);
        if (taskId == null) {
            throw new IllegalArgumentException("taskId cannot be null");
        }
        this.taskId = taskId;
    }

    public TaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int id) {
        this(new TaskID(jtIdentifier, jobId, isMap, taskId), id);
    }

    public TaskAttemptID(String jtIdentifier, int jobId, TaskType type, int taskId, int id) {
        this(new TaskID(jtIdentifier, jobId, type, taskId), id);
    }

    public TaskAttemptID() {
        this.taskId = new TaskID();
    }

    public JobID getJobID() {
        return this.taskId.getJobID();
    }

    public TaskID getTaskID() {
        return this.taskId;
    }

    public boolean isMap() {
        return this.taskId.isMap();
    }

    public TaskType getTaskType() {
        return this.taskId.getTaskType();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TaskAttemptID that = (TaskAttemptID)o;
        return this.taskId.equals(that.taskId);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.taskId.appendTo(builder).append('_').append(this.id);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.taskId.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.taskId.write(out);
    }

    @Override
    public int hashCode() {
        return this.taskId.hashCode() * 5 + this.id;
    }

    @Override
    public int compareTo(ID o) {
        TaskAttemptID that = (TaskAttemptID)o;
        int tipComp = this.taskId.compareTo(that.taskId);
        if (tipComp == 0) {
            return this.id - that.id;
        }
        return tipComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(ATTEMPT)).toString();
    }

    public static TaskAttemptID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split(Character.toString('_'));
            if (parts.length == 6 && parts[0].equals(ATTEMPT)) {
                boolean isMap = false;
                if (parts[3].equals("m")) {
                    isMap = true;
                } else if (parts[3].equals("r")) {
                    isMap = false;
                } else {
                    throw new Exception();
                }
                return new org.apache.hadoop.mapred.TaskAttemptID(parts[1], Integer.parseInt(parts[2]), isMap, Integer.parseInt(parts[4]), Integer.parseInt(parts[5]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskAttemptId string : " + str + " is not properly formed");
    }
}

