/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.aop.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentLoader {
    private static final Logger logger = LogManager.getLogger(AgentLoader.class);
    private static final String VMCLASS = "com.sun.tools.attach.VirtualMachine";

    private static long copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static byte[] createManifest(Class<?> agentClass) {
        StringBuffer sb = new StringBuffer();
        try {
            agentClass.getDeclaredMethod("premain", String.class, Instrumentation.class);
            sb.append("Premain-Class: " + agentClass.getName() + "\n");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            agentClass.getDeclaredMethod("agentmain", String.class, Instrumentation.class);
            sb.append("Agent-Class: " + agentClass.getName() + "\n");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        sb.append("Can-Redefine-Classes: true\n");
        sb.append("Can-Retransform-Classes: true\n");
        try {
            return sb.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Charset US-ASCII isn't supported!! This should never happen.");
        }
    }

    public static void createAgentJar(File file, Class<?> agentClass) throws IOException {
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(file));
        String classEntryPath = agentClass.getName().replace(".", "/") + ".class";
        InputStream classStream = agentClass.getClassLoader().getResourceAsStream(classEntryPath);
        if (classEntryPath.startsWith("/")) {
            classEntryPath = classEntryPath.substring(1);
        }
        JarEntry entry = new JarEntry(classEntryPath);
        jos.putNextEntry(entry);
        AgentLoader.copy(classStream, jos);
        jos.closeEntry();
        entry = new JarEntry("META-INF/MANIFEST.MF");
        jos.putNextEntry(entry);
        jos.write(AgentLoader.createManifest(agentClass));
        jos.closeEntry();
        jos.close();
    }

    private static List<File> getPotentialToolsJars() {
        File jdkHome;
        File jdkSourced;
        ArrayList<File> jars = new ArrayList<File>();
        File javaHome = new File(System.getProperty("java.home"));
        File jreSourced = new File(javaHome, "lib/tools.jar");
        if (jreSourced.exists()) {
            jars.add(jreSourced);
        }
        if ("jre".equals(javaHome.getName()) && (jdkSourced = new File(jdkHome = new File(javaHome, "../"), "lib/tools.jar")).exists()) {
            jars.add(jdkSourced);
        }
        return jars;
    }

    private static Class<?> tryGetVMClass() {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    try {
                        return ClassLoader.getSystemClassLoader().loadClass(AgentLoader.VMCLASS);
                    }
                    catch (ClassNotFoundException e) {
                        for (File jar : AgentLoader.getPotentialToolsJars()) {
                            try {
                                return new URLClassLoader(new URL[]{jar.toURI().toURL()}).loadClass(AgentLoader.VMCLASS);
                            }
                            catch (Throwable t) {
                                logger.trace("Exception while loading tools.jar from " + jar, t);
                            }
                        }
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable actual = pae.getCause();
            if (actual instanceof ClassNotFoundException) {
                logger.trace("No VirtualMachine found");
                return null;
            }
            throw new RuntimeException("Unexpected checked exception : " + actual);
        }
    }

    private static void loadFailed() {
        System.err.println("Unable to load the java agent dynamically");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAgent(Class<?> agentClass) throws IOException {
        File tmp = File.createTempFile("agent", ".jar");
        tmp.deleteOnExit();
        AgentLoader.createAgentJar(tmp, agentClass);
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, p);
        Class<?> vmClass = AgentLoader.tryGetVMClass();
        if (vmClass == null) {
            AgentLoader.loadFailed();
        } else {
            try {
                Method attach = vmClass.getMethod("attach", String.class);
                Method loadAgent = vmClass.getMethod("loadAgent", String.class);
                Method detach = vmClass.getMethod("detach", new Class[0]);
                Object vm = attach.invoke(null, pid);
                try {
                    loadAgent.invoke(vm, tmp.getAbsolutePath());
                }
                finally {
                    detach.invoke(vm, new Object[0]);
                }
            }
            catch (Exception e) {
                logger.warn("Loading the agent failed", (Throwable)e);
                AgentLoader.loadFailed();
            }
        }
    }
}

