/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.validation;

import java.util.List;
import org.openimaj.data.RandomData;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.validation.DefaultValidationData;
import org.openimaj.util.list.AcceptingListView;
import org.openimaj.util.list.SkippingListView;

public class RandomisedPercentageHoldOut<INSTANCE>
extends DefaultValidationData<ListDataset<INSTANCE>> {
    public RandomisedPercentageHoldOut(double percentageTraining, ListDataset<INSTANCE> dataset) {
        if (percentageTraining < 0.0 || percentageTraining > 1.0) {
            throw new IllegalArgumentException("percentage of training instances must be between 0 and 1");
        }
        if (percentageTraining < 0.5) {
            int nTraining = (int)Math.round(percentageTraining * (double)dataset.size());
            int[] trainKeys = RandomData.getUniqueRandomInts((int)nTraining, (int)0, (int)dataset.size());
            this.training = new ListBackedDataset((List)new AcceptingListView(DatasetAdaptors.asList(dataset), trainKeys));
            this.validation = new ListBackedDataset((List)new SkippingListView(DatasetAdaptors.asList(dataset), trainKeys));
        } else {
            int nValidation = (int)Math.round((1.0 - percentageTraining) * (double)dataset.size());
            int[] validationKeys = RandomData.getUniqueRandomInts((int)nValidation, (int)0, (int)dataset.size());
            this.training = new ListBackedDataset((List)new SkippingListView(DatasetAdaptors.asList(dataset), validationKeys));
            this.validation = new ListBackedDataset((List)new AcceptingListView(DatasetAdaptors.asList(dataset), validationKeys));
        }
    }
}

