/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster.analyser;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.analyser.RandomBaselineClusterAnalysis;
import org.openimaj.experiment.evaluation.cluster.analyser.RandomBaselineWrappable;

public class RandomBaselineClusterAnalyser<ANNER extends ClusterAnalyser<ANNYS>, ANNYS extends RandomBaselineWrappable & AnalysisResult>
implements ClusterAnalyser<RandomBaselineClusterAnalysis<ANNYS>> {
    private static final int NUMBER_OF_TRIALS = 100;
    private ANNER ann;
    private int trials;
    private Random random;

    public RandomBaselineClusterAnalyser(ANNER analyser) {
        this.ann = analyser;
        this.trials = 100;
        this.random = new Random();
    }

    public RandomBaselineClusterAnalyser(ANNER analyser, int trials) {
        this.ann = analyser;
        this.trials = trials;
        this.random = new Random();
    }

    public RandomBaselineClusterAnalyser(ANNER analyser, int trials, long seed) {
        this.ann = analyser;
        this.trials = trials;
        this.random = new Random(seed);
    }

    @Override
    public RandomBaselineClusterAnalysis<ANNYS> analyse(int[][] correct, int[][] estimated) {
        RandomBaselineWrappable score = (RandomBaselineWrappable)this.ann.analyse(correct, estimated);
        RandomBaselineWrappable randscore = (RandomBaselineWrappable)this.ann.analyse(correct, this.baseline(estimated));
        double meanrand = randscore.score();
        for (int i = 0; i < this.trials; ++i) {
            randscore = (RandomBaselineWrappable)this.ann.analyse(correct, this.baseline(estimated));
            meanrand += randscore.score();
        }
        return new RandomBaselineClusterAnalysis<RandomBaselineWrappable>(score, meanrand /= (double)(this.trials + 1));
    }

    private int[][] baseline(int[][] estimated) {
        TIntArrayList items = new TIntArrayList();
        for (int[] is : estimated) {
            for (int i = 0; i < is.length; ++i) {
                items.add(is[i]);
            }
        }
        int[][] baseline = new int[estimated.length][];
        items.shuffle(this.random);
        int[] itemsArr = items.toArray();
        int seen = 0;
        for (int i = 0; i < baseline.length; ++i) {
            int needed = estimated[i].length;
            baseline[i] = new int[needed];
            System.arraycopy(itemsArr, seen, baseline[i], 0, needed);
            seen += needed;
        }
        return baseline;
    }
}

