/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster.analyser;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.cluster.analyser.DecisionAnalysis;
import org.openimaj.experiment.evaluation.cluster.analyser.RandomBaselineWrappable;

public class FScoreAnalysis
implements AnalysisResult,
RandomBaselineWrappable {
    private DecisionAnalysis ann;

    public FScoreAnalysis(DecisionAnalysis ann) {
        this.ann = ann;
    }

    @Override
    public String getSummaryReport() {
        return String.format("f1=%2.5f", this.fscore(1.0));
    }

    @Override
    public String getDetailReport() {
        return this.getSummaryReport();
    }

    @Override
    public JasperPrint getSummaryReport(String title, String info) throws JRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JasperPrint getDetailReport(String title, String info) throws JRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double score() {
        return this.fscore(1.0);
    }

    public double randIndex() {
        return (double)(this.ann.TP + this.ann.TN) / (double)(this.ann.TP + this.ann.FP + this.ann.TN + this.ann.FN);
    }

    public String toString() {
        return this.getSummaryReport();
    }

    public double fscore(double beta) {
        double R;
        double beta2 = beta * beta;
        double P = this.ann.precision();
        if (P + (R = this.ann.recall()) == 0.0) {
            return 0.0;
        }
        return (beta2 + 1.0) * P * R / (beta2 * P + R);
    }

    public DecisionAnalysis getDecisionAnalysis() {
        return this.ann;
    }
}

