/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.Evaluator;
import org.openimaj.experiment.evaluation.cluster.analyser.ClusterAnalyser;
import org.openimaj.experiment.evaluation.cluster.processor.Clusterer;
import org.openimaj.util.function.Function;

public class ClusterEvaluator<D, T extends AnalysisResult>
implements Evaluator<int[][], T> {
    private int[][] correct;
    private ClusterAnalyser<T> analyser;
    private Clusterer<D> gen;
    private D data;

    public ClusterEvaluator(Clusterer<D> gen, D data, int[][] clusters, ClusterAnalyser<T> analyser) {
        this.gen = gen;
        this.correct = clusters;
        this.analyser = analyser;
        this.data = data;
    }

    public <A, B> ClusterEvaluator(Clusterer<D> gen, D data, Map<A, ? extends List<B>> dataset, ClusterAnalyser<T> analyser) {
        this.gen = gen;
        this.correct = new int[dataset.size()][];
        int j = 0;
        int k = 0;
        for (Map.Entry<A, List<B>> es : dataset.entrySet()) {
            this.correct[j] = new int[es.getValue().size()];
            int i = 0;
            List<B> value = es.getValue();
            for (int l = 0; l < value.size(); ++l) {
                this.correct[j][i++] = k++;
            }
            ++j;
        }
        this.analyser = analyser;
        this.data = data;
    }

    public <A, B> ClusterEvaluator(Clusterer<D> gen, D data, Function<B, Integer> indexFunc, Map<A, ? extends List<B>> dataset, ClusterAnalyser<T> analyser) {
        this.gen = gen;
        this.correct = new int[dataset.size()][];
        int j = 0;
        for (Map.Entry<A, List<B>> es : dataset.entrySet()) {
            this.correct[j] = new int[es.getValue().size()];
            int i = 0;
            List<B> value = es.getValue();
            for (B b : value) {
                this.correct[j][i++] = (Integer)indexFunc.apply(b);
            }
            ++j;
        }
        this.analyser = analyser;
        this.data = data;
    }

    public <A, B> ClusterEvaluator(Clusterer<D> gen, Map<A, ? extends List<B>> dataset, Function<List<B>, D> transform, ClusterAnalyser<T> analyser) {
        this.gen = gen;
        this.analyser = analyser;
        this.correct = new int[dataset.size()][];
        int j = 0;
        ArrayList<B> flattened = new ArrayList<B>();
        for (Map.Entry<A, List<B>> es : dataset.entrySet()) {
            this.correct[j] = new int[es.getValue().size()];
            int i = 0;
            for (B b : es.getValue()) {
                this.correct[j][i++] = flattened.size();
                flattened.add(b);
            }
            ++j;
        }
        this.data = transform.apply(flattened);
    }

    @Override
    public int[][] evaluate() {
        return this.gen.performClustering(this.data);
    }

    @Override
    public T analyse(int[][] estimated) {
        return this.analyser.analyse(this.correct, estimated);
    }
}

