/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix;

import gov.sandia.cognition.learning.data.DefaultTargetEstimatePair;
import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrixPerformanceEvaluator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.experiment.evaluation.classification.ClassificationAnalyser;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMResult;

public class CMAnalyser<OBJECT, CLASS>
implements ClassificationAnalyser<CMResult<CLASS>, CLASS, OBJECT> {
    protected Strategy strategy;
    ConfusionMatrixPerformanceEvaluator<?, CLASS> eval = new ConfusionMatrixPerformanceEvaluator();

    public CMAnalyser(Strategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public CMResult<CLASS> analyse(Map<OBJECT, ClassificationResult<CLASS>> predicted, Map<OBJECT, Set<CLASS>> actual) {
        ArrayList data = new ArrayList();
        for (OBJECT obj : predicted.keySet()) {
            Set<CLASS> pclasses = predicted.get(obj).getPredictedClasses();
            Set<CLASS> aclasses = actual.get(obj);
            this.strategy.add(data, pclasses, aclasses);
        }
        return new CMResult(this.eval.evaluatePerformance(data));
    }

    public static enum Strategy {
        SINGLE{

            @Override
            protected <CLASS> void add(List<TargetEstimatePair<CLASS, CLASS>> data, Set<CLASS> predicted, Set<CLASS> actual) {
                data.add((TargetEstimatePair<CLASS, CLASS>)DefaultTargetEstimatePair.create(actual.size() == 0 ? null : new ArrayList<CLASS>(actual).get(0), predicted.size() == 0 ? null : new ArrayList<CLASS>(predicted).get(0)));
            }
        }
        ,
        MULTIPLE{

            @Override
            protected <CLASS> void add(List<TargetEstimatePair<CLASS, CLASS>> data, Set<CLASS> predicted, Set<CLASS> actual) {
                HashSet<CLASS> allClasses = new HashSet<CLASS>();
                allClasses.addAll(predicted);
                allClasses.addAll(actual);
                for (Object clz : allClasses) {
                    Object target = actual.contains(clz) ? clz : null;
                    Object estimate = predicted.contains(clz) ? clz : null;
                    data.add((TargetEstimatePair<CLASS, CLASS>)DefaultTargetEstimatePair.create(target, estimate));
                }
            }
        }
        ,
        MULTIPLE_ORDERED{

            @Override
            protected <CLASS> void add(List<TargetEstimatePair<CLASS, CLASS>> data, Set<CLASS> predicted, Set<CLASS> actual) {
                LinkedHashSet op = (LinkedHashSet)predicted;
                LinkedHashSet ap = (LinkedHashSet)actual;
                if (op.size() != ap.size()) {
                    throw new RuntimeException("Sets are not the same size!");
                }
                Object[] opa = op.toArray();
                Object[] apa = ap.toArray();
                for (int i = 0; i < opa.length; ++i) {
                    data.add((TargetEstimatePair<CLASS, CLASS>)new DefaultTargetEstimatePair(opa[i], apa[i]));
                }
            }
        };


        protected abstract <CLASS> void add(List<TargetEstimatePair<CLASS, CLASS>> var1, Set<CLASS> var2, Set<CLASS> var3);
    }
}

