/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix;

import com.bethecoder.ascii_table.ASCIITable;
import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrix;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMResult;

public class AggregatedCMResult<CLASS>
implements AnalysisResult {
    protected List<CMResult<CLASS>> matrices;

    public AggregatedCMResult() {
        this.matrices = new ArrayList<CMResult<CLASS>>();
    }

    public AggregatedCMResult(List<CMResult<CLASS>> results) {
        this.matrices = results;
    }

    public AggregateStatistics computeStatistics() {
        DescriptiveStatistics accuracy = new DescriptiveStatistics();
        DescriptiveStatistics errorRate = new DescriptiveStatistics();
        for (CMResult<CLASS> result : this.matrices) {
            ConfusionMatrix<CLASS> m = result.getMatrix();
            accuracy.addValue(m.getAccuracy());
            errorRate.addValue(m.getErrorRate());
        }
        AggregateStatistics s = new AggregateStatistics();
        s.meanAccuracy = accuracy.getMean();
        s.stddevAccuracy = accuracy.getStandardDeviation();
        s.meanErrorRate = errorRate.getMean();
        s.stddevErrorRate = errorRate.getStandardDeviation();
        return s;
    }

    public String toString() {
        return this.getSummaryReport();
    }

    @Override
    public JasperPrint getSummaryReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JasperPrint getDetailReport(String title, String info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSummaryReport() {
        AggregateStatistics summary = this.computeStatistics();
        String[] header = new String[]{"Value", "Mean", "Standard Deviation"};
        String[][] data = new String[][]{{"Accuracy", String.format("%2.3f", summary.meanAccuracy), String.format("%2.3f", summary.stddevAccuracy)}, {"Error Rate", String.format("%2.3f", summary.meanErrorRate), String.format("%2.3f", summary.stddevErrorRate)}};
        return ASCIITable.getInstance().getTable(header, data);
    }

    @Override
    public String getDetailReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("** Summary Report **\n");
        sb.append(this.getSummaryReport());
        sb.append("\n");
        sb.append("** Per Run Reports **\n");
        for (int i = 0; i < this.matrices.size(); ++i) {
            CMResult<CLASS> result = this.matrices.get(i);
            sb.append("***************************************************************\n");
            sb.append("* Run #" + i + "\n");
            sb.append("***************************************************************\n");
            sb.append(result.getDetailReport());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class AggregateStatistics {
        private double meanAccuracy;
        private double stddevAccuracy;
        private double meanErrorRate;
        private double stddevErrorRate;
    }
}

