/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment.evaluation.classification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.util.pair.ObjectDoublePair;

public class ClassificationResultUtils {
    private ClassificationResultUtils() {
    }

    public static <CLASS> CLASS getHighestConfidenceClass(ClassificationResult<CLASS> result) {
        CLASS bestClass = null;
        double bestConfidence = 0.0;
        for (CLASS s : result.getPredictedClasses()) {
            if (!(result.getConfidence(s) >= bestConfidence)) continue;
            bestClass = s;
            bestConfidence = result.getConfidence(s);
        }
        return bestClass;
    }

    public static <CLASS> List<ObjectDoublePair<CLASS>> getSortedClassesAndConfidences(ClassificationResult<CLASS> result) {
        ArrayList<ObjectDoublePair<CLASS>> list = new ArrayList<ObjectDoublePair<CLASS>>();
        for (CLASS clz : result.getPredictedClasses()) {
            list.add(new ObjectDoublePair(clz, result.getConfidence(clz)));
        }
        Collections.sort(list, new Comparator<ObjectDoublePair<CLASS>>(){

            @Override
            public int compare(ObjectDoublePair<CLASS> o1, ObjectDoublePair<CLASS> o2) {
                return -1 * Double.compare(o1.second, o2.second);
            }
        });
        return list;
    }
}

