/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.openimaj.citation.ReferenceListener;
import org.openimaj.experiment.ExperimentContext;
import org.openimaj.experiment.RunnableExperiment;
import org.openimaj.experiment.agent.ExperimentAgent;
import org.openimaj.experiment.agent.TimeTracker;
import org.openimaj.experiment.annotations.Time;

public class ExperimentRunner {
    private ExperimentRunner() {
    }

    public static synchronized ExperimentContext runExperiment(RunnableExperiment experiment) {
        return InternalRunner.runExperiment(experiment);
    }

    static {
        try {
            ExperimentAgent.initialise();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalRunner {
        private InternalRunner() {
        }

        public static synchronized ExperimentContext runExperiment(RunnableExperiment experiment) {
            Set oldRefs = ReferenceListener.reset();
            Map<String, SummaryStatistics> oldTimes = TimeTracker.reset();
            ExperimentContext context = new ExperimentContext(experiment);
            InternalRunner.runSetup(experiment);
            InternalRunner.runPerform(experiment);
            InternalRunner.runFinish(experiment, context);
            context.lock();
            ReferenceListener.addReferences((Collection)oldRefs);
            TimeTracker.addMissing(oldTimes);
            return context;
        }

        @Time(identifier="Setup Experiment")
        protected static void runSetup(RunnableExperiment experiment) {
            experiment.setup();
        }

        @Time(identifier="Perform Experiment")
        protected static void runPerform(RunnableExperiment experiment) {
            experiment.perform();
        }

        @Time(identifier="Finish Experiment")
        protected static void runFinish(RunnableExperiment experiment, ExperimentContext context) {
            experiment.finish(context);
        }
    }
}

