/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.experiment;

import com.bethecoder.ascii_table.ASCIITable;
import com.bethecoder.ascii_table.ASCIITableHeader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openimaj.citation.ReferenceListener;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.output.StandardFormatters;
import org.openimaj.experiment.RunnableExperiment;
import org.openimaj.experiment.agent.TimeTracker;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.experiment.annotations.DependentVariable;
import org.openimaj.experiment.annotations.Experiment;
import org.openimaj.experiment.annotations.IndependentVariable;
import org.openimaj.experiment.evaluation.AnalysisResult;
import org.openimaj.util.array.ArrayUtils;

public class ExperimentContext {
    private static final Logger logger = LogManager.getLogger(ExperimentContext.class);
    private boolean isLocked;
    private RunnableExperiment experiment;
    private Date dateCompleted;
    private Class<?> exptClass;
    private Experiment experimentDetails;
    private Set<Reference> bibliography;
    private Map<String, SummaryStatistics> timingInfo;
    private Map<Variable, Field> independentVariables = new HashMap<Variable, Field>();
    private Map<Variable, Field> dependentVariables = new HashMap<Variable, Field>();

    protected ExperimentContext(RunnableExperiment experiment) {
        this.experiment = experiment;
        this.experimentDetails = this.getExperiment(experiment);
        this.exptClass = experiment.getClass();
        this.readVariables(experiment);
    }

    private Experiment getExperiment(RunnableExperiment experiment) {
        for (Class<?> exptClass = experiment.getClass(); exptClass != null; exptClass = exptClass.getSuperclass()) {
            Experiment ann = exptClass.getAnnotation(Experiment.class);
            if (ann == null) continue;
            return ann;
        }
        return null;
    }

    private void readVariables(RunnableExperiment expt) {
        for (Class<?> exptClass = expt.getClass(); exptClass != null; exptClass = exptClass.getSuperclass()) {
            for (Field field : exptClass.getDeclaredFields()) {
                String id;
                IndependentVariable iv = field.getAnnotation(IndependentVariable.class);
                DependentVariable dv = field.getAnnotation(DependentVariable.class);
                if (iv != null && dv != null) {
                    throw new RuntimeException("Invalid experiment! The field " + field + " cannot be both a dependent and independent variable.");
                }
                if (iv != null) {
                    id = iv.identifier();
                    if (id == null || id.length() == 0) {
                        id = field.getName();
                    }
                    this.independentVariables.put(new Variable(id), field);
                }
                if (dv == null) continue;
                id = dv.identifier();
                if (id == null || id.length() == 0) {
                    id = field.getName();
                }
                this.dependentVariables.put(new Variable(id), field);
            }
        }
    }

    protected void lock() {
        this.isLocked = true;
        this.bibliography = ReferenceListener.getReferences();
        this.timingInfo = TimeTracker.getTimes();
        this.dateCompleted = new Date();
    }

    public Set<Reference> getBibliography() {
        if (!this.isLocked) {
            this.bibliography = ReferenceListener.getReferences();
        }
        return this.bibliography;
    }

    public Map<String, SummaryStatistics> getTimingInfo() {
        if (!this.isLocked) {
            this.timingInfo = TimeTracker.getTimes();
        }
        return this.timingInfo;
    }

    public Map<Variable, Object> getIndependentVariables() {
        HashMap<Variable, Object> vars = new HashMap<Variable, Object>();
        for (Map.Entry<Variable, Field> e : this.independentVariables.entrySet()) {
            Field field = e.getValue();
            field.setAccessible(true);
            try {
                Object value = field.get(this.experiment);
                vars.put(e.getKey(), value);
            }
            catch (Exception ex) {
                logger.warn((Object)ex);
                vars.put(e.getKey(), null);
            }
        }
        return vars;
    }

    public Map<Variable, Object> getDependentVariables() {
        HashMap<Variable, Object> vars = new HashMap<Variable, Object>();
        for (Map.Entry<Variable, Field> e : this.dependentVariables.entrySet()) {
            Field field = e.getValue();
            field.setAccessible(true);
            try {
                Object value = field.get(this.experiment);
                vars.put(e.getKey(), value);
            }
            catch (Exception ex) {
                logger.warn((Object)ex);
                vars.put(e.getKey(), null);
            }
        }
        return vars;
    }

    private String getExptInfoTable() {
        Date dc = this.dateCompleted == null ? new Date() : this.dateCompleted;
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"Class", this.exptClass.getName()});
        data.add(new String[]{"Report compiled", new SimpleDateFormat().format(dc)});
        if (this.experimentDetails != null) {
            data.add(new String[]{"Author", WordUtils.wrap((String)this.experimentDetails.author(), (int)this.exptClass.getName().length())});
            data.add(new String[]{"Created on", this.experimentDetails.dateCreated()});
            data.add(new String[]{"Description", WordUtils.wrap((String)this.experimentDetails.description(), (int)this.exptClass.getName().length())});
        }
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("", 1), new ASCIITableHeader("", -1)};
        String table = ASCIITable.getInstance().getTable(header, (String[][])data.toArray((T[])new String[data.size()][]));
        int width = table.indexOf("\n") + 1;
        table = table.substring(2 * width);
        return table;
    }

    private String getTimingTable() {
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("Experimental Timing", 0)};
        String[][] data = this.formatAsTable(TimeTracker.format(this.timingInfo));
        return ASCIITable.getInstance().getTable(header, data);
    }

    private String getBibliographyTable() {
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("Bibliography", -1)};
        String refs = StandardFormatters.STRING.format(this.bibliography);
        refs = WordUtils.wrap((String)refs, (int)Math.max(this.exptClass.getName().length() + 10, 72), (String)(SystemUtils.LINE_SEPARATOR + "  "), (boolean)true);
        String[][] data = this.formatAsTable(refs);
        return ASCIITable.getInstance().getTable(header, data);
    }

    private String[][] formatAsTable(String data) {
        String[] splits = data.trim().split("\\r?\\n");
        String[][] out = new String[splits.length][];
        for (int i = 0; i < splits.length; ++i) {
            out[i] = new String[]{splits[i]};
        }
        return out;
    }

    private String getIndependentVariablesTable() {
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("Independent Variables", 0)};
        String[][] data = this.formatAsTable(this.formatVariables(this.getIndependentVariables()));
        return ASCIITable.getInstance().getTable(header, data);
    }

    private String formatVariables(Map<Variable, Object> vars) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Map.Entry<Variable, Object> e : vars.entrySet()) {
            String id = e.getKey().identifier;
            String[] val = this.formatValue(e.getValue());
            data.add(new String[]{id, val[0]});
            for (int i = 1; i < val.length; ++i) {
                data.add(new String[]{"", val[i]});
            }
        }
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("", 1), new ASCIITableHeader("", -1)};
        String table = ASCIITable.getInstance().getTable(header, (String[][])data.toArray((T[])new String[data.size()][]));
        int width = table.indexOf("\n") + 1;
        table = table.substring(2 * width);
        return table;
    }

    private String getDependentVariablesTable() {
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("Dependent Variables", 0)};
        String[][] data = this.formatAsTable(this.formatVariables(this.getDependentVariables()));
        return ASCIITable.getInstance().getTable(header, data);
    }

    private String[] formatValue(Object value) {
        if (value.getClass().getAnnotation(DatasetDescription.class) != null) {
            DatasetDescription d = value.getClass().getAnnotation(DatasetDescription.class);
            ArrayList<String[]> data = new ArrayList<String[]>();
            data.add(new String[]{"Name", d.name()});
            String[] description = WordUtils.wrap((String)d.description(), (int)(this.exptClass.getName().length() - 20)).split("\\r?\\n");
            data.add(new String[]{"Description", description[0]});
            for (int i = 1; i < description.length; ++i) {
                data.add(new String[]{"", description[i]});
            }
            ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("", 1), new ASCIITableHeader("", -1)};
            String table = ASCIITable.getInstance().getTable(header, (String[][])data.toArray((T[])new String[data.size()][]));
            int width = table.indexOf("\n") + 1;
            table = table.substring(2 * width);
            return table.split("\\r?\\n");
        }
        if (value instanceof AnalysisResult) {
            return ((AnalysisResult)value).getSummaryReport().split("\\r?\\n");
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return new String[]{""};
            }
            String str = Array.get(value, 0).toString();
            for (int i = 1; i < length; ++i) {
                str = str + ", " + Array.get(value, i);
            }
            return WordUtils.wrap((String)str, (int)(this.exptClass.getName().length() - 20)).split("\\r?\\n");
        }
        return value.toString().split("\\r?\\n");
    }

    public String toString() {
        String[][] exptinfo = this.formatAsTable(this.getExptInfoTable());
        String[][] timeInfo = this.formatAsTable(this.getTimingTable());
        String[][] ivInfo = this.formatAsTable(this.getIndependentVariablesTable());
        String[][] dvInfo = this.formatAsTable(this.getDependentVariablesTable());
        String[][] biblInfo = this.formatAsTable(this.getBibliographyTable());
        String[][] data = (String[][])ArrayUtils.concatenate((Object[][])new String[][][]{exptinfo, timeInfo, ivInfo, dvInfo, biblInfo});
        ASCIITableHeader[] header = new ASCIITableHeader[]{new ASCIITableHeader("Experiment Context", -1)};
        return ASCIITable.getInstance().getTable(header, data);
    }

    public static class Variable {
        public String identifier;

        Variable(String identifier) {
            this.identifier = identifier;
        }
    }
}

