/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import java.util.ArrayList;

public class SpeedInfo {
    public static final int SAMPLE_LENGTH = 1000;
    public static final int SAMPLE_MAX = 20;
    protected ArrayList<Sample> samples = new ArrayList();
    protected long peak;
    protected Sample start = null;

    public synchronized void start(long current) {
        Sample s = new Sample(current);
        s.start = true;
        this.start = s;
        this.add(s);
    }

    public synchronized void step(long current) {
        long now = System.currentTimeMillis();
        long lastUpdate = this.getLastUpdate();
        if (lastUpdate + 1000L < now) {
            this.add(new Sample(current, now));
        }
    }

    public synchronized int getCurrentSpeed() {
        if (this.getRowSamples() < 2) {
            return 0;
        }
        Sample s1 = this.samples.get(this.samples.size() - 2);
        Sample s2 = this.samples.get(this.samples.size() - 1);
        long current = s2.current - s1.current;
        long time = s2.now - s1.now;
        if (time == 0L) {
            return 0;
        }
        return (int)(current * 1000L / time);
    }

    public synchronized int getAverageSpeed() {
        if (this.start == null || this.getRowSamples() < 2) {
            return 0;
        }
        Sample s2 = this.samples.get(this.samples.size() - 1);
        long current = s2.current - this.start.current;
        long time = s2.now - this.start.now;
        return (int)(current * 1000L / time);
    }

    public synchronized int getAverageSpeed(int stepsBack) {
        if (this.start == null || this.getRowSamples() < 2) {
            return 0;
        }
        int is2 = this.samples.size() - 1;
        int is1 = is2 - stepsBack;
        if (is1 < 0) {
            is1 = 0;
        }
        Sample s1 = this.samples.get(is1);
        if (s1.now < this.start.now) {
            s1 = this.start;
        }
        Sample s2 = this.samples.get(is2);
        long current = s2.current - s1.current;
        long time = s2.now - s1.now;
        return (int)(current * 1000L / time);
    }

    public synchronized int getSamples() {
        return this.samples.size();
    }

    public synchronized Sample getSample(int index) {
        return this.samples.get(index);
    }

    public synchronized long getPeak() {
        return this.peak;
    }

    protected Sample getStart() {
        int i = this.samples.size() - 1;
        while (i >= 0) {
            Sample s = this.samples.get(i);
            if (s.start) {
                return s;
            }
            --i;
        }
        return null;
    }

    protected void add(Sample s) {
        if (this.samples.size() > 0) {
            Sample s1 = this.samples.get(this.samples.size() - 1);
            if (s1.current > s.current) {
                s.start = true;
                this.start = s;
            }
        }
        this.samples.add(s);
        while (this.samples.size() > 20) {
            this.samples.remove(0);
        }
        this.peakUpdate();
    }

    protected int getRowSamples() {
        int i = this.samples.size() - 1;
        while (i >= 0) {
            Sample s = this.samples.get(i);
            if (s.start) {
                return this.samples.size() - i;
            }
            --i;
        }
        return this.samples.size();
    }

    protected long getLastUpdate() {
        if (this.samples.size() == 0) {
            return 0L;
        }
        Sample s = this.samples.get(this.samples.size() - 1);
        return s.now;
    }

    protected void peakUpdate() {
        this.peak = 0L;
        for (Sample s : this.samples) {
            if (this.peak >= s.current) continue;
            this.peak = s.current;
        }
    }

    public class Sample {
        public long current;
        public long now;
        public boolean start;

        public Sample() {
            this.current = 0L;
            this.now = System.currentTimeMillis();
            this.start = false;
        }

        public Sample(long current) {
            this.current = current;
            this.now = System.currentTimeMillis();
            this.start = false;
        }

        public Sample(long current, long now) {
            this.current = current;
            this.now = now;
            this.start = false;
        }
    }
}

