/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import Jama.Matrix;
import java.util.Collection;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.SingleBandImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.HoughLines;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.edges.CannyEdgeDetector;
import org.openimaj.image.processing.threshold.OtsuThreshold;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.renderer.MBFImageRenderer;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.path.Path2d;

public class SkewCorrector
implements ImageProcessor<FImage> {
    private static final boolean DEBUG = true;
    private int accuracy = 1;

    public void processImage(FImage image) {
        CannyEdgeDetector cad = new CannyEdgeDetector();
        FImage edgeImage = ((FImage)image.process((SinglebandImageProcessor)cad)).inverse();
        HoughLines hl = new HoughLines(360 * this.accuracy);
        edgeImage.analyseWith((ImageAnalyser)hl);
        this.debugLines(edgeImage, Matrix.identity((int)3, (int)3), "Detection of Horizontal Lines", hl.getBestLines(2));
        double rotationAngle = hl.calculatePrevailingAngle();
        FImage rotImg = null;
        FImage outImg = null;
        if (rotationAngle == Double.MIN_VALUE) {
            System.out.println("WARNING: Detection of rotation angle failed.");
            rotImg = edgeImage.clone();
            outImg = image.clone();
        } else {
            rotationAngle -= 90.0;
            System.out.println("Rotational angle: " + (rotationAngle %= 360.0));
            Matrix rotationMatrix = new Matrix((double[][])new double[][]{{Math.cos(-(rotationAngle *= 0.0174532925)), -Math.sin(-rotationAngle), 0.0}, {Math.sin(-rotationAngle), Math.cos(-rotationAngle), 0.0}, {0.0, 0.0, 1.0}});
            rotImg = (FImage)ProjectionProcessor.project(edgeImage, rotationMatrix, Float.valueOf(1.0f)).process((ImageProcessor)new OtsuThreshold());
            outImg = ProjectionProcessor.project(image, rotationMatrix, Float.valueOf(0.0f));
        }
        DisplayUtilities.display((Image)outImg, (String)"Rotated Image");
        rotImg.analyseWith((ImageAnalyser)hl);
        float shearAngleRange = 20.0f;
        this.debugLines(rotImg, Matrix.identity((int)3, (int)3), "Detection of Vertical Lines", hl.getBestLines(2, -20.0f, 20.0f));
        double shearAngle = hl.calculatePrevailingAngle(-20.0f, 20.0f);
        if (shearAngle == Double.MIN_VALUE) {
            System.out.println("WARNING: Detection of shear angle failed.");
        } else {
            System.out.println("Shear angle = " + (shearAngle %= 360.0));
            Matrix shearMatrix = new Matrix((double[][])new double[][]{{1.0, Math.tan(shearAngle *= 0.0174532925), 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
            outImg = outImg.transform(shearMatrix);
        }
        DisplayUtilities.display((Image)outImg, (String)"Final Image");
        image.internalAssign(outImg);
    }

    private void debugLines(FImage i, Matrix tf, String title, Collection<Line2d> lines) {
        MBFImage output = new MBFImage(i.getWidth(), i.getHeight(), 3);
        MBFImageRenderer r = output.createRenderer();
        r.drawImage((SingleBandImage)i, 0, 0);
        for (Line2d l : lines) {
            Line2d l2 = l.transform(tf).lineWithinSquare(output.getBounds());
            if (l2 == null) continue;
            System.out.println(l2);
            r.drawLine((Path2d)l2, 2, (Object)RGBColour.RED);
        }
        DisplayUtilities.display((Image)output, (String)title);
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }
}

