/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.threshold;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class AdaptiveLocalThresholdGaussian
implements SinglebandImageProcessor<Float, FImage> {
    private float offset;
    private float sigma;

    public AdaptiveLocalThresholdGaussian(float sigma, float offset) {
        this.sigma = sigma;
        this.offset = offset;
    }

    public void processImage(FImage image) {
        FImage tmp = (FImage)image.process((SinglebandImageProcessor)new FGaussianConvolve(this.sigma));
        float[][] tpix = tmp.pixels;
        float[][] ipix = image.pixels;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                tpix[y][x] = ipix[y][x] < tpix[y][x] - this.offset ? 0.0f : 1.0f;
            }
        }
        image.internalAssign(tmp);
    }
}

