/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.morphology;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openimaj.image.pixel.Pixel;

public class StructuringElement {
    public static final StructuringElement BOX = new StructuringElement();
    public static final StructuringElement CROSS;
    public static final StructuringElement HPIT;
    public Set<Pixel> positive = new HashSet<Pixel>();
    public Set<Pixel> negative = new HashSet<Pixel>();

    public StructuringElement() {
    }

    public StructuringElement(Set<Pixel> positive, Set<Pixel> negative) {
        if (positive != null) {
            this.positive.addAll(positive);
        }
        if (negative != null) {
            this.negative.addAll(negative);
        }
    }

    public StructuringElement(Pixel[] positive, Pixel[] negative) {
        if (positive != null) {
            this.positive.addAll(Arrays.asList(positive));
        }
        if (negative != null) {
            this.negative.addAll(Arrays.asList(negative));
        }
    }

    public int[] size() {
        int xmin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymin = Integer.MAX_VALUE;
        int ymax = -2147483647;
        for (Pixel p : this.positive) {
            if (p.x < xmin) {
                xmin = p.x;
            }
            if (p.x > xmax) {
                xmax = p.x;
            }
            if (p.y < ymin) {
                ymin = p.y;
            }
            if (p.y <= ymax) continue;
            ymax = p.y;
        }
        for (Pixel p : this.negative) {
            if (p.x < xmin) {
                xmin = p.x;
            }
            if (p.x > xmax) {
                xmax = p.x;
            }
            if (p.y < ymin) {
                ymin = p.y;
            }
            if (p.y <= ymax) continue;
            ymax = p.y;
        }
        return new int[]{1 + xmax - xmin, 1 + ymax - ymin, xmin, ymin};
    }

    public static StructuringElement parseElement(String ele, int cx, int cy) {
        String[] lines = ele.split("\\n");
        int height = lines.length;
        int width = lines[0].length();
        StructuringElement se = new StructuringElement();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                char c = lines[j].charAt(i);
                if (c == '*') {
                    se.positive.add(new Pixel(i - cx, j - cy));
                    continue;
                }
                if (c != 'o') continue;
                se.negative.add(new Pixel(i - cx, j - cy));
            }
        }
        return se;
    }

    public String toString() {
        int[] sz = this.size();
        String s = "";
        for (int j = 0; j < sz[1]; ++j) {
            for (int i = 0; i < sz[0]; ++i) {
                Pixel p = new Pixel(i + sz[2], j + sz[3]);
                s = this.positive.contains(p) ? s + "*" : (this.negative.contains(p) ? s + "o" : s + ".");
            }
            s = s + "\n";
        }
        return s;
    }

    public boolean matches(Pixel p, Set<Pixel> pixels) {
        return this.intersect(p, pixels).size() == this.countActive();
    }

    Set<Pixel> intersect(Pixel p, Set<Pixel> pixels) {
        Pixel imp;
        HashSet<Pixel> intersect = new HashSet<Pixel>();
        for (Pixel sep : this.positive) {
            imp = new Pixel(p.x + sep.x, p.y + sep.y);
            if (!pixels.contains(imp)) continue;
            intersect.add(imp);
        }
        for (Pixel sep : this.negative) {
            imp = new Pixel(p.x + sep.x, p.y + sep.y);
            if (pixels.contains(imp)) continue;
            intersect.add(imp);
        }
        return intersect;
    }

    public int countActive() {
        return this.positive.size() + this.negative.size();
    }

    public static StructuringElement disk(int radius) {
        StructuringElement se = new StructuringElement();
        int r2 = radius * radius;
        for (int j = -radius; j <= radius; ++j) {
            int j2 = j * j;
            for (int i = -radius; i <= radius; ++i) {
                if (i * i + j2 > r2) continue;
                se.positive.add(new Pixel(i, j));
            }
        }
        return se;
    }

    static {
        StructuringElement.BOX.positive.add(new Pixel(-1, -1));
        StructuringElement.BOX.positive.add(new Pixel(0, -1));
        StructuringElement.BOX.positive.add(new Pixel(1, -1));
        StructuringElement.BOX.positive.add(new Pixel(-1, 0));
        StructuringElement.BOX.positive.add(new Pixel(0, 0));
        StructuringElement.BOX.positive.add(new Pixel(1, 0));
        StructuringElement.BOX.positive.add(new Pixel(-1, 1));
        StructuringElement.BOX.positive.add(new Pixel(0, 1));
        StructuringElement.BOX.positive.add(new Pixel(1, 1));
        CROSS = new StructuringElement();
        StructuringElement.CROSS.positive.add(new Pixel(0, -1));
        StructuringElement.CROSS.positive.add(new Pixel(-1, 0));
        StructuringElement.CROSS.positive.add(new Pixel(0, 0));
        StructuringElement.CROSS.positive.add(new Pixel(1, 0));
        StructuringElement.CROSS.positive.add(new Pixel(0, 1));
        HPIT = new StructuringElement();
        StructuringElement.HPIT.positive.add(new Pixel(-1, 0));
        StructuringElement.HPIT.positive.add(new Pixel(1, 0));
    }
}

