/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

public class EdgeFinder
implements ImageAnalyser<FImage> {
    protected float[][] kx;
    protected float[][] ky;
    public FImage magnitude;
    public FImage angle;

    public EdgeFinder(float[][] kx, float[][] ky) {
        this.kx = kx;
        this.ky = ky;
    }

    public EdgeFinder() {
        this.kx = new float[][]{{1.0f, 1.0f, 0.0f, -1.0f, -1.0f}, {2.0f, 2.0f, 0.0f, -2.0f, -2.0f}, {2.0f, 2.0f, 0.0f, -2.0f, -2.0f}, {2.0f, 2.0f, 0.0f, -2.0f, -2.0f}, {1.0f, 1.0f, 0.0f, -1.0f, -1.0f}};
        this.ky = new float[][]{{1.0f, 2.0f, 2.0f, 2.0f, 1.0f}, {1.0f, 2.0f, 2.0f, 2.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-1.0f, -2.0f, -2.0f, -2.0f, -1.0f}, {-1.0f, -2.0f, -2.0f, -2.0f, -1.0f}};
    }

    public void analyseImage(FImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        this.magnitude = new FImage(width, height);
        this.angle = new FImage(width, height);
        int w = (this.kx.length - 1) / 2;
        for (int y = w + 1; y < height - w; ++y) {
            for (int x = w + 1; x < width - w; ++x) {
                double gx = 0.0;
                double gy = 0.0;
                for (int j = 0; j < this.kx.length; ++j) {
                    for (int i = 0; i < this.kx.length; ++i) {
                        gx += (double)(image.pixels[y - w + j][x - w + i] * this.kx[j][i]);
                        gy += (double)(image.pixels[y - w + j][x - w + i] * this.ky[j][i]);
                    }
                }
                this.magnitude.pixels[y][x] = (float)Math.sqrt(gx * gx + gy * gy);
                this.angle.pixels[y][x] = gy != 0.0 ? (float)Math.atan(gx / -gy) : 1.57f;
            }
        }
    }
}

