/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Deprecated
public class CannyEdgeDetector2
implements SinglebandImageProcessor<Float, FImage> {
    private boolean complete = false;
    private int threshold = 128;
    private int hystThresh1 = 50;
    private int hystThresh2 = 230;
    private int kernelSize = 15;
    final float ORIENT_SCALE = 40.0f;
    private int height;
    private int width;
    private int picsize;
    private float[] data;
    private int[] derivative_mag;
    private float[] magnitude;
    private float[] orientation;
    private FImage sourceImage;
    private FImage edgeImage;

    public boolean isImageReady() {
        return this.complete;
    }

    public void processImage(FImage image) {
        this.complete = false;
        int widGaussianKernel = this.kernelSize;
        int threshold = this.threshold;
        int threshold1 = this.hystThresh1;
        int threshold2 = this.hystThresh2;
        if (threshold < 0 || threshold > 255) {
            throw new IllegalArgumentException("The value of the threshold is out of its valid range.");
        }
        if (widGaussianKernel < 3 || widGaussianKernel > 40) {
            throw new IllegalArgumentException("The value of the widGaussianKernel is out of its valid range.");
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.picsize = this.width * this.height;
        this.sourceImage = image;
        this.data = new float[this.picsize];
        this.magnitude = new float[this.picsize];
        this.orientation = new float[this.picsize];
        float f = 1.0f;
        this.canny_core(1.0f, widGaussianKernel);
        this.thresholding_tracker(threshold1, threshold2);
        for (int i = 0; i < this.picsize; ++i) {
            this.data[i] = this.data[i] > (float)threshold ? 1.0f : -1.0f;
        }
        this.edgeImage = new FImage(this.data, this.width, this.height).normalise();
        this.data = null;
        this.complete = true;
        image.internalAssign(this.edgeImage);
    }

    protected void display(int[] data) {
        FImage tmp = new FImage(this.width, this.height);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                tmp.pixels[r][c] = (float)data[c + r * this.width] / 255.0f;
            }
        }
        DisplayUtilities.display((Image)tmp);
    }

    protected void display(float[] data) {
        FImage tmp = new FImage(this.width, this.height);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                tmp.pixels[r][c] = data[c + r * this.width] / 255.0f;
            }
        }
        DisplayUtilities.display((Image)tmp);
    }

    private void canny_core(float f, int i) {
        float f1;
        int k4;
        this.derivative_mag = new int[this.picsize];
        float[] af4 = new float[i];
        float[] af5 = new float[i];
        float[] af6 = new float[i];
        this.data = this.sourceImage.clone().multiply(Float.valueOf(255.0f)).getFloatPixelVector();
        for (k4 = 0; !(k4 >= i || (f1 = this.gaussian(k4, f)) <= 0.005f && k4 >= 2); ++k4) {
            float f2 = this.gaussian((float)k4 - 0.5f, f);
            float f3 = this.gaussian((float)k4 + 0.5f, f);
            float f4 = this.gaussian(k4, f * 0.5f);
            af4[k4] = (f1 + f2 + f3) / 3.0f / (6.283185f * f * f);
            af5[k4] = f3 - f2;
            af6[k4] = 1.6f * f4 - f1;
        }
        int j = k4;
        float[] af = new float[this.picsize];
        float[] af1 = new float[this.picsize];
        int j1 = this.width - (j - 1);
        int l = this.width * (j - 1);
        int i1 = this.width * (this.height - (j - 1));
        for (int l4 = j - 1; l4 < j1; ++l4) {
            for (int l5 = l; l5 < i1; l5 += this.width) {
                float f8;
                int k1 = l4 + l5;
                float f10 = f8 = this.data[k1] * af4[0];
                int l6 = 1;
                int k7 = k1 - this.width;
                int i8 = k1 + this.width;
                while (l6 < j) {
                    f8 += af4[l6] * (this.data[k7] + this.data[i8]);
                    f10 += af4[l6] * (this.data[k1 - l6] + this.data[k1 + l6]);
                    ++l6;
                    k7 -= this.width;
                    i8 += this.width;
                }
                af[k1] = f8;
                af1[k1] = f10;
            }
        }
        float[] af2 = new float[this.picsize];
        for (int i5 = j - 1; i5 < j1; ++i5) {
            for (int i6 = l; i6 < i1; i6 += this.width) {
                float f9 = 0.0f;
                int l1 = i5 + i6;
                for (int i7 = 1; i7 < j; ++i7) {
                    f9 += af5[i7] * (af[l1 - i7] - af[l1 + i7]);
                }
                af2[l1] = f9;
            }
        }
        af = null;
        float[] af3 = new float[this.picsize];
        for (int j5 = k4; j5 < this.width - k4; ++j5) {
            for (int j6 = l; j6 < i1; j6 += this.width) {
                float f11 = 0.0f;
                int i2 = j5 + j6;
                int j7 = 1;
                int l7 = this.width;
                while (j7 < j) {
                    f11 += af5[j7] * (af1[i2 - l7] - af1[i2 + l7]);
                    ++j7;
                    l7 += this.width;
                }
                af3[i2] = f11;
            }
        }
        af1 = null;
        j1 = this.width - j;
        l = this.width * j;
        i1 = this.width * (this.height - j);
        for (int k5 = j; k5 < j1; ++k5) {
            for (int k6 = l; k6 < i1; k6 += this.width) {
                float f5;
                int j2 = k5 + k6;
                int k2 = j2 - this.width;
                int l2 = j2 + this.width;
                int i3 = j2 - 1;
                int j3 = j2 + 1;
                int k3 = k2 - 1;
                int l3 = k2 + 1;
                int i4 = l2 - 1;
                int j4 = l2 + 1;
                float f6 = af2[j2];
                float f7 = af3[j2];
                float f12 = this.hypotenuse(f6, f7);
                int k = (int)((double)f12 * 20.0);
                this.derivative_mag[j2] = k >= 256 ? 255 : k;
                float f13 = this.hypotenuse(af2[k2], af3[k2]);
                float f14 = this.hypotenuse(af2[l2], af3[l2]);
                float f15 = this.hypotenuse(af2[i3], af3[i3]);
                float f16 = this.hypotenuse(af2[j3], af3[j3]);
                float f18 = this.hypotenuse(af2[l3], af3[l3]);
                float f20 = this.hypotenuse(af2[j4], af3[j4]);
                float f19 = this.hypotenuse(af2[i4], af3[i4]);
                float f17 = this.hypotenuse(af2[k3], af3[k3]);
                if (f6 * f7 <= 0.0f) {
                    if (Math.abs(f6) >= Math.abs(f7)) {
                        float f2;
                        f5 = Math.abs(f6 * f12);
                        if (!(f2 >= Math.abs(f7 * f18 - (f6 + f7) * f16)) || !(f5 > Math.abs(f7 * f19 - (f6 + f7) * f15))) continue;
                    } else {
                        float f3;
                        f5 = Math.abs(f7 * f12);
                        if (!(f3 >= Math.abs(f6 * f18 - (f7 + f6) * f13)) || !(f5 > Math.abs(f6 * f19 - (f7 + f6) * f14))) continue;
                    }
                } else if (Math.abs(f6) >= Math.abs(f7)) {
                    float f4;
                    f5 = Math.abs(f6 * f12);
                    if (!(f4 >= Math.abs(f7 * f20 + (f6 - f7) * f16)) || !(f5 > Math.abs(f7 * f17 + (f6 - f7) * f15))) continue;
                } else {
                    float f8;
                    f5 = Math.abs(f7 * f12);
                    if (!(f8 >= Math.abs(f6 * f20 + (f7 - f6) * f14)) || !(f5 > Math.abs(f6 * f17 + (f7 - f6) * f13))) continue;
                }
                this.magnitude[j2] = this.derivative_mag[j2];
                this.orientation[j2] = (float)Math.toDegrees(Math.atan2(f7, f6));
            }
        }
        this.derivative_mag = null;
        af2 = null;
        af3 = null;
    }

    private float hypotenuse(float f, float f1) {
        if (f == 0.0f && f1 == 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(f * f + f1 * f1);
    }

    private float gaussian(float f, float f1) {
        return (float)Math.exp(-f * f / (2.0f * f1 * f1));
    }

    private void thresholding_tracker(int i, int j) {
        for (int k = 0; k < this.picsize; ++k) {
            this.data[k] = 0.0f;
        }
        for (int l = 0; l < this.width; ++l) {
            for (int i1 = 0; i1 < this.height; ++i1) {
                if (!(this.magnitude[l + this.width * i1] >= (float)i)) continue;
                this.follow(l, i1, j);
            }
        }
    }

    private boolean follow(int i, int j, int k) {
        int j1 = i + 1;
        int k1 = i - 1;
        int l1 = j + 1;
        int i2 = j - 1;
        int j2 = i + j * this.width;
        if (l1 >= this.height) {
            l1 = this.height - 1;
        }
        if (i2 < 0) {
            i2 = 0;
        }
        if (j1 >= this.width) {
            j1 = this.width - 1;
        }
        if (k1 < 0) {
            k1 = 0;
        }
        if (this.data[j2] == 0.0f) {
            this.data[j2] = this.magnitude[j2];
            boolean flag = false;
            for (int l = k1; l <= j1; ++l) {
                for (int i1 = i2; i1 <= l1; ++i1) {
                    int k2 = l + i1 * this.width;
                    if (i1 == j && l == i || !(this.magnitude[k2] >= (float)k) || !this.follow(l, i1, k)) continue;
                    flag = true;
                    break;
                }
                if (!flag) break;
            }
            return true;
        }
        return false;
    }

    public void setSourceImage(FImage image) {
        this.sourceImage = image;
    }

    public FImage getEdgeImage() {
        return this.edgeImage;
    }

    public float[] getMagnitude() {
        return this.magnitude;
    }

    public float[] getOrientation() {
        return this.orientation;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getHystThresh1() {
        return this.hystThresh1;
    }

    public void setHystThresh1(int hystThresh1) {
        this.hystThresh1 = hystThresh1;
    }

    public int getHystThresh2() {
        return this.hystThresh2;
    }

    public void setHystThresh2(int hystThresh2) {
        this.hystThresh2 = hystThresh2;
    }

    public int getKernelSize() {
        return this.kernelSize;
    }

    public void setKernelSize(int kernelSize) {
        this.kernelSize = kernelSize;
    }
}

