/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.ImageProcessor;

public class FTriangleFilter
implements ImageProcessor<FImage> {
    private boolean zeropad;
    private int filterHeight;
    private int filterWidth;

    public FTriangleFilter(int filterWidth, int filterHeight, boolean zeropad) {
        this.filterWidth = filterWidth;
        this.filterHeight = filterHeight;
        this.zeropad = zeropad;
    }

    public FTriangleFilter(int filterWidth, int filterHeight) {
        this(filterWidth, filterHeight, false);
    }

    public void processImage(FImage image) {
        FTriangleFilter.convolve(image, this.filterWidth, this.filterHeight, this.zeropad);
    }

    public static float[] createKernel1D(int width) {
        float[] kernel = new float[width * 2 - 1];
        float invNorm = 1.0f / (float)(width * width);
        kernel[width - 1] = (float)width * invNorm;
        for (int i = 0; i < width - 1; ++i) {
            kernel[i] = (float)(i + 1) * invNorm;
            kernel[kernel.length - i - 1] = kernel[i];
        }
        return kernel;
    }

    static void convolve(FImage image, int filterWidth, int filterHeight, boolean zeropad) {
        FTriangleFilter.convolveVertical(image, image, filterHeight, zeropad);
        FTriangleFilter.convolveHorizontal(image, image, filterWidth, zeropad);
    }

    static void convolveVertical(FImage dest, FImage image, int filterSize, boolean zeropad) {
        if (image.height == 0) {
            return;
        }
        float scale = (float)(1.0 / ((double)filterSize * (double)filterSize));
        float[] buffer = new float[image.height + filterSize];
        int bufferOffset = filterSize;
        for (int x = 0; x < image.width; ++x) {
            int y;
            buffer[bufferOffset + image.height - 1] = image.pixels[image.height - 1][x];
            for (y = image.height - 2; y >= 0; --y) {
                buffer[bufferOffset + y] = buffer[bufferOffset + y + 1] + image.pixels[y][x];
            }
            if (zeropad) {
                while (y >= -filterSize) {
                    buffer[bufferOffset + y] = buffer[bufferOffset + y + 1];
                    --y;
                }
            } else {
                while (y >= -filterSize) {
                    buffer[bufferOffset + y] = buffer[bufferOffset + y + 1] + image.pixels[0][x];
                    --y;
                }
            }
            for (y = -filterSize; y < image.height - filterSize; ++y) {
                buffer[bufferOffset + y] = buffer[bufferOffset + y] - buffer[bufferOffset + y + filterSize];
            }
            if (!zeropad) {
                for (y = image.height - filterSize; y < image.height; ++y) {
                    buffer[bufferOffset + y] = buffer[bufferOffset + y] - buffer[bufferOffset + image.height - 1] * (float)(image.height - filterSize - y);
                }
            }
            for (y = -filterSize + 1; y < image.height; ++y) {
                int n = bufferOffset + y;
                buffer[n] = buffer[n] + buffer[bufferOffset + y - 1];
            }
            for (y = dest.height - 1; y >= 0; --y) {
                dest.pixels[y][x] = scale * (buffer[bufferOffset + y] - buffer[bufferOffset + y - filterSize]);
            }
        }
    }

    static void convolveHorizontal(FImage dest, FImage image, int filterSize, boolean zeropad) {
        if (image.width == 0) {
            return;
        }
        float scale = (float)(1.0 / ((double)filterSize * (double)filterSize));
        float[] buffer = new float[image.width + filterSize];
        int bufferOffset = filterSize;
        for (int y = 0; y < image.height; ++y) {
            int x;
            buffer[bufferOffset + image.width - 1] = image.pixels[y][image.width - 1];
            for (x = image.width - 2; x >= 0; --x) {
                buffer[bufferOffset + x] = buffer[bufferOffset + x + 1] + image.pixels[y][x];
            }
            if (zeropad) {
                while (x >= -filterSize) {
                    buffer[bufferOffset + x] = buffer[bufferOffset + x + 1];
                    --x;
                }
            } else {
                while (x >= -filterSize) {
                    buffer[bufferOffset + x] = buffer[bufferOffset + x + 1] + image.pixels[y][0];
                    --x;
                }
            }
            for (x = -filterSize; x < image.width - filterSize; ++x) {
                buffer[bufferOffset + x] = buffer[bufferOffset + x] - buffer[bufferOffset + x + filterSize];
            }
            if (!zeropad) {
                for (x = image.width - filterSize; x < image.width; ++x) {
                    buffer[bufferOffset + x] = buffer[bufferOffset + x] - buffer[bufferOffset + image.width - 1] * (float)(image.width - filterSize - x);
                }
            }
            for (x = -filterSize + 1; x < image.width; ++x) {
                int n = bufferOffset + x;
                buffer[n] = buffer[n] + buffer[bufferOffset + x - 1];
            }
            for (x = dest.width - 1; x >= 0; --x) {
                dest.pixels[y][x] = scale * (buffer[bufferOffset + x] - buffer[bufferOffset + x - filterSize]);
            }
        }
    }
}

