/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.openimaj.image.FImage;

public class FourierTransform {
    private FImage phase;
    private FImage magnitude;
    private boolean centre;

    public FourierTransform(FImage image, boolean centre) {
        this.centre = centre;
        this.process(image);
    }

    public FourierTransform(FImage magnitude, FImage phase, boolean centre) {
        this.centre = centre;
        this.magnitude = magnitude;
        this.phase = phase;
    }

    public static float[][] prepareData(FImage input, int rs, int cs, boolean centre) {
        return FourierTransform.prepareData(input.pixels, rs, cs, centre);
    }

    public static float[] prepareData1d(FImage input, int rs, int cs, boolean centre) {
        return FourierTransform.prepareData1d(input.pixels, rs, cs, centre);
    }

    public static float[][] prepareData(float[][] input, int rs, int cs, boolean centre) {
        float[][] prepared = new float[rs][cs * 2];
        if (centre) {
            for (int r = 0; r < Math.min(rs, input.length); ++r) {
                for (int c = 0; c < Math.min(cs, input[0].length); ++c) {
                    prepared[r][c * 2] = input[r][c] * (float)(1 - 2 * ((r + c) % 2));
                }
            }
        } else {
            for (int r = 0; r < Math.min(rs, input.length); ++r) {
                for (int c = 0; c < Math.min(cs, input[0].length); ++c) {
                    prepared[r][c * 2] = input[r][c];
                }
            }
        }
        return prepared;
    }

    public static float[] prepareData1d(float[][] input, int rs, int cs, boolean centre) {
        float[] prepared = new float[rs * cs * 2];
        if (centre) {
            for (int r = 0; r < Math.min(rs, input.length); ++r) {
                for (int c = 0; c < Math.min(cs, input[0].length); ++c) {
                    prepared[r * 2 * cs + 2 * c] = input[r][c] * (float)(1 - 2 * ((r + c) % 2));
                }
            }
        } else {
            for (int r = 0; r < Math.min(rs, input.length); ++r) {
                for (int c = 0; c < Math.min(cs, input[0].length); ++c) {
                    prepared[r * 2 * cs + 2 * c] = input[r][c];
                }
            }
        }
        return prepared;
    }

    public static void unprepareData(float[][] prepared, FImage output, boolean centre) {
        FourierTransform.unprepareData(prepared, output.pixels, centre);
    }

    public static void unprepareData(float[] prepared, FImage output, boolean centre) {
        FourierTransform.unprepareData(prepared, output.pixels, centre);
    }

    public static void unprepareData(float[][] prepared, float[][] output, boolean centre) {
        int rs = output.length;
        int cs = output[0].length;
        if (centre) {
            for (int r = 0; r < rs; ++r) {
                for (int c = 0; c < cs; ++c) {
                    output[r][c] = prepared[r][c * 2] * (float)(1 - 2 * ((r + c) % 2));
                }
            }
        } else {
            for (int r = 0; r < rs; ++r) {
                for (int c = 0; c < cs; ++c) {
                    output[r][c] = prepared[r][c * 2];
                }
            }
        }
    }

    public static void unprepareData(float[] prepared, float[][] output, boolean centre) {
        int rs = output.length;
        int cs = output[0].length;
        if (centre) {
            for (int r = 0; r < rs; ++r) {
                for (int c = 0; c < cs; ++c) {
                    output[r][c] = prepared[r * 2 * cs + 2 * c] * (float)(1 - 2 * ((r + c) % 2));
                }
            }
        } else {
            for (int r = 0; r < rs; ++r) {
                for (int c = 0; c < cs; ++c) {
                    output[r][c] = prepared[r * 2 * cs + 2 * c];
                }
            }
        }
    }

    private void process(FImage image) {
        int cs = image.getCols();
        int rs = image.getRows();
        this.phase = new FImage(cs, rs);
        this.magnitude = new FImage(cs, rs);
        FloatFFT_2D fft = new FloatFFT_2D(rs, cs);
        float[][] prepared = FourierTransform.prepareData(image.pixels, rs, cs, this.centre);
        fft.complexForward(prepared);
        for (int y = 0; y < rs; ++y) {
            for (int x = 0; x < cs; ++x) {
                float re = prepared[y][x * 2];
                float im = prepared[y][1 + x * 2];
                this.phase.pixels[y][x] = (float)Math.atan2(im, re);
                this.magnitude.pixels[y][x] = (float)Math.sqrt(re * re + im * im);
            }
        }
    }

    public FImage inverse() {
        int cs = this.magnitude.getCols();
        int rs = this.magnitude.getRows();
        FloatFFT_2D fft = new FloatFFT_2D(rs, cs);
        float[][] prepared = new float[rs][cs * 2];
        for (int y = 0; y < rs; ++y) {
            for (int x = 0; x < cs; ++x) {
                float p = this.phase.pixels[y][x];
                float m = this.magnitude.pixels[y][x];
                float re = (float)((double)m * Math.cos(p));
                float im = (float)((double)m * Math.sin(p));
                prepared[y][x * 2] = re;
                prepared[y][1 + x * 2] = im;
            }
        }
        fft.complexInverse(prepared, true);
        FImage image = new FImage(cs, rs);
        FourierTransform.unprepareData(prepared, image, this.centre);
        return image;
    }

    public FImage getLogNormalisedMagnitude() {
        FImage im = this.magnitude.clone();
        for (int y = 0; y < im.height; ++y) {
            for (int x = 0; x < im.width; ++x) {
                im.pixels[y][x] = (float)Math.log(im.pixels[y][x] + 1.0f);
            }
        }
        return im.normalise();
    }

    public FImage getPhase() {
        return this.phase;
    }

    public FImage getMagnitude() {
        return this.magnitude;
    }

    public boolean isCentre() {
        return this.centre;
    }
}

