/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.pyramid.gaussian;

import java.lang.reflect.Array;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.Octave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class GaussianOctave<IMAGE extends Image<?, IMAGE>>
extends Octave<GaussianPyramidOptions<IMAGE>, GaussianPyramid<IMAGE>, IMAGE> {
    public GaussianOctave(GaussianPyramid<IMAGE> parent, float octaveSize) {
        super(parent, octaveSize);
    }

    @Override
    public void process(IMAGE image) {
        this.images = (Image[])Array.newInstance(image.getClass(), ((GaussianPyramidOptions)this.options).scales + ((GaussianPyramidOptions)this.options).extraScaleSteps + 1);
        float k = (float)Math.pow(2.0, 1.0 / (double)((GaussianPyramidOptions)this.options).scales);
        this.images[0] = image;
        float prevSigma = ((GaussianPyramidOptions)this.options).initialSigma;
        for (int i = 1; i < ((GaussianPyramidOptions)this.options).scales + ((GaussianPyramidOptions)this.options).extraScaleSteps + 1; ++i) {
            this.images[i] = this.images[i - 1].clone();
            float increase = prevSigma * (float)Math.sqrt((double)(k * k) - 1.0);
            ((SinglebandImageProcessor.Processable)this.images[i]).processInplace(((GaussianPyramidOptions)this.options).createGaussianBlur(increase));
            prevSigma *= k;
        }
        if (((GaussianPyramidOptions)this.options).getOctaveProcessor() != null) {
            ((GaussianPyramidOptions)this.options).getOctaveProcessor().process(this);
        }
    }

    @Override
    public IMAGE getNextOctaveImage() {
        return (IMAGE)this.images[((GaussianPyramidOptions)this.options).scales];
    }
}

