/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.colour;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.combiner.ImageCombiner;

public class CIEDE2000
implements ImageCombiner<MBFImage, MBFImage, FImage> {
    public static double calculateDeltaE(double[] lab1, double[] lab2) {
        return CIEDE2000.calculateDeltaE(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2]);
    }

    public static float calculateDeltaE(float[] lab1, float[] lab2) {
        return (float)CIEDE2000.calculateDeltaE(lab1[0], lab1[1], lab1[2], lab2[0], lab2[1], lab2[2]);
    }

    public static float calculateDeltaE(Float[] lab1, Float[] lab2) {
        return (float)CIEDE2000.calculateDeltaE(lab1[0].floatValue(), lab1[1].floatValue(), lab1[2].floatValue(), lab2[0].floatValue(), lab2[1].floatValue(), lab2[2].floatValue());
    }

    public static double calculateDeltaE(double L1, double a1, double b1, double L2, double a2, double b2) {
        double Lmean = (L1 + L2) / 2.0;
        double C1 = Math.sqrt(a1 * a1 + b1 * b1);
        double C2 = Math.sqrt(a2 * a2 + b2 * b2);
        double Cmean = (C1 + C2) / 2.0;
        double G = (1.0 - Math.sqrt(Math.pow(Cmean, 7.0) / (Math.pow(Cmean, 7.0) + Math.pow(25.0, 7.0)))) / 2.0;
        double a1prime = a1 * (1.0 + G);
        double a2prime = a2 * (1.0 + G);
        double C1prime = Math.sqrt(a1prime * a1prime + b1 * b1);
        double C2prime = Math.sqrt(a2prime * a2prime + b2 * b2);
        double Cmeanprime = (C1prime + C2prime) / 2.0;
        double h1prime = Math.atan2(b1, a1prime) + Math.PI * 2 * (double)(Math.atan2(b1, a1prime) < 0.0 ? 1 : 0);
        double h2prime = Math.atan2(b2, a2prime) + Math.PI * 2 * (double)(Math.atan2(b2, a2prime) < 0.0 ? 1 : 0);
        double Hmeanprime = Math.abs(h1prime - h2prime) > Math.PI ? (h1prime + h2prime + Math.PI * 2) / 2.0 : (h1prime + h2prime) / 2.0;
        double T = 1.0 - 0.17 * Math.cos(Hmeanprime - 0.5235987755982988) + 0.24 * Math.cos(2.0 * Hmeanprime) + 0.32 * Math.cos(3.0 * Hmeanprime + 0.10471975511965977) - 0.2 * Math.cos(4.0 * Hmeanprime - 1.0995574287564276);
        double deltahprime = Math.abs(h1prime - h2prime) <= Math.PI ? h2prime - h1prime : (h2prime <= h1prime ? h2prime - h1prime + Math.PI * 2 : h2prime - h1prime - Math.PI * 2);
        double deltaLprime = L2 - L1;
        double deltaCprime = C2prime - C1prime;
        double deltaHprime = 2.0 * Math.sqrt(C1prime * C2prime) * Math.sin(deltahprime / 2.0);
        double SL = 1.0 + 0.015 * (Lmean - 50.0) * (Lmean - 50.0) / Math.sqrt(20.0 + (Lmean - 50.0) * (Lmean - 50.0));
        double SC = 1.0 + 0.045 * Cmeanprime;
        double SH = 1.0 + 0.015 * Cmeanprime * T;
        double deltaTheta = 0.5235987755982988 * Math.exp(-((57.29577951308232 * Hmeanprime - 275.0) / 25.0) * ((57.29577951308232 * Hmeanprime - 275.0) / 25.0));
        double RC = 2.0 * Math.sqrt(Math.pow(Cmeanprime, 7.0) / (Math.pow(Cmeanprime, 7.0) + Math.pow(25.0, 7.0)));
        double RT = -RC * Math.sin(2.0 * deltaTheta);
        double KL = 1.0;
        double KC = 1.0;
        double KH = 1.0;
        double deltaE = Math.sqrt(deltaLprime / (KL * SL) * (deltaLprime / (KL * SL)) + deltaCprime / (KC * SC) * (deltaCprime / (KC * SC)) + deltaHprime / (KH * SH) * (deltaHprime / (KH * SH)) + RT * (deltaCprime / (KC * SC)) * (deltaHprime / (KH * SH)));
        return deltaE;
    }

    public static FImage makeDisparityMap(MBFImage im1, MBFImage im2) {
        if (im1.colourSpace != ColourSpace.CIE_Lab) {
            im1 = ColourSpace.convert((MBFImage)im1, (ColourSpace)ColourSpace.CIE_Lab);
        }
        if (im2.colourSpace != ColourSpace.CIE_Lab) {
            im2 = ColourSpace.convert((MBFImage)im2, (ColourSpace)ColourSpace.CIE_Lab);
        }
        FImage disparity = new FImage(im1.getWidth(), im1.getHeight());
        for (int y = 0; y < disparity.height; ++y) {
            for (int x = 0; x < disparity.width; ++x) {
                disparity.pixels[y][x] = CIEDE2000.calculateDeltaE(im1.getPixel(x, y), im2.getPixel(x, y));
            }
        }
        return disparity;
    }

    public FImage combine(MBFImage image1, MBFImage image2) {
        return CIEDE2000.makeDisparityMap(image2, image2);
    }
}

