/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.math.geometry.shape.Rectangle;

public class SummedAreaTable
implements ImageAnalyser<FImage> {
    public FImage data;

    public SummedAreaTable() {
    }

    public SummedAreaTable(FImage image) {
        this.computeTable(image);
    }

    protected void computeTable(FImage image) {
        this.data = new FImage(image.width + 1, image.height + 1);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                this.data.pixels[y + 1][x + 1] = image.pixels[y][x] + this.data.pixels[y + 1][x] + this.data.pixels[y][x + 1] - this.data.pixels[y][x];
            }
        }
    }

    public float calculateArea(int x1, int y1, int x2, int y2) {
        float A = this.data.pixels[y1][x1];
        float B = this.data.pixels[y1][x2];
        float C = this.data.pixels[y2][x2];
        float D = this.data.pixels[y2][x1];
        return A + C - B - D;
    }

    public float calculateArea(Rectangle r) {
        return this.calculateArea(Math.round(r.x), Math.round(r.y), Math.round(r.x + r.width), Math.round(r.y + r.height));
    }

    public void analyseImage(FImage image) {
        this.computeTable(image);
    }
}

