/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.feature.MultidimensionalDoubleFV;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processing.edges.CannyEdgeDetector2;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.statistics.distribution.Histogram;

public class EdgeDirectionCoherenceVector
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    private EdgeDirectionCoherenceHistogram coDirHist = null;
    private int numberOfDirBins = 72;
    private float directionThreshold = 360 / this.numberOfDirBins;
    private ConnectedComponent.ConnectMode mode = ConnectedComponent.ConnectMode.CONNECT_8;
    private double coherenceFactor = 2.0E-5;
    private CannyEdgeDetector2 cannyEdgeDetector = new CannyEdgeDetector2();

    public int getNumberOfDirBins() {
        return this.numberOfDirBins;
    }

    public void setNumberOfBins(int nb) {
        this.numberOfDirBins = nb;
        this.directionThreshold = 360 / this.numberOfDirBins;
    }

    public EdgeDirectionCoherenceHistogram getLastHistogram() {
        return this.coDirHist;
    }

    public void analyseImage(FImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        FImage edgeImage = image.clone();
        this.cannyEdgeDetector.processImage(edgeImage);
        float[] mags = this.cannyEdgeDetector.getMagnitude();
        float[] dirs = this.cannyEdgeDetector.getOrientation();
        if (mags == null || dirs == null) {
            System.out.println("Canny Edge Detector did not return magnitude or direction.");
        }
        int numberOfBins = this.numberOfDirBins + 1;
        double[] dirHist = new double[numberOfBins];
        int nonEdgeCount = 0;
        for (int y = 0; y < edgeImage.getHeight(); ++y) {
            for (int x = 0; x < edgeImage.getWidth(); ++x) {
                if (edgeImage.getPixel(x, y).floatValue() != 0.0f) continue;
                ++nonEdgeCount;
            }
        }
        dirHist[0] = nonEdgeCount;
        FImage directionImage = new FImage(w, h);
        for (int j = 0; j < w * h; ++j) {
            int x = j % w;
            int y = j / w;
            if (edgeImage.getPixel(x, y).floatValue() > 0.0f) {
                int dirBin = (int)((dirs[j] + 180.0f) * (float)this.numberOfDirBins / 360.0f) % this.numberOfDirBins;
                int n = dirBin + 1;
                dirHist[n] = dirHist[n] + 1.0;
                float v = dirs[j] + 180.0f;
                directionImage.setPixel(x, y, Float.valueOf(v));
                continue;
            }
            directionImage.setPixel(x, y, Float.valueOf(-1.0f));
        }
        int numberOfEdgePix = w * h - nonEdgeCount;
        for (int j = 0; j < this.numberOfDirBins; ++j) {
            int n = j + 1;
            dirHist[n] = dirHist[n] / (double)numberOfEdgePix;
        }
        dirHist[0] = dirHist[0] / (double)(w * h);
        this.coDirHist = new EdgeDirectionCoherenceHistogram();
        this.coDirHist.coherentHistogram = new Histogram(this.numberOfDirBins);
        this.coDirHist.incoherentHistogram = new Histogram(this.numberOfDirBins);
        FImage outputImage = new FImage(w, h);
        for (int j = 0; j < w * h; ++j) {
            int x = j % w;
            int y = j / w;
            float p = directionImage.getPixel(x, y).floatValue();
            if (p == -1.0f) continue;
            List<Point2d> v = this.getConnectedEdges(x, y, w, h, p, numberOfBins, directionImage, dirs, this.mode);
            int dirBin = (int)((dirs[j] + 180.0f) * (float)this.numberOfDirBins / 360.0f) % this.numberOfDirBins;
            boolean isCoherent = false;
            if ((double)v.size() > (double)(w * h) * this.coherenceFactor) {
                for (int k = 0; k < v.size(); ++k) {
                    Point2d pp = v.get(k);
                    outputImage.setPixel(Math.round(pp.getX()), Math.round(pp.getY()), Float.valueOf(1.0f));
                }
                isCoherent = true;
            }
            if (isCoherent) {
                double[] dArray = (double[])this.coDirHist.coherentHistogram.values;
                int n = dirBin;
                dArray[n] = dArray[n] + (double)v.size();
                continue;
            }
            double[] dArray = (double[])this.coDirHist.incoherentHistogram.values;
            int n = dirBin;
            dArray[n] = dArray[n] + (double)v.size();
        }
        image.internalAssign(outputImage);
    }

    private List<Point2d> getConnectedEdges(int xx, int yy, int w, int h, float p, int numberOfBins, FImage edgeImage, float[] dirs, ConnectedComponent.ConnectMode connectedness) {
        ArrayList<Point2d> v = new ArrayList<Point2d>();
        v.add((Point2d)new Point2dImpl((float)xx, (float)yy));
        edgeImage.setPixel(xx, yy, Float.valueOf(-1.0f));
        float dir = dirs[yy * w + xx];
        boolean connected = true;
        int x = xx;
        int y = yy;
        while (connected) {
            int nx = x;
            int ny = y;
            switch (connectedness) {
                case CONNECT_4: {
                    nx = x + 1;
                    ny = y;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x;
                    ny = y + 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x - 1;
                    ny = y;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x;
                    ny = y - 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x;
                    ny = y;
                    break;
                }
                case CONNECT_8: {
                    nx = x + 1;
                    ny = y - 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x + 1;
                    ny = y;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x + 1;
                    ny = y + 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x;
                    ny = y + 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x - 1;
                    ny = y + 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x - 1;
                    ny = y;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x - 1;
                    ny = y - 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x;
                    ny = y - 1;
                    if (nx >= 0 && ny >= 0 && nx < w && ny < h && dirs[ny * w + nx] < dir + this.directionThreshold && dirs[ny * w + nx] > dir - this.directionThreshold && edgeImage.getPixel(nx, ny).floatValue() != -1.0f) break;
                    nx = x;
                    ny = y;
                }
            }
            if (nx >= 0 && nx != x || ny >= 0 && ny != y) {
                v.add((Point2d)new Point2dImpl((float)nx, (float)ny));
                edgeImage.setPixel(nx, ny, Float.valueOf(-1.0f));
                x = nx;
                y = ny;
                continue;
            }
            connected = false;
        }
        return v;
    }

    public EdgeDirectionCoherenceHistogram getHistogram() {
        return this.coDirHist;
    }

    public DoubleFV getFeatureVector() {
        return this.coDirHist.asMultidimensionalDoubleFV();
    }

    public CannyEdgeDetector2 getCannyEdgeDetector() {
        return this.cannyEdgeDetector;
    }

    public double getCoherenceFactor() {
        return this.coherenceFactor;
    }

    public void setCoherenceFactor(double coherenceFactor) {
        this.coherenceFactor = coherenceFactor;
    }

    public class EdgeDirectionCoherenceHistogram {
        public Histogram coherentHistogram = null;
        public Histogram incoherentHistogram = null;

        public DoubleFV asDoubleFV() {
            double[] d = new double[((double[])this.coherentHistogram.values).length + ((double[])this.incoherentHistogram.values).length];
            int i = 0;
            for (double dd : this.coherentHistogram.asDoubleVector()) {
                d[i++] = dd;
            }
            for (double dd : this.incoherentHistogram.asDoubleVector()) {
                d[i++] = dd;
            }
            return new DoubleFV(d);
        }

        public MultidimensionalDoubleFV asMultidimensionalDoubleFV() {
            double[][] d = new double[2][((double[])this.coherentHistogram.values).length];
            int i = 0;
            for (double dd : this.coherentHistogram.asDoubleVector()) {
                d[0][i++] = dd;
            }
            i = 0;
            for (double dd : this.incoherentHistogram.asDoubleVector()) {
                d[1][i++] = dd;
            }
            return new MultidimensionalDoubleFV(d);
        }
    }
}

