/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.geocode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeonamesIndexGenerator {
    private static Logger log = LoggerFactory.getLogger(GeonamesIndexGenerator.class);
    private static String DELIMITER = "\t";
    private static int BATCH_SIZE = 20000;
    private static String SOLR_CONFIG = "solrconfig.xml";
    private static String SOLR_SCHEMA = "schema.xml";
    private BufferedReader reader;
    private DateFormat dateFormat;
    private static final Map<String, Integer> columns = new LinkedHashMap<String, Integer>();
    private SolrCore solrCore;
    private CoreContainer solrContainer;
    private EmbeddedSolrServer solrServer;

    public GeonamesIndexGenerator(File sourceFile) throws Exception {
        FileInputStream inStream = null;
        InputStreamReader fileReader = null;
        try {
            inStream = new FileInputStream(sourceFile);
        }
        catch (IOException ex) {
            log.error("Error opening file stream!");
            throw new Exception(ex);
        }
        try {
            fileReader = new InputStreamReader((InputStream)inStream, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            try {
                ((InputStream)inStream).close();
            }
            catch (IOException ioex) {
                log.error("Failed closing input stream");
            }
            log.error("Error starting file reader!");
            throw new Exception(ex);
        }
        this.reader = new BufferedReader(fileReader);
        String solrHome = System.getProperty("geonames.solr.home");
        if (solrHome == null) {
            throw new Exception("No 'geonames.solr.home' provided!");
        }
        File solrHomeFile = new File(solrHome);
        if (!solrHomeFile.exists()) {
            solrHomeFile.mkdirs();
            File confDir = new File(solrHomeFile, "conf");
            confDir.mkdirs();
            FileUtils.copyInputStreamToFile((InputStream)GeonamesIndexGenerator.class.getResourceAsStream(SOLR_CONFIG), (File)new File(confDir, SOLR_CONFIG));
            FileUtils.copyInputStreamToFile((InputStream)GeonamesIndexGenerator.class.getResourceAsStream(SOLR_SCHEMA), (File)new File(confDir, SOLR_SCHEMA));
        }
        this.solrServer = this.startSolr(solrHome);
    }

    private EmbeddedSolrServer startSolr(String home) throws Exception {
        try {
            SolrConfig solrConfig = new SolrConfig(home, SOLR_CONFIG, null);
            IndexSchema schema = new IndexSchema(solrConfig, SOLR_SCHEMA, null);
            this.solrContainer = new CoreContainer(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
            CoreDescriptor descriptor = new CoreDescriptor(this.solrContainer, "", solrConfig.getResourceLoader().getInstanceDir());
            descriptor.setConfigName(solrConfig.getResourceName());
            descriptor.setSchemaName(schema.getResourceName());
            this.solrCore = new SolrCore(null, solrConfig.getDataDir(), solrConfig, schema, descriptor);
            this.solrContainer.register("cheese", this.solrCore, false);
            return new EmbeddedSolrServer(this.solrContainer, "cheese");
        }
        catch (Exception ex) {
            log.error("\nFailed to start Solr server\n");
            throw ex;
        }
    }

    private Date now() {
        return new Date();
    }

    private String time() {
        return this.time(this.now());
    }

    private String time(Date date) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("HH:mm:ss");
        }
        return this.dateFormat.format(date);
    }

    private String get(String[] data, String field) {
        Integer index = columns.get(field);
        if (index == null) {
            log.error("Field does not exist: {}", (Object)field);
            return null;
        }
        return data[index];
    }

    private void commit() {
        try {
            this.solrServer.commit();
        }
        catch (Exception ex) {
            log.error("Failed to commit: ", (Throwable)ex);
        }
    }

    private void optimize() {
        try {
            this.solrServer.optimize();
        }
        catch (Exception ex) {
            log.error("Failed to commit: ", (Throwable)ex);
        }
    }

    public int loop(int counter, boolean print) throws Exception {
        String line = null;
        int i = 0;
        try {
            while (i < counter && (line = this.reader.readLine()) != null) {
                String[] row = line.split(DELIMITER);
                ++i;
                if (print) {
                    log.debug("====================");
                    log.debug("Line: {}", (Object)i);
                }
                this.process(row, print);
            }
        }
        catch (IOException ex) {
            throw new Exception(ex);
        }
        return i;
    }

    private boolean empty(String input) {
        return input == null || input.equals("") || input.equals(" ");
    }

    private void process(String[] row, boolean print) {
        if (print) {
            for (String key : columns.keySet()) {
                System.out.format("%17s => %20s\n", key, this.get(row, key));
            }
        }
        try {
            this.solrServer.add(this.createSolrDoc(row));
        }
        catch (Exception ex) {
            log.error("Failed to add document:");
            for (String key : columns.keySet()) {
                System.out.format("%17s => %20s\n", key, this.get(row, key));
            }
            log.error("Stack trace: ", (Throwable)ex);
        }
    }

    private SolrInputDocument createSolrDoc(String[] row) {
        float boost = 1.0f;
        SolrInputDocument doc = new SolrInputDocument();
        for (String key : columns.keySet()) {
            String data = this.get(row, key);
            if (key.equals("date_modified")) {
                data = data + "T00:00:00Z";
            }
            if (key.equals("basic_name")) {
                if (this.empty(data)) {
                    data = this.get(row, "utf8_name");
                }
                String string = data.toLowerCase();
                doc.addField("basic_name_str", (Object)string);
                String rev = new StringBuffer(string).reverse().toString();
                doc.addField("basic_name_rev", (Object)rev);
            }
            if (key.equals("alternames")) {
                String[] parts = data.split(",");
                doc.addField("alternames", (Object)parts);
            }
            if (key.equals("feature_code") && data.startsWith("PPL")) {
                boost *= 2.0f;
            }
            if (this.empty(data)) continue;
            doc.addField(key, (Object)data);
        }
        doc.addField("boost", (Object)"boost", boost);
        return doc;
    }

    public void shutdown() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error shutting down the Reader!", (Throwable)ex);
            }
        }
        if (this.solrContainer != null) {
            this.solrContainer.shutdown();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            log.error("ERROR: Usage requires input file!");
            return;
        }
        File file = new File(args[0]);
        if (file == null || !file.exists()) {
            log.error("ERROR: The input file does not exist!");
            return;
        }
        GeonamesIndexGenerator harvester = null;
        try {
            harvester = new GeonamesIndexGenerator(file);
        }
        catch (Exception ex) {
            log.error("Stack trace: ", (Throwable)ex);
        }
        log.debug("\n\n===================\n\n");
        Date start = harvester.now();
        int count = 0;
        try {
            for (int i = 0; i < 500; ++i) {
                int read = harvester.loop(BATCH_SIZE, false);
                log.info("{}: Rows read: {}", (Object)harvester.time(), (Object)(count += read));
                try {
                    harvester.commit();
                }
                catch (Exception ex) {
                    log.info("Commit failed: {}", (Object)harvester.time());
                    log.error("Stack trace: ", (Throwable)ex);
                }
                if (read == BATCH_SIZE) {
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            log.error("ERROR: An error occurred in the processing loop: ", (Throwable)ex);
        }
        Date finish = harvester.now();
        float duration = (float)(finish.getTime() - start.getTime()) / 1000.0f;
        log.info("\n\nTotal time for execution: {}", (Object)Float.valueOf(duration));
        log.info("Total records processed: {}", (Object)count);
        if (count == 0) {
            log.info("Average records per second: 0");
        } else {
            float speed = (float)count / duration;
            log.info("Average records per second: {}", (Object)Float.valueOf(speed));
        }
        try {
            harvester.commit();
            log.info("\n{}: Index optimize...", (Object)harvester.time());
            harvester.optimize();
            log.info("{}: ... completed", (Object)harvester.time());
        }
        catch (Exception ex) {
            log.info("{}: ... failed", (Object)harvester.time());
            log.error("Stack trace: ", (Throwable)ex);
        }
        log.info("\n\n===================\n\n");
        harvester.shutdown();
    }

    static {
        columns.put("id", 0);
        columns.put("utf8_name", 1);
        columns.put("basic_name", 2);
        columns.put("alternames", 3);
        columns.put("latitude", 4);
        columns.put("longitude", 5);
        columns.put("feature_class", 6);
        columns.put("feature_code", 7);
        columns.put("country_code", 8);
        columns.put("population", 14);
        columns.put("elevation", 15);
        columns.put("gtopo30", 16);
        columns.put("timezone", 17);
        columns.put("date_modified", 18);
    }
}

