/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.openimaj.hadoop.sequencefile.SequenceFileUtility;

public final class TextBytesSequenceFileUtility
extends SequenceFileUtility<Text, BytesWritable> {
    public TextBytesSequenceFileUtility(String uriOrPath, boolean read) throws IOException {
        super(uriOrPath, read);
    }

    public TextBytesSequenceFileUtility(String uriOrPath, SequenceFile.CompressionType compressionType, Map<String, String> metadata) throws IOException {
        super(uriOrPath, compressionType, metadata);
    }

    public TextBytesSequenceFileUtility(String uriOrPath, SequenceFile.CompressionType compressionType) throws IOException {
        super(uriOrPath, compressionType);
    }

    public TextBytesSequenceFileUtility(URI uri, boolean read) throws IOException {
        super(uri, read);
    }

    public TextBytesSequenceFileUtility(URI uri, SequenceFile.CompressionType compressionType, Map<String, String> metadata) throws IOException {
        super(uri, compressionType, metadata);
    }

    public TextBytesSequenceFileUtility(URI uri, SequenceFile.CompressionType compressionType) throws IOException {
        super(uri, compressionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BytesWritable readFile(FileSystem fs, Path path) throws IOException {
        FSDataInputStream dis = null;
        ByteArrayOutputStream baos = null;
        try {
            dis = fs.open(path);
            baos = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)dis, (OutputStream)baos, (Configuration)this.config, (boolean)false);
            byte[] bytes = baos.toByteArray();
            BytesWritable bytesWritable = new BytesWritable(bytes);
            return bytesWritable;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeFile(FileSystem fs, Path path, BytesWritable value) throws IOException {
        FSDataOutputStream dos = null;
        try {
            dos = fs.create(path);
            byte[] bytes = new byte[value.getLength()];
            System.arraycopy(value.getBytes(), 0, bytes, 0, bytes.length);
            dos.write(bytes);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void printFile(BytesWritable value) throws IOException {
        System.out.write(value.getBytes());
    }

    @Override
    protected void writeZipData(ZipOutputStream zos, BytesWritable value) throws IOException {
        zos.write(value.getBytes(), 0, value.getLength());
    }
}

