/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.sequencefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.openimaj.hadoop.sequencefile.ExtractionState;
import org.openimaj.hadoop.sequencefile.KeyValueDump;
import org.openimaj.hadoop.sequencefile.NamingStrategy;
import org.openimaj.hadoop.sequencefile.RecordInformationExtractor;

public abstract class SequenceFileUtility<K extends Writable, V extends Writable>
implements Iterable<Map.Entry<K, V>> {
    protected Configuration config = new Configuration();
    protected FileSystem fileSystem;
    protected Path sequenceFilePath;
    protected SequenceFile.Writer writer;
    protected SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.BLOCK;
    protected boolean isReader;
    protected String uuid;

    public SequenceFileUtility(String uriOrPath, boolean read) throws IOException {
        this.setup(SequenceFileUtility.convertToURI(uriOrPath), read);
    }

    public SequenceFileUtility(URI uri, boolean read) throws IOException {
        this.setup(uri, read);
    }

    public SequenceFileUtility(String uriOrPath, SequenceFile.CompressionType compressionType) throws IOException {
        this.compressionType = compressionType;
        this.setup(SequenceFileUtility.convertToURI(uriOrPath), false);
    }

    public SequenceFileUtility(URI uri, SequenceFile.CompressionType compressionType) throws IOException {
        this.compressionType = compressionType;
        this.setup(uri, false);
    }

    public static URI[] getReducerFiles(String uriOrPath) throws IOException {
        return SequenceFileUtility.getFiles(uriOrPath, "part-r-");
    }

    public static URI[] getFiles(String uriOrPath, final String filenamePrefix) throws IOException {
        Path path;
        Configuration config = new Configuration();
        URI uri = SequenceFileUtility.convertToURI(uriOrPath);
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)config);
        if (fs.getFileStatus(path = new Path(uri.toString())).isDirectory()) {
            FileStatus[] files = fs.listStatus(path, new PathFilter(){

                public boolean accept(Path p) {
                    return p.getName().startsWith(filenamePrefix);
                }
            });
            URI[] uris = new URI[files.length];
            int i = 0;
            for (FileStatus status : files) {
                uris[i++] = status.getPath().toUri();
            }
            return uris;
        }
        return new URI[]{uri};
    }

    public static Path[] getFilePaths(String[] uriOrPaths, String filenamePrefix) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (String uriOrPath : uriOrPaths) {
            Path[] paths;
            for (Path path : paths = SequenceFileUtility.getFilePaths(uriOrPath, filenamePrefix)) {
                pathList.add(path);
            }
        }
        return pathList.toArray(new Path[pathList.size()]);
    }

    public static Path[] getFilePaths(String[] uriOrPaths, String subdir, String filenamePrefix) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (String uriOrPath : uriOrPaths) {
            Path[] paths;
            if (subdir != null) {
                uriOrPath = uriOrPath + "/" + subdir;
            }
            for (Path path : paths = SequenceFileUtility.getFilePaths(uriOrPath, filenamePrefix)) {
                pathList.add(path);
            }
        }
        return pathList.toArray(new Path[pathList.size()]);
    }

    public static Path[] getFilePaths(String uriOrPath, final String filenamePrefix) throws IOException {
        Path path;
        Configuration config = new Configuration();
        URI uri = SequenceFileUtility.convertToURI(uriOrPath);
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)config);
        if (fs.getFileStatus(path = new Path(uri)).isDirectory()) {
            FileStatus[] files = fs.listStatus(path, new PathFilter(){

                public boolean accept(Path p) {
                    return p.getName().startsWith(filenamePrefix);
                }
            });
            Path[] uris = new Path[files.length];
            int i = 0;
            for (FileStatus status : files) {
                uris[i++] = status.getPath();
            }
            return uris;
        }
        return new Path[]{path};
    }

    public static URI[] getFilesRegex(String uriOrPath, final String regex) throws IOException {
        Path path;
        Configuration config = new Configuration();
        URI uri = SequenceFileUtility.convertToURI(uriOrPath);
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)config);
        if (fs.getFileStatus(path = new Path(uri.toString())).isDirectory()) {
            FileStatus[] files = fs.listStatus(path, new PathFilter(){

                public boolean accept(Path p) {
                    return regex == null || p.getName().matches(regex);
                }
            });
            URI[] uris = new URI[files.length];
            int i = 0;
            for (FileStatus status : files) {
                uris[i++] = status.getPath().toUri();
            }
            return uris;
        }
        return new URI[]{uri};
    }

    public Map<K, Long> listKeysAndOffsets() {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            LinkedHashMap<Writable, Long> keys = new LinkedHashMap<Writable, Long>();
            reader = this.createReader();
            Class keyClass = reader.getKeyClass();
            Writable key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.config);
            Writable val = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.config);
            long start = 0L;
            long end = 0L;
            while (reader.next(key, val)) {
                long pos = reader.getPosition();
                if (pos != end) {
                    start = end;
                    end = pos;
                }
                keys.put(key, start);
                key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.config);
            }
            LinkedHashMap<Writable, Long> linkedHashMap = keys;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void extract(List<RecordInformationExtractor> extractors, PrintStream stream, String delim) {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            reader = this.createReader();
            Class keyClass = reader.getKeyClass();
            Writable key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.config);
            Writable val = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.config);
            long start = 0L;
            long end = 0L;
            int count = 0;
            while (reader.next(key, val)) {
                long pos = reader.getPosition();
                if (pos != end) {
                    start = end;
                    end = pos;
                }
                String recordString = "";
                for (RecordInformationExtractor extractor : extractors) {
                    recordString = recordString + extractor.extract(key, val, start, this.sequenceFilePath) + delim;
                }
                if (recordString.length() >= delim.length()) {
                    recordString = recordString.substring(0, recordString.length() - delim.length());
                }
                stream.println(recordString);
                System.err.printf("\rOutputted: %10d", ++count);
                key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.config);
            }
            System.err.println();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public SequenceFileUtility(String uriOrPath, SequenceFile.CompressionType compressionType, Map<String, String> metadata) throws IOException {
        this.compressionType = compressionType;
        this.setup(SequenceFileUtility.convertToURI(uriOrPath), false);
    }

    public SequenceFileUtility(URI uri, SequenceFile.CompressionType compressionType, Map<String, String> metadata) throws IOException {
        this.compressionType = compressionType;
        this.setup(uri, false);
    }

    public static URI convertToURI(String uriOrPath) {
        if (uriOrPath.contains("://")) {
            return URI.create(uriOrPath);
        }
        return new File(uriOrPath).toURI();
    }

    private void setup(URI uri, boolean read) throws IOException {
        this.setup(uri, read, null);
    }

    private void setup(URI uri, boolean read, Map<String, String> metadata) throws IOException {
        this.fileSystem = this.getFileSystem(uri);
        this.sequenceFilePath = new Path(uri.toString());
        this.isReader = read;
        if (read) {
            SequenceFile.Reader reader = null;
            try {
                reader = this.createReader();
                Text uuidText = reader.getMetadata().get(new Text("UUID"));
                if (uuidText != null) {
                    this.uuid = uuidText.toString();
                }
                if (!reader.isCompressed()) {
                    this.compressionType = SequenceFile.CompressionType.NONE;
                }
                if (reader.isBlockCompressed()) {
                    this.compressionType = SequenceFile.CompressionType.BLOCK;
                }
                this.compressionType = SequenceFile.CompressionType.RECORD;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            if (metadata == null) {
                metadata = new HashMap<String, String>();
            }
            if (!metadata.containsKey("UUID")) {
                this.uuid = UUID.randomUUID().toString();
                metadata.put("UUID", this.uuid);
            }
            if (this.fileSystem.exists(this.sequenceFilePath) && this.fileSystem.getFileStatus(this.sequenceFilePath).isDirectory()) {
                this.sequenceFilePath = new Path(this.sequenceFilePath, this.uuid + ".seq");
            }
            this.writer = this.createWriter(metadata);
        }
    }

    private SequenceFile.Writer createWriter(Map<String, String> metadata) throws IOException {
        SequenceFile.Metadata md = new SequenceFile.Metadata();
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            md.set(new Text(e.getKey()), new Text(e.getValue()));
        }
        Class keyClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Class valueClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        return SequenceFile.createWriter((FileSystem)this.fileSystem, (Configuration)this.config, (Path)this.sequenceFilePath, (Class)keyClass, (Class)valueClass, (SequenceFile.CompressionType)this.compressionType, (CompressionCodec)new DefaultCodec(), null, (SequenceFile.Metadata)md);
    }

    private SequenceFile.Reader createReader() throws IOException {
        return new SequenceFile.Reader(this.fileSystem, this.sequenceFilePath, this.config);
    }

    public String getUUID() {
        return this.uuid;
    }

    public Map<Text, Text> getMetadata() {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read metadata in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            TreeMap metadata;
            reader = this.createReader();
            TreeMap treeMap = metadata = reader.getMetadata().getMetadata();
            return treeMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<K> listKeys() {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            ArrayList<Writable> keys = new ArrayList<Writable>();
            reader = this.createReader();
            Class keyClass = reader.getKeyClass();
            Writable key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.config);
            while (reader.next(key)) {
                keys.add(key);
                key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.config);
            }
            ArrayList<Writable> arrayList = keys;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportData(String uriOrPath) throws IOException {
        this.exportData(uriOrPath, NamingStrategy.KEY, new ExtractionState(), false, 0L);
    }

    public void exportData(String uriOrPath, NamingStrategy naming, ExtractionState extrState, boolean addExtension, long offset) throws IOException {
        FileSystem fs = null;
        Path p = null;
        if (uriOrPath != null) {
            URI uri = SequenceFileUtility.convertToURI(uriOrPath);
            fs = this.getFileSystem(uri);
            p = new Path(uri.toString());
        }
        this.exportData(fs, p, naming, extrState, addExtension, offset);
    }

    public static ZipOutputStream openZipOutputStream(String uriOrPath) throws IOException {
        URI uri = SequenceFileUtility.convertToURI(uriOrPath);
        FileSystem fs = SequenceFileUtility.getFileSystem(uri, new Configuration());
        Path path = new Path(uri.toString());
        ZipOutputStream zos = new ZipOutputStream((OutputStream)fs.create(path));
        zos.setLevel(9);
        return zos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDataToZip(String uriOrPath, NamingStrategy naming, ExtractionState state, boolean addExtension, long offset) throws IOException {
        if (uriOrPath != null) {
            ZipOutputStream zos = null;
            try {
                zos = SequenceFileUtility.openZipOutputStream(uriOrPath);
                this.exportDataToZip(zos, naming, state, addExtension, offset);
            }
            finally {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void exportDataToZip(ZipOutputStream zos, NamingStrategy naming, ExtractionState extrState, boolean addExtension, long offset) throws IOException {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            reader = this.createReader();
            if (offset > 0L) {
                reader.seek(offset);
            }
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.config);
            Writable val = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.config);
            while (reader.next(key)) {
                if (extrState.allowNext()) {
                    reader.getCurrentValue(val);
                    String name = naming.getName(key, val, extrState, addExtension);
                    while (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    ZipEntry ze = new ZipEntry(name);
                    zos.putNextEntry(ze);
                    this.writeZipData(zos, val);
                    zos.closeEntry();
                    extrState.tick();
                } else {
                    extrState.tick();
                }
                if (!extrState.isFinished()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportData(FileSystem fs, Path dirPath) {
        this.exportData(fs, dirPath, NamingStrategy.KEY, new ExtractionState(), false, 0L);
    }

    public void exportData(FileSystem fs, Path dirPath, NamingStrategy naming, ExtractionState extrState, boolean addExtension, long offset) {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            if (fs != null) {
                fs.mkdirs(dirPath);
            }
            reader = this.createReader();
            if (offset > 0L) {
                reader.seek(offset);
            }
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.config);
            Writable val = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.config);
            while (reader.next(key)) {
                if (extrState.allowNext()) {
                    reader.getCurrentValue(val);
                    if (dirPath != null) {
                        String name = naming.getName(key, val, extrState, addExtension);
                        if (name.startsWith("/")) {
                            name = "." + name;
                        }
                        Path outFilePath = new Path(dirPath, name);
                        System.out.println("Path: " + outFilePath);
                        this.writeFile(fs, outFilePath, val);
                        extrState.tick();
                    } else {
                        System.out.println(key.toString());
                        this.printFile(val);
                        extrState.tick();
                    }
                } else {
                    extrState.tick();
                }
                if (!extrState.isFinished()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportData(NamingStrategy np, ExtractionState nps, long offset, KeyValueDump<K, V> dump) {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            reader = this.createReader();
            if (offset > 0L) {
                reader.seek(offset);
            }
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.config);
            Writable val = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.config);
            while (reader.next(key)) {
                if (nps.allowNext()) {
                    reader.getCurrentValue(val);
                    dump.dumpValue(key, val);
                }
                nps.tick();
                if (!nps.isFinished()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public long getNumberRecords() {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot read keys in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            reader = this.createReader();
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.config);
            long count = 0L;
            while (reader.next(key)) {
                ++count;
            }
            long l = count;
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Class<? extends CompressionCodec> getCompressionCodecClass() {
        if (!this.isReader) {
            return DefaultCodec.class;
        }
        SequenceFile.Reader reader = null;
        try {
            reader = this.createReader();
            if (reader.getCompressionCodec() == null) {
                Class<? extends CompressionCodec> clazz = null;
                return clazz;
            }
            Class<?> clazz = reader.getCompressionCodec().getClass();
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public SequenceFile.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public FileSystem getFileSystem(URI uri) throws IOException {
        return SequenceFileUtility.getFileSystem(uri, this.config);
    }

    public static FileSystem getFileSystem(URI uri, Configuration config) throws IOException {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)config);
        if (fs instanceof LocalFileSystem) {
            fs = ((LocalFileSystem)fs).getRaw();
        }
        return fs;
    }

    public Path getPath(URI uri) throws IOException {
        return new Path(uri.toString());
    }

    public static String md5sum(FileSystem fs, Path p) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RuntimeException(e1);
        }
        InputStream is = null;
        try {
            byte[] buffer = new byte[8192];
            int read = 0;
            is = fs.open(p);
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String string = bigInt.toString(16);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract V readFile(FileSystem var1, Path var2) throws IOException;

    protected abstract void writeFile(FileSystem var1, Path var2, V var3) throws IOException;

    protected abstract void writeZipData(ZipOutputStream var1, V var2) throws IOException;

    protected abstract void printFile(V var1) throws IOException;

    public void appendFile(K key, FileSystem fs, Path p) throws IOException {
        if (this.isReader) {
            throw new UnsupportedOperationException("Cannot write data in read mode");
        }
        this.writer.append(key, this.readFile(fs, p));
    }

    public void appendData(K key, V value) throws IOException {
        if (this.isReader) {
            throw new UnsupportedOperationException("Cannot write data in read mode");
        }
        this.writer.append(key, value);
    }

    public Map<Path, K> appendFiles(FileSystem fs, Path path, boolean recurse, PathFilter pathFilter, KeyProvider<K> keyProvider) throws IOException {
        LinkedHashMap addedFiles = new LinkedHashMap();
        this.appendFiles(fs, path, recurse, pathFilter, keyProvider, addedFiles);
        return addedFiles;
    }

    private void appendFiles(final FileSystem fs, Path path, boolean recurse, PathFilter pathFilter, KeyProvider<K> keyProvider, Map<Path, K> addedFiles) throws IOException {
        if (fs.isFile(path)) {
            if (pathFilter == null || pathFilter.accept(path)) {
                Writable key = (Writable)keyProvider.getKey(fs, path);
                this.appendFile(key, fs, path);
                addedFiles.put(path, (Path)key);
            }
        } else if (recurse) {
            FileStatus[] status;
            for (FileStatus stat : status = fs.listStatus(path, new PathFilter(){

                public boolean accept(Path potential) {
                    try {
                        fs.getStatus(potential);
                        return true;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            })) {
                this.appendFiles(fs, stat.getPath(), path.getParent(), pathFilter, keyProvider, addedFiles);
            }
        }
    }

    private void appendFiles(FileSystem fs, Path path, Path base, PathFilter pathFilter, KeyProvider<K> keyProvider, Map<Path, K> addedFiles) throws IOException {
        if (fs.isFile(path)) {
            if (pathFilter == null || pathFilter.accept(path)) {
                Writable key = (Writable)keyProvider.getKey(fs, path, base);
                this.appendFile(key, fs, path);
                addedFiles.put(path, (Path)key);
            }
        } else {
            try {
                FileStatus[] status;
                for (FileStatus stat : status = fs.listStatus(path)) {
                    this.appendFiles(fs, stat.getPath(), base, pathFilter, keyProvider, addedFiles);
                }
            }
            catch (Throwable e) {
                System.err.println("Failed listing status on path: " + path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePathMap(Map<Path, K> map) throws IOException {
        Path p = new Path(this.sequenceFilePath.getParent(), this.sequenceFilePath.getName().substring(0, this.sequenceFilePath.getName().lastIndexOf(".")) + "-map.txt");
        FSDataOutputStream dos = null;
        PrintWriter pw = null;
        try {
            dos = this.fileSystem.create(p);
            pw = new PrintWriter((OutputStream)dos);
            for (Map.Entry<Path, K> e : map.entrySet()) {
                pw.println(e.getValue() + " " + e.getKey());
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V find(K queryKey, long offset) {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot find key in write mode");
        }
        SequenceFile.Reader reader = null;
        try {
            reader = this.createReader();
            if (offset > 0L) {
                reader.seek(offset);
            }
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.config);
            while (reader.next(key)) {
                if (!key.equals(queryKey)) continue;
                Writable val = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.config);
                reader.getCurrentValue(val);
                Writable writable = val;
                return (V)writable;
            }
            V v = null;
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public V find(K queryKey) {
        return this.find(queryKey, 0L);
    }

    public boolean findAndExport(K key, String uriOrPath, long offset) throws IOException {
        FileSystem fs = null;
        Path p = null;
        if (uriOrPath != null) {
            URI uri = SequenceFileUtility.convertToURI(uriOrPath);
            fs = this.getFileSystem(uri);
            p = new Path(uri.toString());
        }
        return this.findAndExport(key, fs, p, offset);
    }

    public boolean findAndExport(K key, FileSystem fs, Path dirPath, long offset) throws IOException {
        V value = this.find(key, offset);
        if (value == null) {
            return false;
        }
        if (fs != null && fs != null) {
            Path outFilePath = new Path(dirPath, key.toString());
            this.writeFile(fs, outFilePath, value);
        } else {
            this.printFile(value);
        }
        return true;
    }

    public Path getSequenceFilePath() {
        return this.sequenceFilePath;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        if (!this.isReader) {
            throw new UnsupportedOperationException("Cannot iterate in write mode");
        }
        return new SequenceFileIterator();
    }

    class SequenceFileIterator
    implements Iterator<Map.Entry<K, V>> {
        SequenceFile.Reader reader = null;
        Map.Entry<K, V> next;
        boolean shouldMove = true;

        public SequenceFileIterator() {
            try {
                this.reader = SequenceFileUtility.this.createReader();
                this.next = new SequenceFileEntry(SequenceFileUtility.this, (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)SequenceFileUtility.this.config), (Writable)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)SequenceFileUtility.this.config));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            this.tryGetNext();
            return this.next != null;
        }

        private void tryGetNext() {
            if (this.next != null && this.shouldMove) {
                this.shouldMove = false;
                try {
                    if (!this.reader.next((Writable)this.next.getKey(), (Writable)this.next.getValue())) {
                        this.next = null;
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException e) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public Map.Entry<K, V> next() {
            this.tryGetNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.shouldMove = true;
            return this.next;
        }

        @Override
        public void remove() {
        }
    }

    static class SequenceFileEntry
    implements Map.Entry<K, V> {
        K key;
        V value;
        final /* synthetic */ SequenceFileUtility this$0;

        public SequenceFileEntry(K k, V v) {
            this.this$0 = this$0;
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }
    }

    public static class RelativePathFilenameKeyProvider
    implements KeyProvider<Text> {
        @Override
        public Text getKey(FileSystem fs, Path path) {
            return new Text(path.toUri().getPath());
        }

        @Override
        public Text getKey(FileSystem fs, Path path, Path base) {
            return new Text(path.toUri().getPath().substring(base.toUri().getPath().length()));
        }
    }

    public static class FilenameKeyProvider
    implements KeyProvider<Text> {
        @Override
        public Text getKey(FileSystem fs, Path path) {
            return new Text(path.getName());
        }

        @Override
        public Text getKey(FileSystem fs, Path path, Path base) {
            return this.getKey(fs, path);
        }
    }

    public static class MD5UUIDKeyProvider
    implements KeyProvider<Text> {
        @Override
        public Text getKey(FileSystem fs, Path path) {
            UUID uuid = UUID.nameUUIDFromBytes(SequenceFileUtility.md5sum(fs, path).getBytes());
            return new Text(uuid.toString());
        }

        @Override
        public Text getKey(FileSystem fs, Path path, Path base) {
            return this.getKey(fs, path);
        }
    }

    public static interface KeyProvider<K> {
        public K getKey(FileSystem var1, Path var2);

        public K getKey(FileSystem var1, Path var2, Path var3);
    }
}

